/*
 * Decompiled with CFR 0.152.
 */
package jk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import jk.flr.H40;
import jk.flr.Hdr;
import jk.redis.FzRedisSubscriberListener;
import jk.redis.Updator;
import jk.slave.Rs485Server;
import jk.slave.RunDat_tmp;
import jk.slave.SlaveSite;
import jk.slave.SlaveSite_tmp;
import jk.slave.WebServer;
import jk.slave.WebSocketServer;
import jk.utils.RedisUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xsocket.WorkerPool;
import org.xsocket.datagram.Endpoint;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.IEndpoint;
import org.xsocket.datagram.UserDatagram;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

public class JkSlaver {
    public static final Logger log = LoggerFactory.getLogger(JkSlaver.class);
    public static final File homeDir = new File(SystemUtils.USER_DIR);
    public static ObjectMapper jsonMapperFmt = new ObjectMapper();
    public static ObjectMapper jsonMapperMini = new ObjectMapper();
    public static JedisPool jedisPool;
    public static FastDateFormat DF_yMdHms_V;
    public static FastDateFormat DF_yMdHms;
    public static FastDateFormat DF_dHm;
    public static FastDateFormat DF_HHmmss_V;
    public static FastDateFormat DF_s;
    public static FastDateFormat DF_HHmmss;
    public static FastDateFormat DF_yyyyMM;
    public static FastDateFormat DF_mmss;
    public static SlaveSite site;
    public static File dataDir;
    public static File webDir;
    public static Rs485Server rs485Server;
    static Thread mainThread;
    static long timeStart;
    static long timeLastMcuX;
    static int errTimes;
    static WebServer httpServer;
    static WorkerPool workerPool;
    static WebSocketServer wsktServer;
    static IEndpoint sUdpEndpoint;
    static String heartHost;
    static String master;
    static ConcurrentHashMap<String, Long> mastersIp;
    private static File siteFile;
    private static File stopFile;
    public static String scd;

    public static void startRedisService() {
        String rdsUrl = System.getProperty("redisUrl", "redis://admalf125vlladswsijkldkljdfsfds0rnmkds4rasftd@redis.xihewuye.cn:6379/2");
        try {
            jedisPool = RedisUtil.CreateJedisPool(rdsUrl, 1000, 10, 2);
            log.info("\u8fde\u63a5redis\u6210\u529f:" + rdsUrl);
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5redis\u5f02\u5e38:", e);
        }
        new Thread(new Updator()).start();
        RedisUtil.startSubscriber(jedisPool, new FzRedisSubscriberListener(), "fzkz:*");
    }

    static String status() {
        String tm = DateFormatUtils.format(System.currentTimeMillis(), "yyyy-MM-dd'T'HH:mm:ss'Z'");
        return String.format("tm=%s", tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRtd(JedisPool pool) {
        HashMap<String, String> hash = new HashMap<String, String>();
        SlaveSite site = JkSlaver.site;
        for (int i = 0; i < site.zl.length; ++i) {
            int jzh = i + 1;
            hash.put("gw2" + jzh, String.valueOf(site.zl[i][11]));
            hash.put("hw2" + jzh, String.valueOf(site.zl[i][12]));
            hash.put("hw1" + jzh, String.valueOf(site.zl[i][12]));
            hash.put("gy2" + jzh, String.valueOf(site.zl[i][8]));
            hash.put("hy2" + jzh, String.valueOf(site.zl[i][9]));
            hash.put("pl2" + jzh, String.valueOf(site.zl[i][3]));
            hash.put("dl2" + jzh, String.valueOf(site.zl[i][5]));
            hash.put("ll2" + jzh, String.valueOf(site.zl[i][1]));
            hash.put("pl1" + jzh, String.valueOf(site.zl[i][2]));
            hash.put("dl1" + jzh, String.valueOf(site.zl[i][4]));
        }
        hash.put("gw10", String.valueOf(site.calGw1()));
        hash.put("gy10", String.valueOf(site.calGy1()));
        hash.put("hy10", String.valueOf(site.calHy1()));
        hash.put("ll10", String.valueOf(site.zl[0][14]));
        String prekey = String.format("fzsj:%s:", scd);
        Jedis j = null;
        try {
            j = pool.getResource();
            Pipeline p = j.pipelined();
            for (Map.Entry e : hash.entrySet()) {
                p.setex(prekey + (String)e.getKey(), 60, (String)e.getValue());
            }
            String hkey = String.format("fzsd:%s", scd);
            p.hset(hkey, "jzs", String.valueOf(site.zl.length));
            p.set(prekey + "time", FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss").format(System.currentTimeMillis()));
            p.hset("fzlive", scd, JkSlaver.status());
            p.sync();
        }
        catch (Exception e) {
            log.error("Err:up-rtd:{}", (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(j);
        }
    }

    public static void main(String[] args) {
        String usage = "java jk.slave.JkSlaver start|stop";
        if (args.length == 0) {
            System.out.println(usage);
            args = new String[]{"start"};
        }
        if ("start".equals(args[0])) {
            JkSlaver.start(args);
        } else if ("stop".equals(args[0])) {
            JkSlaver.stop(args);
        } else {
            System.out.println(usage);
        }
    }

    public static void start(String[] args) {
        System.out.println("\u8bbe\u7f6eJVM\u53c2\u6570\uff1a -Djava.util.logging.config.file=logging.properties -Dlogs.dir=.");
        mainThread = Thread.currentThread();
        mainThread.setName("J_S_W");
        log.info("start...");
        if (stopFile.exists()) {
            stopFile.delete();
        }
        try {
            String webdir = System.getProperty("web.dir");
            if (webdir == null) {
                webdir = homeDir + "/web";
                System.out.println("web\u9875\u9762\u6839\u76ee\u5f55\u672a\u6307\u5b9a\uff08-Dweb.dir\uff09\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c:" + webdir);
            }
            webDir = new File(webdir);
            if (!JkSlaver.init()) {
                System.exit(2);
            }
            try {
                String msg = "I?" + jsonMapperMini.writeValueAsString(site).replaceAll("\\s+", "");
                UserDatagram pkg = new UserDatagram(master, 14000, msg.getBytes());
                sUdpEndpoint.send(pkg);
                log.info(pkg.getRemoteAddress() + ":UDP-->" + msg);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u7ad9\u70b9\u4fe1\u606f\u5f02\u5e38", e);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(0);
        }
        JkSlaver.zl_working();
    }

    public static void stop(String[] args) {
        Thread.currentThread().setName("J_S_S");
        log.info("stop...");
        System.exit(0);
        try {
            log.info("\u521b\u5efa\u505c\u6b62\u6587\u4ef6\uff0c\u8981\u6c42\u505c\u6b62\u5de5\u4f5c...");
            if (stopFile.createNewFile()) {
                log.info("\u521b\u5efa\u505c\u6b62\u6587\u4ef6\u6210\u529f\uff1a" + stopFile);
                log.info("\u4e3b\u7ebf\u7a0b\u72b6\u6001:" + (Object)((Object)mainThread.getState()));
                mainThread.interrupt();
            } else {
                log.info("\u521b\u5efa\u505c\u6b62\u6587\u4ef6\u5931\u8d25\uff1a" + stopFile);
            }
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u505c\u6b62\u6587\u4ef6\u51fa\u9519\uff0c\u5f3a\u5236\u9000\u51fa", e);
            System.exit(-1);
        }
    }

    static boolean init() throws Exception {
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        try {
            log.info("\u52a0\u8f7d\u7ad9\u70b9\u53c2\u6570..." + siteFile);
            site = jsonMapperFmt.readValue(siteFile, SlaveSite.class);
            scd = JkSlaver.site.code.toLowerCase();
        }
        catch (Exception e) {
            jsonMapperFmt.writeValue(new File(siteFile + ".template"), (Object)new SlaveSite());
            System.err.println("\u8bf7\u4fee\u6539\u53c2\u6570\u914d\u7f6e:" + siteFile);
            System.exit(1);
        }
        JkSlaver.startHttpServer();
        JkSlaver.startWebSocketServer();
        JkSlaver.startSUdpEndpoint(JkSlaver.site.udpPort);
        JkSlaver.startRs485Server();
        return true;
    }

    static boolean startRs485Server() {
        rs485Server = new Rs485Server(site, dataDir);
        rs485Server.start();
        return true;
    }

    static boolean startHttpServer() throws Exception {
        if (JkSlaver.site.httpPort <= 0) {
            return false;
        }
        if (!webDir.exists()) {
            throw new FileNotFoundException("web.dir\u5c5e\u6027\u6307\u5b9a\u7684Web\u76ee\u5f55\u4e0d\u5b58\u5728\uff1a" + webDir);
        }
        httpServer = new WebServer(workerPool, JkSlaver.site.httpPort, webDir.toString());
        httpServer.run();
        return true;
    }

    static void startWebSocketServer() {
        wsktServer = new WebSocketServer(workerPool, JkSlaver.site.wsktPort);
        wsktServer.run();
    }

    static void startSUdpEndpoint(int port) throws Exception {
        IDatagramHandler hdlr = new IDatagramHandler(){

            @Override
            public boolean onDatagram(IEndpoint edp) throws IOException {
                UserDatagram req = edp.receive(1000L);
                if (req == null) {
                    return true;
                }
                SocketAddress client = req.getRemoteSocketAddress();
                String msg = req.readString();
                log.info(Thread.currentThread().getName() + "@SUDP:[" + client + "]<--:" + req.getSize() + "::" + msg);
                if (msg.startsWith("C#")) {
                    String res = null;
                    try {
                        res = rs485Server.awaitRtCmd(msg.substring(2));
                    }
                    catch (Exception e) {
                        res = "ERR:" + e.toString();
                    }
                    UserDatagram pkg = new UserDatagram(req.getRemoteSocketAddress(), res.getBytes());
                    sUdpEndpoint.send(pkg);
                    log.info(String.format("[%s]UDP-->%s", req.getRemoteSocketAddress(), msg));
                } else {
                    if (msg.startsWith("R#")) {
                        msg = msg.substring(2);
                        String[] ps = msg.split("\\|", -1);
                        JkSlaver.site.myHost = ps[0];
                        String rmt = req.getRemoteAddress().getHostAddress();
                        if (ps.length > 2) {
                            try {
                                long ack = Long.parseLong(ps[2]);
                                Long tm = mastersIp.get(rmt);
                                if (tm == null || ack > tm) {
                                    mastersIp.put(rmt, ack);
                                }
                            }
                            catch (Exception e) {
                                log.error("\u89e3\u6790\u670d\u52a1\u5668UDP\u786e\u8ba4\u65f6\u6233\u5f02\u5e38" + ps[2], e);
                            }
                        } else {
                            log.warn("\u786e\u8ba4\u6d88\u606f\u7f3a\u5931\u65f6\u6233\uff0c\u8bf7\u5347\u7ea7\u4e3b\u7ad9\u7a0b\u5e8f\uff01");
                        }
                        return true;
                    }
                    if (msg.startsWith("QR#")) {
                        try {
                            String res = jsonMapperMini.writeValueAsString(JkSlaver.site.zl);
                            UserDatagram pkg = new UserDatagram(req.getRemoteSocketAddress(), res.getBytes());
                            sUdpEndpoint.send(pkg);
                            log.info(String.format("[%s]UDP-->%s", req.getRemoteSocketAddress(), msg));
                        }
                        catch (Exception e) {
                            log.error("\u5f02\u5e38", e);
                            throw new IOException(e);
                        }
                        return true;
                    }
                    if (msg.startsWith("GDD#")) {
                        try {
                            int addr;
                            String dat = msg.substring(4);
                            if (dat == null || dat.length() == 0) {
                                dat = "0";
                            }
                            dat = (addr = Integer.parseInt(dat)) >= 1 && addr <= JkSlaver.site.areaCount ? jsonMapperMini.writeValueAsString(JkSlaver.site.zl[addr - 1]) : jsonMapperMini.writeValueAsString(JkSlaver.site.zl);
                            UserDatagram pkg = new UserDatagram(req.getRemoteSocketAddress(), dat.getBytes());
                            sUdpEndpoint.send(pkg);
                            log.info(String.format("[%s]UDP-->%s", req.getRemoteSocketAddress(), msg));
                        }
                        catch (Exception e) {
                            log.error("\u5f02\u5e38", e);
                            throw new IOException(e);
                        }
                        return true;
                    }
                    if (msg.equalsIgnoreCase("I?")) {
                        msg = "I?" + jsonMapperMini.writeValueAsString(site).replaceAll("\\s+", "");
                        UserDatagram pkg = new UserDatagram(req.getRemoteSocketAddress(), msg.getBytes());
                        sUdpEndpoint.send(pkg);
                        log.info(String.format("[%s]UDP-->%s", req.getRemoteSocketAddress(), msg));
                        return true;
                    }
                    if (msg.startsWith("I?")) {
                        String scode = msg.substring(2).trim();
                        int mcuaddr = Integer.parseInt(StringUtils.substringAfter(scode, "_"));
                        SlaveSite_tmp s = new SlaveSite_tmp(mcuaddr, site);
                        msg = "I?" + jsonMapperMini.writeValueAsString(s).replaceAll("\\s+", "");
                        UserDatagram pkg = new UserDatagram(req.getRemoteSocketAddress(), msg.getBytes());
                        sUdpEndpoint.send(pkg);
                        log.info(String.format("[%s]UDP-->%s", req.getRemoteSocketAddress(), msg));
                        return true;
                    }
                    if (msg.equals("?")) {
                        msg = JkSlaver.genHeartMsg();
                        sUdpEndpoint.send(new UserDatagram(req.getRemoteSocketAddress(), msg.getBytes()));
                        log.info(String.format("[%s]UDP-->%s", req.getRemoteSocketAddress(), msg));
                    } else if (msg.startsWith("set#")) {
                        if ((msg = msg.substring("set#".length())).startsWith("dmps=")) {
                            if ("true".equalsIgnoreCase(msg = msg.substring("dmps=".length()))) {
                                Rs485Server.dmpsTest = true;
                            } else if ("true".equalsIgnoreCase(msg)) {
                                Rs485Server.dmpsTest = false;
                            }
                            msg = "ok:dmps=" + Rs485Server.dmpsTest;
                        }
                        sUdpEndpoint.send(new UserDatagram(req.getRemoteSocketAddress(), msg.getBytes()));
                        log.info(String.format("[%s]UDP-->%s", req.getRemoteSocketAddress(), msg));
                    } else {
                        sUdpEndpoint.send(new UserDatagram(req.getRemoteSocketAddress(), msg.getBytes()));
                    }
                }
                return true;
            }
        };
        int recvPkgSize = 1024;
        sUdpEndpoint = new Endpoint(recvPkgSize, hdlr, workerPool, InetAddress.getByName("0.0.0.0"), port);
        log.info("start SUDPServer Listening" + sUdpEndpoint.getLocalAddress() + ":" + sUdpEndpoint.getLocalPort());
    }

    static String genHeartMsg() {
        return String.format("%s@%s", JkSlaver.site.code, System.getenv("COMPUTERNAME"));
    }

    static void upResp(String msg, String rmt) {
        msg = msg.substring(2);
        String[] ps = msg.split("\\|", -1);
        JkSlaver.site.myHost = ps[0];
        mastersIp.put(rmt, Long.parseLong(ps[2]));
        log.warn("\u6536\u5230udp\u4e0a\u62a5\u786e\u8ba4:" + mastersIp);
        if (ps.length > 2) {
            try {
                long ack = Long.parseLong(ps[2]);
                mastersIp.put(rmt, ack);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u670d\u52a1\u5668UDP\u786e\u8ba4\u65f6\u6233\u5f02\u5e38" + ps[2], e);
            }
        } else {
            log.warn("\u786e\u8ba4\u6d88\u606f\u7f3a\u5931\u65f6\u6233\uff0c\u8bf7\u5347\u7ea7\u4e3b\u7ad9\u7a0b\u5e8f\uff01");
        }
    }

    static boolean wk_up_dat_http(int mcuAddr, long timeout) {
        try {
            RunDat_tmp r = new RunDat_tmp(mcuAddr, site);
            String sb = "R#" + jsonMapperMini.writeValueAsString(r);
            URL a = new URL(String.format("http://%s:55555/r/up?id=%s", master, r.code));
            URLConnection uc = a.openConnection();
            uc.setDoOutput(true);
            uc.setDoInput(true);
            OutputStream os = uc.getOutputStream();
            os.write(sb.getBytes("utf-8"));
            os.flush();
            os.close();
            InputStream is = uc.getInputStream();
            String res = IOUtils.toString(is, "utf-8");
            log.info("http-up:{}/{}", (Object)res, (Object)sb);
            JkSlaver.upResp(res, a.getHost());
            return true;
        }
        catch (Exception e) {
            log.error("http\u4e0a\u62a5\u5f02\u5e38:", e);
            return false;
        }
    }

    static boolean wk_up_dat(int mcuAddr, long timeout) {
        String sb = null;
        byte[] buf = null;
        try {
            log.info(String.format("\u673a\u7ec4%s: %s", mcuAddr, Arrays.toString(JkSlaver.site.zl[mcuAddr - 1])));
            RunDat_tmp r = new RunDat_tmp(mcuAddr, site);
            sb = "R#" + jsonMapperMini.writeValueAsString(r);
            log.info(String.format("\u673a\u7ec4%s: %s", mcuAddr, sb));
            if (r.ErrCodeS1 != 0 || r.ErrCodeS2[0] != 0) {
                log.warn(String.format("ErrCodeS1=%x, ErrCodeS2=%x", r.ErrCodeS1, r.ErrCodeS2[0]));
            }
            buf = sb.getBytes();
            UserDatagram pkg = new UserDatagram(heartHost, 14000, buf);
            sUdpEndpoint.send(pkg);
        }
        catch (Exception e) {
            log.error(String.format("UDP heartHost ERR[%d]\u673a\u7ec4-->%s:", mcuAddr, heartHost), e);
        }
        mastersIp.clear();
        String ip = null;
        int i = 1;
        while (true) {
            try {
                ip = InetAddress.getByName(master).getHostAddress();
                UserDatagram pkg = new UserDatagram(ip, 14000, buf);
                sUdpEndpoint.send(pkg);
                if (log.isDebugEnabled()) {
                    log.debug(mcuAddr + "#" + i + ":UDP-->" + sb);
                }
            }
            catch (Exception e) {
                log.error(String.format("UDP RunDat ERR[%d]\u673a\u7ec4-->%s:", mcuAddr, ip), e);
            }
            try {
                Thread.sleep(400L);
            }
            catch (Exception e) {
                break;
            }
            Long at = mastersIp.get(ip);
            if (at != null && at >= JkSlaver.site.zlTime[mcuAddr - 1]) {
                if (!log.isDebugEnabled()) break;
                log.debug(String.format("\u4e0a\u62a5[%ts], %s\u6b21\u540e\u63a5\u6536\u5230\u670d\u52a1\u5668\u786e\u8ba4\uff1a%ts", JkSlaver.site.zlTime[mcuAddr - 1], i, at));
                break;
            }
            if (System.currentTimeMillis() >= timeout) {
                log.warn(String.format("\u5206\u673a[%4$d]\u4e0a\u62a5[%1$tS], %2$s\u6b21\u540e\u8d85\u65f6[%3$tL]\uff1a\u672a\u63a5\u6536\u5230\u670d\u52a1\u5668\u786e\u8ba4", JkSlaver.site.zlTime[mcuAddr - 1], i, System.currentTimeMillis(), mcuAddr));
                break;
            }
            ++i;
        }
        return false;
    }

    static void zl_working() {
        String md1 = null;
        String js2 = null;
        String md2 = null;
        long[] lastSaveTime = new long[JkSlaver.site.areaCount];
        Hdr[] hdr = new Hdr[JkSlaver.site.areaCount];
        long time = 0L;
        long lastLiveTime = 0L;
        long lastCheckTime = 0L;
        while (true) {
            time = System.currentTimeMillis();
            if (stopFile.exists()) {
                if (!stopFile.delete()) {
                    stopFile.deleteOnExit();
                }
                break;
            }
            if (time - lastCheckTime > 60000L) {
                try {
                    if (md1 == null) {
                        md1 = DigestUtils.md5Hex(jsonMapperFmt.writeValueAsString(site));
                    } else {
                        js2 = jsonMapperFmt.writeValueAsString(site);
                        md2 = DigestUtils.md5Hex(js2);
                        if (!md1.equals(md2)) {
                            File oldSf = new File(siteFile.getAbsoluteFile() + "." + DF_yMdHms.format(System.currentTimeMillis()));
                            log.warn("\u68c0\u6d4b\u5230\u7ad9\u70b9\u914d\u7f6e\u53d8\u66f4\uff0c\u4fdd\u5b58\u5386\u53f2\u914d\u7f6e\uff1a" + oldSf);
                            if (siteFile.renameTo(oldSf)) {
                                jsonMapperFmt.writeValue(siteFile, (Object)site);
                                md1 = md2;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff1a" + siteFile, e);
                }
            }
            for (int i = 0; i < JkSlaver.site.areaCount; ++i) {
                if (lastSaveTime[i] >= JkSlaver.site.zlTime[i]) continue;
                String fn = String.format("%1$s-%2$02x-%3$tY%3$tm.flr", JkSlaver.site.code, i + 1, JkSlaver.site.zlTime[i]);
                File datFile = new File(dataDir, fn);
                int id = 0;
                long addr = -1L;
                try {
                    if (!datFile.exists()) {
                        if (!datFile.getParentFile().exists()) {
                            datFile.getParentFile().mkdirs();
                        }
                        hdr[i] = new Hdr(JkSlaver.site.meta, JkSlaver.site.code + ":" + JkSlaver.site.name);
                        hdr[i].btime = JkSlaver.site.zlTime[i];
                        H40.writeHeader(datFile, hdr[i]);
                    } else if (hdr[i] == null) {
                        hdr[i] = H40.readHeader(datFile);
                        if (!hdr[i].match(new Hdr(JkSlaver.site.meta, ""))) {
                            System.err.println("\u6570\u636e\u6587\u4ef6\u5934\u6570\u636e\u4e0d\u5339\u914d\uff1a" + hdr[i]);
                            System.exit(1);
                        }
                    }
                    int[] record = ArrayUtils.addAll(JkSlaver.site.zl[i], JkSlaver.site.sv[i]);
                    id = Hdr.calRecordId(JkSlaver.site.zlTime[i], hdr[i]);
                    addr = Hdr.calRecordAddr(id, hdr[i]);
                    byte[] buf = H40.encodeRecord(hdr[i], record);
                    H40.write(datFile, addr, buf);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("\u4fdd\u5b58[%1$tT.%1$tL]\u6570\u636e\u5230[%2$s: %3$x]\u6210\u529f:%4$s", JkSlaver.site.zlTime[i], fn, addr, Arrays.asList(ArrayUtils.toObject(record))));
                    }
                    lastSaveTime[i] = JkSlaver.site.zlTime[i];
                }
                catch (Exception e2) {
                    log.error(String.format("\u4fdd\u5b58[%1$tT.%1$tL]\u6570\u636e\u5230[%2$s]\u5931\u8d25:", JkSlaver.site.zlTime[i], fn), e2);
                }
                try {
                    if (null != System.getProperty("up")) {
                        JkSlaver.wk_up_dat_http(i + 1, System.currentTimeMillis() + 2000L);
                        continue;
                    }
                    JkSlaver.wk_up_dat(i + 1, System.currentTimeMillis() + 2000L);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u5f02\u5e38", e);
                }
            }
            if (time - lastLiveTime > 60000L) {
                try {
                    sUdpEndpoint.send(new UserDatagram(heartHost, 14000, JkSlaver.genHeartMsg().getBytes()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        log.info("\u68c0\u6d4b\u5230\u505c\u6b62\u6587\u4ef6:" + stopFile);
        log.info("\u7ed3\u675f\uff0c\u9000\u51fa\u5de5\u4f5c.");
        System.exit(0);
    }

    static {
        DF_yMdHms_V = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss");
        DF_yMdHms = FastDateFormat.getInstance("yyyyMMddHHmmss");
        DF_dHm = FastDateFormat.getInstance("ddHHmm");
        DF_HHmmss_V = FastDateFormat.getInstance("HH:mm:ss");
        DF_s = FastDateFormat.getInstance("s");
        DF_HHmmss = FastDateFormat.getInstance("HHmmss");
        DF_yyyyMM = FastDateFormat.getInstance("yyyyMM");
        DF_mmss = FastDateFormat.getInstance("mmss");
        dataDir = new File(homeDir, "data");
        timeStart = System.currentTimeMillis();
        workerPool = new WorkerPool(1, 30, 10L, TimeUnit.SECONDS, 10, true);
        heartHost = "gnjk.xihewuye.cn";
        master = "gnjk.xihewuye.cn";
        mastersIp = new ConcurrentHashMap();
        siteFile = new File(homeDir, "etc/slave.json");
        stopFile = new File(homeDir, "stop");
        jsonMapperFmt.configure(SerializationFeature.INDENT_OUTPUT, true);
        jsonMapperMini.configure(SerializationFeature.INDENT_OUTPUT, false);
    }
}

