/*
 * Decompiled with CFR 0.152.
 */
package jk.flr;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import jk.JkSlaver;
import jk.flr.Hdr;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.log4j.Logger;

public class H40 {
    private static final Logger log = Logger.getLogger(H40.class);

    public static byte[] encodeRecord(Hdr hdr, int[] record) {
        byte[] buf = new byte[hdr.rlen];
        ByteBuffer b = ByteBuffer.wrap(buf);
        block5: for (int i = 0; i < hdr.clen; ++i) {
            switch (hdr.meta[i]) {
                case 1: {
                    b.put((byte)record[i]);
                    continue block5;
                }
                case 2: {
                    b.putShort((short)record[i]);
                    continue block5;
                }
                case 4: {
                    b.putInt(record[i]);
                    continue block5;
                }
                default: {
                    b.position(b.position() + Math.abs(hdr.meta[i]));
                }
            }
        }
        return buf;
    }

    public static int[] decodeRecord(Hdr hdr, byte[] buf) {
        int[] rec = new int[hdr.clen];
        ByteBuffer b = ByteBuffer.wrap(buf);
        block5: for (int i = 0; i < hdr.clen; ++i) {
            switch (hdr.meta[i]) {
                case 1: {
                    rec[i] = b.get();
                    continue block5;
                }
                case 2: {
                    rec[i] = b.getShort();
                    continue block5;
                }
                case 4: {
                    rec[i] = b.getInt();
                    continue block5;
                }
                default: {
                    b.position(b.position() + Math.abs(hdr.meta[i]));
                }
            }
        }
        return rec;
    }

    static int read(RandomAccessFile file, long addr, byte[] buf) throws IOException {
        file.seek(addr);
        return file.read(buf);
    }

    static long write(RandomAccessFile file, long addr, byte[] buf) throws IOException {
        file.seek(addr);
        file.write(buf);
        return file.getFilePointer();
    }

    public static long write(File file, long addr, byte[] buf) throws IOException {
        RandomAccessFile _raf = null;
        try {
            _raf = new RandomAccessFile(file, "rw");
            long l = H40.write(_raf, addr, buf);
            return l;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (_raf != null) {
                try {
                    _raf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static int read(File file, long addr, byte[] buf) throws IOException {
        RandomAccessFile _raf = null;
        try {
            _raf = new RandomAccessFile(file, "rw");
            int n = H40.read(_raf, addr, buf);
            return n;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (_raf != null) {
                try {
                    _raf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Hdr readHeader(File file) throws IOException {
        byte[] buf = new byte[2];
        H40.read(file, 0L, buf);
        buf = new byte[Short.parseShort(String.format("%02x%02x", buf[0], buf[1]), 16)];
        H40.read(file, 0L, buf);
        return Hdr.decodeHeader(buf);
    }

    public static long writeHeader(File file, Hdr hdr) throws IOException {
        return H40.write(file, 0L, Hdr.encodeHeader(hdr));
    }

    public static long writeRecord(Hdr hdr, File datFile, long time, int[] rec) throws IOException {
        if (!datFile.exists()) {
            if (!datFile.getParentFile().exists()) {
                datFile.getParentFile().mkdirs();
            }
            hdr.btime = time;
            H40.writeHeader(datFile, hdr);
        }
        int id = Hdr.calRecordId(time, hdr);
        long addr = Hdr.calRecordAddr(id, hdr);
        byte[] buf = H40.encodeRecord(hdr, rec);
        H40.write(datFile, addr, buf);
        return addr;
    }

    public static void readRecord(File dir, String fnt, long stime, int row, long interval, List<int[]> rslt) throws IOException {
        String fnl = String.format(fnt, stime);
        String fnc = null;
        File file = new File(dir, fnl);
        Hdr hdr = H40.readHeader(file);
        long step = row > 0 ? interval : -interval;
        long time = stime;
        long addr = 0L;
        int id = 0;
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        byte[] buf = new byte[hdr.rlen];
        for (int i = 0; i < Math.abs(row); ++i) {
            fnc = String.format(fnt, time += step);
            if (!fnl.equalsIgnoreCase(fnc)) {
                fnl = fnc;
                file = new File(dir, fnl);
                if (raf != null) {
                    raf.close();
                }
                if (!file.exists()) break;
                hdr = H40.readHeader(file);
                raf = new RandomAccessFile(file, "r");
            }
            id = Hdr.calRecordId(time, hdr);
            addr = Hdr.calRecordAddr(id, hdr);
            if (log.isDebugEnabled()) {
                log.debug(String.format(i + "\uff1a\u8bfb[%1$tM:%1$tS]:[%2$x]=[%3$x]", time, addr, file.length()));
            }
            hdr.getClass();
            if (addr < 128L || addr > file.length()) {
                String t1 = JkSlaver.DF_yMdHms_V.format(time);
                String bt = JkSlaver.DF_yMdHms_V.format(hdr.btime);
                log.warn(String.format("[%1$s : %5$s]\u8bfb\u7b2c[%2$d]\u6761[%3$s]\u6570\u636e[%4$x]\u5230\u5934:[%6$x]", fnl, i, t1, addr, bt, file.length()));
                break;
            }
            H40.read(raf, addr, buf);
            int[] rec = H40.decodeRecord(hdr, buf);
            if (log.isDebugEnabled()) {
                log.debug(String.format(i + "\uff1a\u8bfb[%1$tM:%1$tS]:[%2$x]=\u6210\u529f...[%3$02x]", time, addr, rec[0]));
            }
            rslt.add(rec);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        int[] meta = new int[]{1, 2, 4, 1, 2, 1, -5};
        Hdr hdr = new Hdr(meta, "\u5409\u6797\u77ed\u4fe1");
        File f = new File("d:/aa.flr");
        String info = "1101-01-201405.flr, \u5409\u6797\u77ed\u4fe1";
        long time = System.currentTimeMillis();
        int cnt = 2;
        Integer[][] zl = new Integer[cnt][4];
        Integer[][] sv = new Integer[cnt][2];
        for (int r = 0; r < 10; ++r) {
            time += 6000L;
            int mn = 1;
            int mi = 0;
            while (mi < cnt) {
                int i;
                long st = System.nanoTime();
                long t1 = System.currentTimeMillis();
                for (i = 0; i < zl[mi].length; ++i) {
                    zl[mi][i] = RandomUtils.nextInt(127);
                }
                Thread.sleep(400L);
                for (i = 0; i < sv[mi].length; ++i) {
                    sv[mi][i] = RandomUtils.nextInt(127);
                }
                Integer[] rec = (Integer[])ArrayUtils.addAll(zl[mi], sv[mi]);
                f = new File("d:/flr", String.format("%1$04x-%2$02x-%3$tY%3$tm.r%4$02x", 4353, mn, time, hdr.rlen));
                System.out.println(f);
                long addr = H40.writeRecord(hdr, f, time, ArrayUtils.toPrimitive(rec));
                long et = System.nanoTime() - st;
                log.debug(String.format(f.getName() + ":\u5199%s\u5230%x\u82b1\u8d39%d\u7eb3\u79d2", Arrays.asList(rec), addr, et));
                Thread.sleep(t1 + 750L - System.currentTimeMillis());
                ++mi;
                ++mn;
            }
        }
    }
}

