/*
 * Decompiled with CFR 0.152.
 */
package jk.flr;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Calendar;

public class Hdr {
    public boolean syncBtime = false;
    public String info;
    public Integer[] meta;
    public int clen;
    public int rlen;
    public final int hlen = 128;
    public long btime = System.currentTimeMillis();
    public int cycle = 6000;

    public Hdr() {
    }

    public Hdr(int[] meta, String info) {
        this.meta = new Integer[meta.length];
        for (int i = meta.length - 1; i >= 0; --i) {
            this.meta[i] = meta[i];
            ++this.clen;
            this.rlen += Math.abs(this.meta[i]);
        }
        if (info != null) {
            this.info = info.trim();
        }
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String toString() {
        return String.format("%d,%d,%d%s:%s", 128, this.rlen, this.clen, Arrays.asList(this.meta), this.info);
    }

    public boolean match(Hdr ins) {
        int i;
        if (this.cycle != ins.cycle || this.rlen != ins.rlen || this.hlen != ins.hlen) {
            return false;
        }
        int m = Math.min(this.clen, ins.clen);
        for (i = 0; i < m - 1; ++i) {
            if (Math.abs(this.meta[i]) == Math.abs(ins.meta[i])) continue;
            return false;
        }
        return this.meta[i] <= 0 || ins.meta[i] <= 0 || this.meta[i] == ins.meta[i];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Hdr)) {
            return false;
        }
        Hdr ins = (Hdr)obj;
        if (this.cycle != ins.cycle || this.rlen != ins.rlen || this.clen != ins.clen || this.hlen != ins.hlen) {
            return false;
        }
        for (int i = 0; i < this.clen; ++i) {
            if (this.meta[i] == ins.meta[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] encodeHeader(Hdr hdr) {
        byte[] buf = new byte[hdr.hlen];
        ByteBuffer b = ByteBuffer.wrap(buf);
        b.putShort((short)hdr.hlen);
        b.putLong(hdr.btime / (long)hdr.cycle * (long)hdr.cycle);
        b.putInt(hdr.cycle);
        b.put((byte)hdr.rlen);
        b.put((byte)hdr.clen);
        Integer[] integerArray = hdr.meta;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int m = integerArray[i];
            b.put((byte)m);
        }
        if (hdr.info != null) {
            b.put(hdr.info.getBytes());
        }
        return buf;
    }

    public static Hdr decodeHeader(byte[] buf) {
        Hdr h = new Hdr();
        ByteBuffer b = ByteBuffer.wrap(buf);
        b.getShort();
        h.btime = b.getLong();
        h.cycle = b.getInt();
        h.rlen = b.get();
        h.clen = b.get();
        h.meta = new Integer[h.clen];
        for (int i = 0; i < h.clen; ++i) {
            h.meta[i] = new Integer(b.get());
        }
        h.info = new String(buf, b.position(), h.hlen - b.position()).trim();
        return h;
    }

    public static int calRecordId(long time, Hdr hdr) {
        return (int)((time - hdr.btime) / (long)hdr.cycle);
    }

    public static long calRecordAddr(long recId, Hdr hdr) {
        hdr.getClass();
        return 128L + recId * (long)hdr.rlen;
    }

    public static long calBeginTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTimeInMillis();
    }
}

