/*
 * Decompiled with CFR 0.152.
 */
package jk.redis;

import jk.JkSlaver;
import jk.redis.Updator;
import jk.utils.CRC16;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class FzRedisSubscriberListener
extends JedisPubSub {
    private String scd;

    public FzRedisSubscriberListener() {
        this.scd = JkSlaver.site.code;
    }

    boolean hasMe(String targets) {
        String[] scds = targets.split(",");
        for (int i = 0; i < scds.length; ++i) {
            if (this.scd != scds[i].trim()) continue;
            return true;
        }
        return false;
    }

    void dealMsg(String channel, String message) {
        try {
            String[] cols = StringUtils.split(message, ",");
            if (cols[0].equalsIgnoreCase("setv")) {
                int jzh = Integer.parseInt(cols[1]);
                int gnm = Integer.parseInt(cols[2]);
                int val = Integer.parseInt(cols[3]);
                if ("jjzl".equalsIgnoreCase(JkSlaver.site.code) && gnm == 34 && jzh == 1) {
                    val /= 2;
                }
                String cmd = String.format("%02x%02x%04x", jzh, gnm, val);
                cmd = cmd + CRC16.calCrc16(cmd, true);
                String res = JkSlaver.rs485Server.awaitRtCmd(cmd);
                Jedis j = JkSlaver.jedisPool.getResource();
                j.hset("fztx:" + JkSlaver.site.code.toLowerCase(), "setv", cmd + "=" + res + "@" + JkSlaver.DF_yMdHms.format(System.currentTimeMillis()));
                j.close();
            } else if ("tzsb".equalsIgnoreCase(cols[0])) {
                int jzh = Integer.parseInt(cols[1]);
                String cmd = "0" + jzh + "81";
                cmd = cmd + CRC16.calCrc16(cmd, true);
                String res = JkSlaver.rs485Server.awaitRtCmd(cmd);
                Jedis j = JkSlaver.jedisPool.getResource();
                j.hset("fztx:" + JkSlaver.site.code.toLowerCase(), "tzsb", cmd + "=" + res + "@" + JkSlaver.DF_yMdHms.format(System.currentTimeMillis()));
                j.close();
            } else if ("qdsb".equalsIgnoreCase(cols[0])) {
                int jzh = Integer.parseInt(cols[1]);
                String cmd = "0" + jzh + "80";
                cmd = cmd + CRC16.calCrc16(cmd, true);
                String res = JkSlaver.rs485Server.awaitRtCmd(cmd);
                Jedis j = JkSlaver.jedisPool.getResource();
                j.hset("fztx:" + JkSlaver.site.code.toLowerCase(), "qdsb", cmd + "=" + res + "@" + JkSlaver.DF_yMdHms.format(System.currentTimeMillis()));
                j.close();
            }
        }
        catch (Exception e) {
            Updator.redisLog.error(channel + ":\u5904\u7406\u6d88\u606f\u5931\u8d25:" + message, e);
        }
    }

    @Override
    public void onMessage(String channel, String message) {
        Updator.redisLog.info(channel + ":\u63a5\u6536\u6d88\u606f:" + message);
        if (!channel.startsWith("fzkz:") || !this.hasMe(channel.substring(5))) {
            return;
        }
        Updator.redisLog.info(channel + ":\u7ed9\u6211\u7684\u547d\u4ee4:" + message);
    }

    @Override
    public void onSubscribe(String channel, int subscribedChannels) {
        Updator.redisLog.info("{},\u6ce8\u518c\u8ba2\u9605,onSubscribe:{}", (Object)this.scd, (Object)channel);
    }

    @Override
    public void onUnsubscribe(String channelName, int subscribedChannels) {
        Updator.redisLog.info("{},\u53d6\u6d88\u8ba2\u9605onUnsubscribe:{}", (Object)this.scd, (Object)channelName);
    }

    @Override
    public void onPMessage(String pattern, String channel, String message) {
        super.onPong(pattern);
        System.out.println(pattern + "\t" + channel + ":onPMessage<---" + message);
        this.dealMsg(channel, message);
    }

    @Override
    public void onPSubscribe(String pattern, int subscribedChannels) {
        super.onPSubscribe(pattern, subscribedChannels);
        System.out.println("onPSubscribe:" + pattern + "\t" + subscribedChannels);
    }

    @Override
    public void onPUnsubscribe(String pattern, int subscribedChannels) {
        super.onPUnsubscribe(pattern, subscribedChannels);
        System.out.println("onPUnsubscribe:" + pattern + "\t" + subscribedChannels);
    }

    @Override
    public void onPong(String pattern) {
        super.onPong(pattern);
        System.out.println("onPong:" + pattern);
    }
}

