/*
 * Decompiled with CFR 0.152.
 */
package jk.slave;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import jk.JkSlaver;
import jk.flr.H40;
import jk.flr.Hdr;
import jk.slave.SlaveSite;
import jk.sp.CommPortUtil;
import jk.utils.CRC16;
import jk.utils.LljUtil;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rs485Server
extends Thread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Rs485Server.class);
    private static final Logger logDmps = LoggerFactory.getLogger("dmps");
    public static final byte FC_FIX_READ = 64;
    public static final byte FC_FIX_IDLE = 0;
    public static final int CYCLE = 6000;
    public final long txPeriod = 750L;
    public final int ctrlSlotNum = 1;
    public final int mcuSlotNum = 7;
    public final int recvTimeout = 200;
    Lock lock = new ReentrantLock();
    Condition lkOk_FixRead = this.lock.newCondition();
    Condition lkOk_RtCmd = this.lock.newCondition();
    public String id_;
    File dataDir;
    private final byte[][] req_FixRead = new byte[8][];
    private byte[] req_SsLl;
    private final SlaveSite site;
    private byte[] rtCmdReq;
    private byte[] rtCmdRes;
    public static boolean dmpsTest = !"false".equalsIgnoreCase(System.getProperty("dmps"));
    public static boolean dmps;
    public static int dmpsMax;
    List<byte[]> svCmds = new ArrayList<byte[]>();
    int read_sv2_fc_j = 0;
    long read_sv2_fc_time = 0L;
    H40 h40;
    Hdr hdr;

    public Rs485Server(SlaveSite site, File dataDir) {
        this.site = site;
        this.dataDir = dataDir;
        this.hdr = new Hdr(site.meta, site.code + ":" + site.name);
        for (byte i = 0; i < this.req_FixRead.length; i = (byte)(i + 1)) {
            this.req_FixRead[i] = Rs485Server.encFixRead(i);
        }
    }

    @Override
    public String toString() {
        if (this.id_ == null) {
            this.id_ = new ToStringBuilder(this).append(this.site.areaCount).append(750L).toString();
        }
        return this.id_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String zl_autoCheckDevPort() throws Exception {
        byte[] buf = new byte[]{1, 64, 1, -48};
        byte[] rBuf = new byte[30];
        Map<String, Boolean> ports = CommPortUtil.checkSerialPortStatus();
        log.info("\u68c0\u6d4b\u5230\u6709\u6548\u7aef\u53e3:" + ports);
        for (Map.Entry<String, Boolean> port : ports.entrySet()) {
            String pk = port.getKey();
            boolean pv = port.getValue();
            if (!pv) continue;
            SerialPort sp = null;
            InputStream is = null;
            OutputStream os = null;
            int len = 0;
            try {
                sp = CommPortUtil.openSerialPort(pk, 500);
                is = sp.getInputStream();
                while ((len = is.read(rBuf)) > 0) {
                }
                os = sp.getOutputStream();
                int okt = 0;
                long stime = 0L;
                for (int i = 0; i < 3; ++i) {
                    stime = System.currentTimeMillis();
                    os.write(buf);
                    len = is.read(rBuf);
                    if (len != 28 || rBuf[0] != 1) continue;
                    ++okt;
                    try {
                        Thread.sleep(stime + 750L - System.currentTimeMillis());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (okt <= true) continue;
                String string = pk;
                return string;
            }
            catch (Exception exception) {}
            continue;
            finally {
                if (sp == null) continue;
                sp.close();
            }
        }
        return null;
    }

    public String awaitRtCmd(String cmd) throws Exception {
        this.lock.lock();
        try {
            this.rtCmdReq = Hex.decodeHex(cmd.toCharArray());
            this.lkOk_RtCmd.await();
            if (this.rtCmdRes != null) {
                String string = Hex.encodeHexString(this.rtCmdRes);
                return string;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    public void awaitFixReadDat() throws InterruptedException {
        this.lock.lock();
        try {
            this.lkOk_FixRead.await();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static int calClock(Calendar cal) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        int v = cal.get(11) * 10 + cal.get(12) / 6;
        return v;
    }

    protected void do_FixIdle(SerialPort serialPort) throws Exception {
        byte[] buf = new byte[]{0, 0, 0, 0};
        buf[1] = (byte)Rs485Server.calClock(null);
        int crc = CRC16.modbus_crc16_rtu(buf, 0, 2);
        buf[2] = (byte)(crc & 0xFF);
        buf[3] = (byte)(crc >> 8 & 0xFF);
        CommPortUtil.send(serialPort, buf);
    }

    int xzv(int addr, int idx, int val) {
        if (val == 65263) {
            return val;
        }
        if (idx == 13 && val == 255) {
            return -1;
        }
        if (this.site.rxm == null) {
            return val;
        }
        String m = this.site.rxm.get(String.format("%1$d.%2$d", addr, idx));
        if (m == null) {
            return val;
        }
        if (m.startsWith("A:")) {
            return val >> Byte.parseByte(m.substring(2));
        }
        throw new RuntimeException("\u672a\u8bc6\u522b\u7684\u4fee\u6b63\u65b9\u5f0f:" + m);
    }

    byte[] do_fixRead(SerialPort serialPort, long time, int mcuIdx, byte[] sBuf, byte[] rBuf) throws Exception {
        int mcuAddr = mcuIdx + 1;
        int len = CommPortUtil.sendAndRecv(serialPort, sBuf, rBuf, 200);
        if (len < rBuf.length) {
            rBuf = ArrayUtils.subarray(rBuf, 0, len);
        }
        if (rBuf[0] != sBuf[0]) {
            throw new IOException(String.format("\u56fa\u5b9a\u8bfb\u5f02\u5e38:S[%s],R[%s]:\u5730\u5740\u4e0d\u5339\u914d", Hex.encodeHexString(sBuf), Hex.encodeHexString(rBuf)));
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(rBuf, 1, len));
        int idx = 0;
        int val = dis.readShort() & 0xFFFF;
        if (this.site.qszl.contains(String.format("%d.%d", mcuAddr, idx))) {
            val = -2;
        } else if ((val & 0x8000) == 0) {
            this.site.hOn[mcuIdx] = (val & 0x1000) != 0;
            this.site.sOn[mcuIdx] = this.site.hOn[mcuIdx] && (val & 0x800) != 0;
            this.site.b1w[mcuIdx] = (val & 0x4000) != 0;
            this.site.b2w[mcuIdx] = (val & 0x2000) != 0;
            val |= 1;
        } else {
            int ea = val >> 12 & 7;
            int ev = val & 0xFFF;
            if (ea == 6 && (ev &= 0xFF) > 100) {
                ev = 100;
            }
            if (mcuIdx == 0 && ea == 2) {
                ev *= 2;
            }
            this.site.sv[mcuIdx][ea] = ev;
            val = 1;
        }
        this.site.zl[mcuIdx][idx++] = val;
        while (idx < 13) {
            val = dis.readShort() & 0xFFFF;
            if ("YYXQ".equalsIgnoreCase(this.site.code) && rBuf[0] == 1 && idx == 10) {
                if (dmpsTest && val < 24576) {
                    dmps = true;
                    log.warn("dmps=" + dmps);
                } else {
                    dmps = false;
                }
                logDmps.info("dmps:enable={}, gw11={}, dmps={}", dmpsTest, String.format("%04x", val), dmps);
            } else {
                val = this.site.qszl.contains(String.format("%d.%d", mcuAddr, idx)) ? -2 : (val == 65263 ? -1 : this.xzv(sBuf[0], idx, val));
                this.site.zl[mcuIdx][idx] = val;
            }
            ++idx;
        }
        val = dis.read() & 0xFF;
        val = this.site.qszl.contains(String.format("%d.%d", mcuAddr, idx)) ? -2 : (val == 255 ? -1 : this.xzv(sBuf[0], 13, val));
        this.site.zl[mcuIdx][idx++] = val;
        dis.close();
        return rBuf;
    }

    public static byte[] encFixRead(byte addr) {
        byte[] buf = new byte[]{(byte)(addr + 1), 64, 0, 0};
        CRC16.pad_modbus_crc16(buf);
        return buf;
    }

    int do_readLL_2(SerialPort serialPort, int addr) throws Exception {
        int ll = LljUtil.tx485_read_SsLl_P2(serialPort, (byte)addr);
        if (log.isDebugEnabled()) {
            log.debug(String.format("%d#\u6d41\u91cf\u8ba1=%d", addr, ll));
        }
        return ll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info(String.format("%s\uff0c\u542f\u52a8\u6210\u529f\uff01", this));
        int cmdCycleNo = 0;
        int readCycleNo = 0;
        int idleCycleNo = 0;
        int cycleNo = 0;
        int slotNum = 8;
        long time = 0L;
        String serialPortName = System.getProperty("com");
        CommPort serialPort = null;
        boolean saveOk = false;
        boolean svinited = false;
        int serialPortErrCount = 0;
        String[] lljdz = System.getProperty("ecwLljDz", "8,9,10,6").split(",");
        byte[] ecwLljDz = new byte[lljdz.length];
        for (int i = 0; i < ecwLljDz.length; ++i) {
            try {
                ecwLljDz[i] = NumberUtils.toByte(lljdz[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initCmd();
        byte zLljDz = NumberUtils.toByte(System.getProperty("zLljDz", "7"));
        while (!Thread.interrupted()) {
            try {
                if (serialPortErrCount > 5) {
                    serialPort.close();
                    serialPort = null;
                }
                if (serialPortName == null) {
                    try {
                        serialPortName = Rs485Server.zl_autoCheckDevPort();
                    }
                    catch (Exception e) {
                        log.error("\u5f02\u5e38", e);
                    }
                    if (serialPortName == null) {
                        log.warn("\u672a\u68c0\u6d4b\u5230\u4ece\u673a...\uff0c\u8bf7\u901a\u8fc7\u4e32\u53e3\u8fde\u63a5\u4ece\u673a\uff01\uff01");
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    if (serialPort != null) {
                        serialPort.close();
                    }
                    serialPort = null;
                }
                if (serialPort == null) {
                    try {
                        CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier(serialPortName.toUpperCase());
                        serialPort = (SerialPort)commPortIdentifier.open(this.getClass().getSimpleName(), 1000);
                        ((SerialPort)serialPort).setSerialPortParams(9600, 8, 1, 0);
                        serialPort.enableReceiveTimeout(this.recvTimeout);
                        log.info(String.format("\u6253\u5f00\u4e32\u53e3[%1$s]\u6210\u529f[%3$d,%4$d,%5$d,%6$d], \u63a5\u6536\u8d85\u65f6[%2$d]\u6beb\u79d2", serialPort.getName(), serialPort.getReceiveTimeout(), ((SerialPort)serialPort).getBaudRate(), ((SerialPort)serialPort).getDataBits(), ((SerialPort)serialPort).getStopBits(), ((SerialPort)serialPort).getParity()));
                        time = System.currentTimeMillis() / 6000L * 6000L + 6000L;
                    }
                    catch (Exception e) {
                        log.error("\u6253\u5f00\u4e32\u53e3\u5931\u8d25:" + serialPortName, e);
                        serialPortName = null;
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (Exception e1) {
                            break;
                        }
                    }
                }
                try {
                    this.read_sv2((SerialPort)serialPort);
                }
                catch (Exception e) {
                    log.error("\u521d\u59cb\u5316\u8bfb\u53d6\u5404\u673a\u7ec4\u8bbe\u5b9a\u503c\u5f02\u5e38", e);
                }
                cycleNo = (cmdCycleNo + readCycleNo + idleCycleNo) % slotNum;
                if (cycleNo == 0) {
                    idleCycleNo = 0;
                    readCycleNo = 0;
                    cmdCycleNo = 0;
                    cycleNo = 0;
                }
                time += 750L;
                try {
                    Thread.sleep(time - System.currentTimeMillis());
                }
                catch (IllegalArgumentException e) {
                }
                catch (InterruptedException e) {
                    break;
                }
                if (this.rtCmdReq != null && cmdCycleNo == 0) {
                    ++cmdCycleNo;
                    this.rtCmdRes = new byte[32];
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("CmdCycle:%1$tS.%1$tL\t%2$s\t%3$tS.%3$tL", time, cycleNo, System.currentTimeMillis()));
                    }
                    this.lock.lock();
                    try {
                        int len = CommPortUtil.sendAndRecv((SerialPort)serialPort, this.rtCmdReq, this.rtCmdRes, 200);
                        this.rtCmdRes = Arrays.copyOfRange(this.rtCmdRes, 0, len);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("\u6267\u884c\u6307\u4ee4\u51fa\u9519:", e);
                        ++serialPortErrCount;
                        continue;
                    }
                    finally {
                        this.rtCmdReq = null;
                        this.lkOk_RtCmd.signalAll();
                        this.lock.unlock();
                        continue;
                    }
                }
                if (readCycleNo < 7) {
                    int mcuIdx = readCycleNo++;
                    if (this.site.hasQjLlj && readCycleNo == 7) {
                        int ll = -1;
                        try {
                            ll = LljUtil.tx485_read_SsLl_MBmag((SerialPort)serialPort, zLljDz);
                            serialPortErrCount = 0;
                        }
                        catch (Exception e) {
                            log.error("\u8bfb\u53d6\u6d41\u91cf\u8ba1\u5f02\u5e38", e);
                            ++serialPortErrCount;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Read-zLlj:%s, A:%s, V:%s", cycleNo, zLljDz, ll));
                        }
                        for (int i = 0; i < this.site.areaCount; ++i) {
                            this.site.zl[i][14] = ll;
                        }
                        continue;
                    }
                    byte[] sBuf = this.req_FixRead[mcuIdx];
                    byte[] rBuf = new byte[32];
                    if (readCycleNo <= this.site.areaCount) {
                        this.lock.lock();
                        this.site.zlTime[mcuIdx] = System.currentTimeMillis() / this.site.cycle * this.site.cycle;
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("FixReadCycle:%1$tS.%1$tL\t%2$s\t%3$tS.%3$tL %4$s", time, cycleNo, System.currentTimeMillis(), readCycleNo - 1));
                            }
                            rBuf = this.do_fixRead((SerialPort)serialPort, time, readCycleNo - 1, sBuf, rBuf);
                            serialPortErrCount = 0;
                        }
                        catch (Exception e) {
                            log.error(String.format("\u56fa\u5b9a\u8bfb\u5f02\u5e38:S[%s],R[%s]\uff1a", Hex.encodeHexString(sBuf), Hex.encodeHexString(rBuf)), e);
                            ++serialPortErrCount;
                            this.site.zl[mcuIdx][0] = -1;
                        }
                        finally {
                            this.lkOk_FixRead.signalAll();
                            this.lock.unlock();
                        }
                        if (mcuIdx < ecwLljDz.length && ecwLljDz[mcuIdx] > 0) {
                            int ll;
                            byte addr = ecwLljDz[mcuIdx];
                            int n = ll = mcuIdx == 3 ? LljUtil.tx485_read_SsLl_MBmag((SerialPort)serialPort, addr) : LljUtil.tx485_read_SsLl_P2((SerialPort)serialPort, addr);
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("Read-ecwLlj:%s, J:%s, A:%s, V:%s", mcuIdx, cycleNo, addr, ll));
                            }
                            this.site.zl[mcuIdx][1] = ll;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug(StringUtils.join((Object[])ArrayUtils.toObject(this.site.zl[readCycleNo - 1]), ","));
                        continue;
                    }
                    try {
                        CommPortUtil.send((SerialPort)serialPort, sBuf);
                    }
                    catch (Exception e) {
                        log.error(String.format("\u56fa\u5b9a\u8bfb\u5f02\u5e38:S[%s]\uff1a", Hex.encodeHexString(sBuf)), e);
                        ++serialPortErrCount;
                    }
                    continue;
                }
                if (idleCycleNo != 0) continue;
                ++idleCycleNo;
                try {
                    this.do_FixIdle((SerialPort)serialPort);
                }
                catch (Exception e) {
                    log.error("\u5f02\u5e38", e);
                }
            }
            catch (Exception e) {
                if (serialPort != null) {
                    serialPort.close();
                    serialPort = null;
                }
                log.error("\u5f02\u5e38\uff1a", e);
            }
        }
        log.info(String.format("%s\uff0c\u505c\u6b62\u6210\u529f\uff01", this));
    }

    void read_sv(SerialPort serialPort) throws Exception {
        byte[] sBuf = new byte[]{0, 80, 0, 2, 0, 0};
        byte[] rBuf = new byte[8];
        String[] fn = "\u589e\u538b\u6cf5\u8d77\u59cb\u9891\u7387:\u5faa\u73af\u6cf5\u8d77\u59cb\u9891\u7387:\u4e8c\u7f51\u7cfb\u7edf\u538b\u529b:\u4e8c\u7f51\u56de\u6c34\u538b\u529b:\u4e8c\u7f51\u4f9b\u6e29:\u4e8c\u7f51\u56de\u6e29:\u8c03\u8282\u9600\u5f00\u5ea6".split(",|:");
        int len = 0;
        int fc = 64;
        int j = 0;
        while (j < this.site.sv[0].length) {
            sBuf[2] = (byte)(fc & 0xFF);
            int i = 0;
            byte a = 1;
            while (i < this.site.areaCount) {
                try {
                    sBuf[0] = a;
                    CRC16.pad_modbus_crc16(sBuf);
                    for (int t = 1; t >= 0; --t) {
                        try {
                            len = CommPortUtil.sendAndRecv(serialPort, sBuf, rBuf, 200);
                            rBuf = Arrays.copyOfRange(rBuf, 0, len);
                            if (rBuf[0] != sBuf[0] || rBuf[1] != sBuf[1]) {
                                throw new IOException(String.format("S[%s],R[%s]:\u5730\u5740\u6216\u529f\u80fd\u7801\u4e0d\u5339\u914d!", Hex.encodeHexString(sBuf), Hex.encodeHexString(rBuf)));
                            }
                            break;
                        }
                        catch (Exception e) {
                            if (t != 0) continue;
                            throw e;
                        }
                    }
                    int sv = (rBuf[2] & 0xFF) << 8 | rBuf[3] & 0xFF;
                    if (sBuf[2] == 76 && (sv &= 0x7F) > 100) {
                        sv = 100;
                    }
                    if (sBuf[0] == 1 && sBuf[2] == 68) {
                        sv *= 2;
                    }
                    this.site.sv[i][j] = sv;
                    log.info(String.format("\u8bfb\u53d6\u8bbe\u5b9a\u503c\uff1a%d\u673a\u7ec4%s=%d", a, fn[j], sv));
                }
                catch (Exception e) {
                    log.error(String.format("\u521d\u59cb\u5316\u9519\u8bef:[%1$d]\u673a\u7ec4[%2$x]\u6307\u4ee4", a, fc), e);
                }
                Thread.sleep(2000L);
                i = (byte)(i + 1);
                a = (byte)(a + 1);
            }
            ++j;
            fc += 2;
        }
    }

    void initCmd() {
        int fc = 64;
        int j = 0;
        while (j < this.site.sv[0].length) {
            int i = 0;
            byte a = 1;
            while (i < this.site.areaCount) {
                byte[] sBuf = new byte[]{a, 80, (byte)(fc & 0xFF), 2, 0, 0};
                CRC16.pad_modbus_crc16(sBuf);
                this.svCmds.add(sBuf);
                log.info("InitCmd=" + Hex.encodeHexString(sBuf));
                i = (byte)(i + 1);
                a = (byte)(a + 1);
            }
            ++j;
            fc += 2;
        }
    }

    void read_sv2(SerialPort serialPort) throws Exception {
        if (System.currentTimeMillis() - this.read_sv2_fc_time < 2000L) {
            return;
        }
        if (this.svCmds.isEmpty()) {
            return;
        }
        byte[] sBuf = this.svCmds.remove(0);
        byte[] rBuf = new byte[8];
        int len = 0;
        try {
            log.info("read_sv2=" + Hex.encodeHexString(sBuf));
            this.read_sv2_fc_time = System.currentTimeMillis();
            len = CommPortUtil.sendAndRecv(serialPort, sBuf, rBuf, 400);
            if (rBuf[0] != sBuf[0] || rBuf[1] != sBuf[1]) {
                throw new IOException(String.format("S[%s],R[%s]:\u5730\u5740\u6216\u529f\u80fd\u7801\u4e0d\u5339\u914d!", Hex.encodeHexString(sBuf), Hex.encodeHexString(rBuf)));
            }
        }
        catch (Exception e) {
            log.error("Sv2ReadErr:" + e.getMessage());
            this.svCmds.add(sBuf);
        }
        int sv = (rBuf[2] & 0xFF) << 8 | rBuf[3] & 0xFF;
        if (sBuf[2] == 76 && (sv &= 0x7F) > 100) {
            sv = 100;
        }
        if (sBuf[0] == 1 && sBuf[2] == 68) {
            sv *= 2;
        }
        int i = sBuf[0] - 1;
        int j = (sBuf[2] - 64) / 2;
        this.site.sv[i][j] = sv;
        log.info(String.format("\u8bfb\u53d6\u8bbe\u5b9a\u503c\uff1a%d\u673a\u7ec4%02x=%d", sBuf[0], sBuf[2], sv));
    }

    public static void main(String[] args) throws Exception {
        File siteFile = new File(SystemUtils.USER_DIR, "etc/slave.json");
        SlaveSite site = JkSlaver.jsonMapperFmt.readValue(siteFile, SlaveSite.class);
        Rs485Server g = new Rs485Server(site, new File("d:/gdat"));
        boolean no = false;
        while (true) {
            int mn = 1;
            int mi = 0;
            while (mi < site.areaCount) {
                int i;
                for (i = 0; i < site.zl[mi].length; ++i) {
                    site.zl[mi][i] = RandomUtils.nextInt(127);
                }
                for (i = 0; i < site.sv[mi].length; ++i) {
                    site.sv[mi][i] = RandomUtils.nextInt(127);
                }
                ++mi;
                ++mn;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    boolean wk_save_dat(int mcuNo, long time) {
        String fn = String.format("%1$04x-%2$02x-%3$tY%3$tm.r%5$02x", this.site.code, mcuNo, time, this.hdr.rlen);
        File datFile = new File(this.dataDir, fn);
        try {
            int idx = mcuNo - 1;
            int[] record = ArrayUtils.addAll(this.site.zl[idx], this.site.sv[idx]);
            int id = Hdr.calRecordId(time, this.hdr);
            long addr = Hdr.calRecordAddr(id, this.hdr);
            byte[] buf = H40.encodeRecord(this.hdr, record);
            if (!datFile.exists()) {
                if (!datFile.getParentFile().exists()) {
                    datFile.getParentFile().mkdirs();
                }
                this.hdr.btime = time;
                H40.writeHeader(datFile, this.hdr);
            }
            H40.write(datFile, addr, buf);
            if (log.isDebugEnabled()) {
                log.debug(String.format("\u4fdd\u5b58[%1$tm:%1$ts.%1$tS]\u6570\u636e\u5230[%2$s]\u6210\u529f:", time, fn));
            }
            return true;
        }
        catch (Exception e2) {
            log.error(String.format("\u4fdd\u5b58[%1$tm:%1$ts.%1$tS]\u6570\u636e\u5230[%2$s]\u5931\u8d25:", time, fn), e2);
            return false;
        }
    }

    static {
        dmpsMax = 16384;
    }
}

