/*
 * Decompiled with CFR 0.152.
 */
package jk.slave;

import java.io.IOException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.xlightweb.BadMessageException;
import org.xlightweb.FileServiceRequestHandler;
import org.xlightweb.HttpRequestHandler;
import org.xlightweb.HttpResponse;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.RequestHandlerChain;
import org.xlightweb.server.HttpServer;
import org.xsocket.WorkerPool;
import org.xsocket.connection.IConnection;

public class WebServer
extends HttpRequestHandler
implements Runnable {
    private static final Logger log = Logger.getLogger(WebServer.class);
    public final int port;
    public final String webDir;
    private WorkerPool workerPool;
    public String id_;
    private HttpServer server;

    public WebServer(WorkerPool workerPool, int port, String root) {
        this.workerPool = workerPool;
        this.port = port;
        this.webDir = root;
    }

    public String toString() {
        if (this.id_ == null) {
            this.id_ = new ToStringBuilder(this).append(this.webDir).append(this.port).toString();
        }
        return this.id_;
    }

    @Override
    public void doGet(IHttpExchange exchange) throws IOException, BadMessageException {
        IHttpRequest req = exchange.getRequest();
        String uri = req.getRequestURI();
        StringBuffer sb = new StringBuffer();
        sb.append("uri=" + uri + "\t");
        sb.append("ctx=" + req.getContextPath() + "\t");
        sb.append("path=" + req.getRequestHandlerPath() + "\t");
        if (log.isDebugEnabled()) {
            log.debug("req...:" + sb.toString());
        }
        if (uri.matches("^/*$") || uri.matches("^/jk/s.*.htm$")) {
            req.setRequestURI("/index.htm");
            exchange.forward(req);
            return;
        }
        if (uri.startsWith("/vp/")) {
            String op = req.getParameter("1");
            exchange.send(new HttpResponse(200, "text/json;charset=utf-8", op));
            return;
        }
        exchange.forward(req);
    }

    public void open() throws Exception {
        RequestHandlerChain hdlrChain = new RequestHandlerChain();
        hdlrChain.addLast(this);
        FileServiceRequestHandler hdlr = new FileServiceRequestHandler(this.webDir);
        hdlrChain.addLast(hdlr);
        this.server = new HttpServer(this.port, hdlrChain);
        if (this.workerPool != null) {
            this.server.setWorkerpool(this.workerPool);
        }
        this.server.setAutoflush(true);
        this.server.setFlushmode(IConnection.FlushMode.ASYNC);
        this.server.start();
        log.info(this + ", \u542f\u52a8\u6210\u529f\uff01\u7aef\u53e3\uff1a" + this.port);
    }

    public void close() {
        if (this.server != null) {
            this.server.close();
        }
        log.info(this + ", \u505c\u6b62\u6210\u529f!");
    }

    @Override
    public void run() {
        try {
            this.open();
        }
        catch (Exception e) {
            String msg = String.format("%s,\u542f\u52a8\u5931\u8d25", this);
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        }
    }

    public static void main(String[] args) {
        WebServer svr = new WebServer(null, 80, "web");
        try {
            svr.open();
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u5931\u8d25:", e);
            return;
        }
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        svr.close();
    }
}

