/*
 * Decompiled with CFR 0.152.
 */
package jk.slave;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jk.JkSlaver;
import jk.flr.H40;
import jk.utils.CRC16;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IWebSocketConnection;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.TextMessage;
import org.xlightweb.server.HttpServer;
import org.xsocket.WorkerPool;
import org.xsocket.connection.IConnection;

public class WebSocketServer
extends Thread
implements IWebSocketHandler,
Runnable {
    private static final Logger log = Logger.getLogger(WebSocketServer.class);
    public static final String SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    public static final String SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    public static final String MAGIC_CODE = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final long CONN_TIME_OUT_SEC = 60L;
    public static final long IDLE_TIMEOUT_SEC = 50L;
    public final WorkerPool workerPool;
    public final int port;
    public String id_;
    Pattern msgPtn;
    private HttpServer server;

    public static String genSecWebSocketAccept(String key) {
        byte[] sh1 = DigestUtils.sha1(key + MAGIC_CODE);
        return Base64.encodeBase64String(sh1);
    }

    public static void setSecWebSocketAccept(IWebSocketConnection webStream) {
        String key = webStream.getUpgradeRequestHeader().getHeader(SEC_WEBSOCKET_KEY);
        String acpt = WebSocketServer.genSecWebSocketAccept(key);
        webStream.getUpgradeResponseHeader().addHeader(SEC_WEBSOCKET_ACCEPT, acpt);
    }

    public WebSocketServer(WorkerPool workerPool, int port) {
        this.workerPool = workerPool;
        this.port = port;
        this.msgPtn = Pattern.compile("^([0-9a-zA-Z]{2})#(.*)$");
    }

    @Override
    public String toString() {
        if (this.id_ == null) {
            this.id_ = new ToStringBuilder(this).append(this.port).toString();
        }
        return this.id_;
    }

    @Override
    public void run() {
        try {
            this.open();
        }
        catch (Exception e) {
            String msg = String.format("%s, \u542f\u52a8\u5931\u8d25", this);
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        }
    }

    public void open() throws Exception {
        this.server = new HttpServer(this.port, this);
        if (this.workerPool != null) {
            this.server.setWorkerpool(this.workerPool);
        }
        this.server.setAutoflush(true);
        this.server.setFlushmode(IConnection.FlushMode.ASYNC);
        this.server.start();
        log.info(this.getClass().getSimpleName() + "\uff0c\u542f\u52a8\u6210\u529f\uff01\u7aef\u53e3\uff1a" + this.port);
    }

    public void close() {
        if (this.server != null) {
            this.server.close();
        }
        log.info(this + "\uff0c\u505c\u6b62\u6210\u529f\uff01");
    }

    private void mylog(IWebSocketConnection webStream) {
        if (log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer(webStream.getAttachment() + "# " + this.getClass().getName());
            sb.append("<--[" + webStream.getRemoteAddress() + ":" + webStream.getRemotePort() + "]\n");
            sb.append("getProtocol()=" + webStream.getProtocol() + "\t");
            sb.append("getUpgradeRequestHeader.getProtocol=" + webStream.getUpgradeRequestHeader().getProtocol() + "\t\n");
            sb.append("getPathInfo=" + webStream.getUpgradeRequestHeader().getPathInfo() + "\t");
            sb.append("Scheme=" + webStream.getUpgradeRequestHeader().getScheme() + "\t");
            sb.append("getRequestURI=" + webStream.getUpgradeRequestHeader().getRequestURI() + "\t");
            sb.append("getRequestURI=" + webStream.getUpgradeRequestHeader().getRequestUrl());
            log.debug(sb.toString());
        }
    }

    String ckPwd(String fData, Att at) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("%1$tS.%1$tL\t%2$s\t%3$tS.%3$tL\t" + fData, System.currentTimeMillis(), at.token, at.tokenTime));
        }
        if (DigestUtils.md5Hex("13304513235".concat(at.token)).equalsIgnoreCase(fData)) {
            return "au";
        }
        if (DigestUtils.md5Hex("xh20206128".concat(at.token)).equalsIgnoreCase(fData)) {
            return "u";
        }
        return "0";
    }

    @Override
    public void onConnect(IWebSocketConnection webStream) throws IOException {
        String ver = webStream.getUpgradeRequestHeader().getHeader(SEC_WEBSOCKET_VERSION);
        if (!"13".equals(ver)) {
            log.warn("Sec-WebSocket-Version\u7248\u672c\u4e0d\u5339\u914d\uff0c\u8981\u6c4213 :" + ver);
            return;
        }
        WebSocketServer.setSecWebSocketAccept(webStream);
        String rAddr = webStream.getRemoteAddress().getHostAddress();
        int rPort = webStream.getRemotePort();
        Att at = new Att(System.currentTimeMillis(), rAddr, rPort);
        webStream.setAttachment(at);
        webStream.setConnectionTimeoutMillis(10000L);
        webStream.setIdleTimeoutMillis(50000L);
        if (log.isInfoEnabled()) {
            log.info(String.format("[%s] <<<<<<<<<<<<< [%s:%d]", webStream.getAttachment(), rAddr, rPort));
        }
    }

    @Override
    public void onDisconnect(IWebSocketConnection webStream) throws IOException {
        Att at = (Att)webStream.getAttachment();
        long st = (System.currentTimeMillis() - at.lt) / 1000L;
        if (log.isInfoEnabled()) {
            log.info(String.format("[%s] >>>>>>>>> [%s]", at, st));
        }
        webStream.setAttachment(null);
    }

    @Override
    public void onMessage(IWebSocketConnection webStream) throws IOException {
        StringBuffer sndMsg;
        block48: {
            Matcher m;
            webStream.setConnectionTimeoutMillis(60000L + webStream.getConnectionTimeoutMillis() - webStream.getRemainingMillisToConnectionTimeout());
            Att at = (Att)webStream.getAttachment();
            if (System.currentTimeMillis() - at.tokenTime > 30000L) {
                at.token = RandomStringUtils.randomAlphanumeric(5);
                at.tokenTime = System.currentTimeMillis();
            }
            IHttpRequestHeader req = webStream.getUpgradeRequestHeader();
            String rcvMsg = webStream.readTextMessage().toString();
            if (log.isInfoEnabled()) {
                log.info(String.format("[%s]<--[%s]", at, rcvMsg));
            }
            if (!(m = this.msgPtn.matcher(rcvMsg)).matches()) {
                webStream.writeMessage(new TextMessage("EE$\u547d\u4ee4\u683c\u5f0f\u9519\u8bef:" + rcvMsg));
                return;
            }
            String fCode = m.group(1);
            String fData = m.group(2);
            sndMsg = new StringBuffer(fCode + "$");
            if ("QI".equals(fCode)) {
                String res = null;
                try {
                    res = JkSlaver.jsonMapperMini.writeValueAsString(JkSlaver.site);
                    if (res == null) {
                        sndMsg.append('E');
                        break block48;
                    }
                    sndMsg.append('O').append(res);
                }
                catch (Exception e) {
                    log.error("\u547d\u4ee4\u5f02\u5e38:" + rcvMsg, e);
                    sndMsg.append('E');
                }
            } else if ("cd".equals(fCode)) {
                at.rl = this.ckPwd(fData, at);
                sndMsg.append('O').append(at.rl);
            } else if ("02".equals(fCode)) {
                sndMsg.append('O').append(String.valueOf(System.currentTimeMillis()));
            } else if ("F4".equals(fCode)) {
                String[] args = fData.split(",");
                long stime = Long.parseLong(args[1]);
                int row = Integer.parseInt(args[2]);
                int interval = Integer.parseInt(args[3]);
                ArrayList<int[]> rslt = new ArrayList<int[]>(Math.abs(row));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String fnt = JkSlaver.site.code + "-0" + args[0] + "-%1$tY%1$tm.flr";
                if (log.isDebugEnabled()) {
                    log.debug(fData + ":\t\u67e5" + sdf.format(new Date(stime)) + "at " + fnt);
                }
                try {
                    H40.readRecord(JkSlaver.dataDir, fnt, stime, row, interval, rslt);
                    if (log.isDebugEnabled()) {
                        log.debug(fData + ":\t\u7ed3\u679c\uff1a" + rslt.size());
                    }
                    ArrayList<int[]> rslt1 = new ArrayList<int[]>(rslt.size());
                    if (args.length > 4 && "S".equals(args[4])) {
                        rslt1 = rslt;
                    } else {
                        for (int i = 0; i < rslt.size(); ++i) {
                            rslt1.add(i, ArrayUtils.subarray((int[])rslt.get(i), 0, 15));
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(fData + ":\t\u5904\u7406\u540e\uff1a" + rslt.size());
                    }
                    String res = JkSlaver.jsonMapperMini.writeValueAsString(rslt);
                    sndMsg.append('O').append(fData).append('=').append(res);
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u5386\u53f2\u6570\u636e\u5f02\u5e38:" + fData, e);
                    sndMsg.append('E').append(fData).append('=').append(e.getLocalizedMessage());
                }
            } else {
                if ("04".equals(fCode)) {
                    try {
                        int idx = Integer.parseInt(fData) - 1;
                        HashMap<String, Object> mp = new HashMap<String, Object>();
                        mp.put("a", fData);
                        mp.put("z", JkSlaver.site.zl[idx]);
                        mp.put("s", JkSlaver.site.sv[idx]);
                        mp.put("t", JkSlaver.site.zlTime[idx]);
                        mp.put("c", System.currentTimeMillis());
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("%1$tS.%1$tL\t%2$s\t%3$tS.%3$tL", System.currentTimeMillis(), at.token, at.tokenTime));
                        }
                        mp.put("kh", JkSlaver.site.hOn[idx]);
                        mp.put("ks", JkSlaver.site.sOn[idx]);
                        mp.put("j1", JkSlaver.site.b1w[idx]);
                        mp.put("j2", JkSlaver.site.b2w[idx]);
                        mp.put("tk", at.token);
                        sndMsg.append('O').append(JkSlaver.jsonMapperMini.writeValueAsString(mp));
                    }
                    catch (Exception e) {
                        log.error("\u5f02\u5e38", e);
                        throw new IOException(e);
                    }
                }
                if ("ML".equals(fCode)) {
                    if (at.rl.indexOf(97) >= 0) {
                        try {
                            String cmd = fData + CRC16.calCrc16(fData, true);
                            String res = JkSlaver.rs485Server.awaitRtCmd(cmd);
                            sndMsg.append('O').append(res);
                        }
                        catch (Exception e) {
                            log.error("\u5f02\u5e38", e);
                            sndMsg.append('E').append(e.getLocalizedMessage());
                        }
                    } else {
                        sndMsg.append('E').append("\u65e0\u6b64\u547d\u4ee4:" + at.rl);
                    }
                } else if ("kg".equals(fCode)) {
                    if (at.rl.indexOf(117) >= 0) {
                        try {
                            fData = fData + "80";
                            String cmd = fData + CRC16.calCrc16(fData, true);
                            String res = JkSlaver.rs485Server.awaitRtCmd(cmd);
                            if (res != null && String.format("%s4f4b", cmd.substring(0, 2)).equalsIgnoreCase(res)) {
                                sndMsg.append('O').append(res);
                                break block48;
                            }
                            sndMsg.append('E').append(res);
                        }
                        catch (Exception e) {
                            log.error("\u5f02\u5e38", e);
                            sndMsg.append('E').append(e.getLocalizedMessage());
                        }
                    } else {
                        sndMsg.append('V').append("\u65e0\u6b64\u547d\u4ee4:" + at.rl);
                    }
                } else if ("ST".equalsIgnoreCase(fCode)) {
                    if (at.rl.indexOf(117) >= 0) {
                        String[] args = fData.split(",", 3);
                        try {
                            int sv = Integer.parseInt(args[2]);
                            if ("22".equals(args[0]) && args[1].trim().matches("[1]")) {
                                sv /= 2;
                            }
                            String cmd = String.format("0%2$s%1$s%3$04x", args[0], args[1], sv);
                            String res = JkSlaver.rs485Server.awaitRtCmd(cmd = cmd + CRC16.calCrc16(cmd, true));
                            if (res != null && String.format("%s4f4b", cmd.substring(0, 2)).equalsIgnoreCase(res)) {
                                sndMsg.append('O').append(fData);
                                JkSlaver.site.sv[Integer.parseInt((String)args[1]) - 1][Integer.parseInt((String)args[0].substring((int)1))] = Integer.parseInt(args[2]);
                                break block48;
                            }
                            sndMsg.append('E').append(fData).append(':').append(res);
                        }
                        catch (Exception e) {
                            log.error("\u5f02\u5e38", e);
                            sndMsg.append('E').append(e.getLocalizedMessage());
                        }
                    } else {
                        sndMsg.append('E').append("\u65e0\u6b64\u547d\u4ee4:" + at.rl);
                    }
                } else {
                    sndMsg.append(fData);
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("[%s]-->[%s]", webStream.getAttachment(), sndMsg));
        }
        webStream.writeMessage(new TextMessage(sndMsg.toString()));
    }

    public static void main(String[] args) {
        System.setProperty("java.util.logging.config.file", "logging.properties");
        WebSocketServer svr = new WebSocketServer(null, 11101);
        try {
            svr.start();
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u5931\u8d25:", e);
            return;
        }
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        svr.stop();
    }

    public static class Att {
        public long lt;
        public long lastAccessTime;
        public String ip;
        public int pt;
        public String rl = "0";
        public String token;
        public long tokenTime;

        public Att(long ltime, String rip, int rport) {
            this.lt = ltime;
            this.ip = rip;
            this.pt = rport;
        }

        public String toString() {
            return String.format("%d#%s:%d", this.lt, this.ip, this.pt);
        }
    }
}

