/*
 * Decompiled with CFR 0.152.
 */
package jk.sp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import jk.utils.TimeoutExit;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommPortUtil {
    public static final Logger log = LoggerFactory.getLogger(CommPortUtil.class);
    static Map<String, Long> timePortIO = new HashMap<String, Long>();

    public static void main(String[] args) {
        try {
            System.out.println("\u6709\u6548\u4e32\u53e3:" + CommPortUtil.checkSerialPortStatus());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static Map<String, Boolean> checkSerialPortStatus() throws Exception {
        HashMap<String, Boolean> ports = new HashMap<String, Boolean>();
        try {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier port = (CommPortIdentifier)portList.nextElement();
                if (1 != port.getPortType()) continue;
                try {
                    SerialPort serialPort = (SerialPort)port.open(CommPortUtil.class.getSimpleName(), 2000);
                    serialPort.close();
                    ports.put(port.getName(), true);
                }
                catch (PortInUseException e) {
                    ports.put(port.getName(), false);
                }
            }
            return ports;
        }
        catch (Exception e) {
            log.error("\u4e32\u53e3\u521d\u59cb\u5316\u5f02\u5e38\uff0c java.library.path=" + System.getProperty("java.library.path"), e);
            throw e;
        }
    }

    public static SerialPort openSerialPort(String portName) throws Exception {
        return CommPortUtil.openSerialPort(portName, 1000);
    }

    public static SerialPort openSerialPort(String portName, int rcvTimeout) throws Exception {
        CommPortIdentifier cpi = CommPortIdentifier.getPortIdentifier(portName);
        SerialPort serialPort = (SerialPort)cpi.open("CommPortUtil", 2000);
        serialPort.setSerialPortParams(9600, 8, 1, 0);
        serialPort.enableReceiveTimeout(rcvTimeout);
        if (log.isInfoEnabled()) {
            log.info(String.format("\u6210\u529f\u6253\u5f00\u4e32\u53e3: %s[%s,%s,%s,%s]", serialPort.getName(), serialPort.getBaudRate(), serialPort.getDataBits(), serialPort.getStopBits(), serialPort.getParity()));
        }
        return serialPort;
    }

    public static int sendAndRecv(SerialPort serialPort, byte[] sBuf, byte[] rBuf, int recvTimeout) throws Exception {
        int rto = serialPort.getReceiveTimeout();
        int len = 0;
        serialPort.enableReceiveTimeout(5);
        InputStream is = serialPort.getInputStream();
        if (is.available() > 0) {
            byte[] buf = new byte[128];
            while ((len = is.read(buf)) > 0) {
                log.warn("\u6e05\u7a7a\u5783\u573e\u6570\u636e:" + Hex.encodeHexString(buf).substring(0, len * 2));
                if (len == buf.length) continue;
            }
        }
        is.close();
        serialPort.enableReceiveTimeout(rto);
        if (sBuf != null && sBuf.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("-->%2$d:[%1$s]", Hex.encodeHexString(sBuf), sBuf.length));
            }
            TimeoutExit a = TimeoutExit.startInstance(500L, "\u53d1\u9001\u8d85\u65f6\u91cd\u542f\uff01");
            OutputStream os = serialPort.getOutputStream();
            os.write(sBuf);
            os.close();
            TimeoutExit.stopInstance(a);
        }
        if (rBuf == null || rBuf.length == 0) {
            return 0;
        }
        serialPort.enableReceiveTimeout(recvTimeout);
        is = serialPort.getInputStream();
        len = is.read(rBuf);
        is.close();
        if (len <= 0) {
            throw new IOException(String.format("\u53d1\u9001[%1$s],\u63a5\u6536\u8d85\u65f6:[%2$dms]", Hex.encodeHexString(sBuf), serialPort.getReceiveTimeout()));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("<--%2$d:[%1$s]", Hex.encodeHexString(rBuf).substring(0, len * 2), len));
        }
        return len;
    }

    public static int send(SerialPort serialPort, byte[] sBuf) throws Exception {
        return CommPortUtil.sendAndRecv(serialPort, sBuf, null, 0);
    }

    private static void sendDat(SerialPort serialPort, byte[] sendDat, int mixDelayMillins) throws Exception {
        InputStream is = null;
        OutputStream os = null;
        try {
            String pn = serialPort.getName();
            long tm = System.currentTimeMillis();
            if (timePortIO.containsKey(pn) && (tm = timePortIO.get(pn) + (long)mixDelayMillins - tm) > 0L) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("\u53d1[%1$s]\u5ef6\u65f6[%2$d]\u6beb\u79d2...", pn, tm));
                }
                Thread.sleep(tm);
            }
            timePortIO.put(pn, System.currentTimeMillis());
            is = serialPort.getInputStream();
            if (is.available() > 0) {
                byte[] buf = new byte[is.available()];
                while (is.available() > 0) {
                    int len = is.read(buf);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("\u6e05\u7a7a\u63a5\u6536\u7f13\u51b2\u533a:" + Hex.encodeHexString(buf));
                }
            }
            is.close();
            if (sendDat != null && sendDat.length > 0) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("\u53d1(%1$d):[%2$s]", sendDat.length, Hex.encodeHexString(sendDat)));
                }
                os = serialPort.getOutputStream();
                os.write(sendDat);
                os.close();
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(is);
        IOUtils.closeQuietly(os);
    }

    private static int recvDat(SerialPort serialPort, byte[] recvDat, int timeout) throws Exception {
        if (recvDat == null || recvDat.length <= 0) {
            return 0;
        }
        InputStream is = null;
        int exp = recvDat.length;
        int len = 0;
        try {
            is = serialPort.getInputStream();
            long time22 = System.currentTimeMillis() + (long)timeout;
            while (time22 > System.currentTimeMillis()) {
                if (is.available() > 0 && (len += is.read(recvDat, len, exp - len)) >= exp) {
                    len += is.available();
                    break;
                }
                Thread.sleep(200L);
            }
            is.close();
            if (log.isInfoEnabled()) {
                log.info(String.format("\u6536(%1d/%2$d):[%3$s]", len, exp, Hex.encodeHexString(recvDat)));
            }
            int time22 = len;
            return time22;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }
}

