/*
 * Decompiled with CFR 0.152.
 */
package jk.utils;

import org.apache.commons.codec.binary.Hex;

public class CRC16 {
    static short[] CRC16_4_TB = new short[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, -32504, -28375, -24246, -20117, -15988, -11859, -7730, -3601};
    static final int MODBUS_REG = 65535;
    static final int MODBUS_GEN = 40961;
    static short[] aa = new short[]{16575, -32642, -32450, 16895, -31810, 17279, 16959, -32002, -31042, 18047, 18239, -30722, 17855, -31362, -31682, 17663};

    static int crc16(int reg, int gen, byte[] dat) {
        int crc_reg = reg;
        int crc_gen = gen;
        int l = dat.length;
        for (int i = 0; i < l; ++i) {
            crc_reg = dat[i] ^ crc_reg;
            for (int j = 8; j > 0; --j) {
                if ((crc_reg & 1) == 1) {
                    crc_reg >>= 1;
                    crc_reg ^= crc_gen;
                    continue;
                }
                crc_reg >>= 1;
            }
        }
        return crc_reg;
    }

    public static int modbus_crc16_rtu(byte[] dat) {
        return CRC16.modbus_crc16_rtu(dat, 0, dat.length);
    }

    public static int modbus_crc16_rtu(byte[] dat, int offset, int len) {
        int crc_reg = 65535;
        int crc_gen = 40961;
        int l = len;
        for (int i = offset; i < l; ++i) {
            crc_reg = dat[i] & 0xFF ^ crc_reg;
            for (int j = 8; j > 0; --j) {
                if ((crc_reg & 1) == 1) {
                    crc_reg >>= 1;
                    crc_reg ^= crc_gen;
                    continue;
                }
                crc_reg >>= 1;
            }
        }
        return crc_reg & 0xFFFF;
    }

    public static String calCrc16(String cmd, boolean firstLow) throws Exception {
        byte[] buf = Hex.decodeHex(cmd.toCharArray());
        int crc = CRC16.modbus_crc16_rtu(buf);
        String c = String.format("%04x", crc);
        if (firstLow) {
            c = c.replaceFirst("([0-9a-fA-F]{2})([0-9a-fA-F]{2})", "$2$1");
        }
        return c;
    }

    public static void pad_modbus_crc16(byte[] buf) {
        int crc = CRC16.modbus_crc16_rtu(buf, 0, buf.length - 2);
        buf[buf.length - 2] = (byte)(crc & 0xFF);
        buf[buf.length - 1] = (byte)(crc >> 8 & 0xFF);
    }

    public static double ieee754_32(int d3, int d2, int d1, int d0) {
        byte s = (byte)(d3 >> 7);
        int e = (d3 << 1 | d2 >> 7) & 0xFF;
        int m = d2 | 0x80;
        m = m << 8 | d1;
        m = m << 8 | d0;
        double v = Math.pow(2.0, e - 150) * (double)m;
        return v *= Math.pow(-1.0, s);
    }

    public static byte[] modbus_crc16_rtu_B2(byte[] dat, int offset, int len) {
        int crc = CRC16.modbus_crc16_rtu(dat, offset, len);
        return new byte[]{(byte)(crc & 0xFF), (byte)(crc >> 8 & 0xFF)};
    }

    static int cal_crc16_bit4(byte[] dat) {
        int crc_reg = 0;
        int crc_upper4 = 0;
        for (int i = 0; i < dat.length; ++i) {
            crc_upper4 = crc_reg >>> 12 & 0xF;
            crc_reg = crc_reg << 4 & 0xFFF0;
            crc_upper4 = (crc_reg ^= CRC16_4_TB[crc_upper4 ^= dat[i] >> 4 & 0xF]) >>> 12 & 0xF;
            crc_reg = crc_reg << 4 & 0xFFF0;
            crc_reg ^= CRC16_4_TB[crc_upper4 ^= dat[i] & 0xF];
            crc_reg &= 0xFFFF;
        }
        return crc_reg;
    }

    static int cal_crc16(byte[] dat) {
        int crc_reg = 0;
        int crc_upper4 = 0;
        for (int i = 0; i < dat.length; ++i) {
            crc_upper4 = crc_reg >>> 12 & 0xF;
            crc_reg = crc_reg << 4 & 0xFFF0;
            crc_upper4 = (crc_reg ^= aa[crc_upper4 ^= dat[i] >> 4 & 0xF]) >>> 12 & 0xF;
            crc_reg = crc_reg << 4 & 0xFFF0;
            crc_reg ^= aa[crc_upper4 ^= dat[i] & 0xF];
            crc_reg &= 0xFFFF;
        }
        return crc_reg;
    }

    static int cal_crc16_bit(byte[] dat) {
        int crc_gen = 4129;
        int crc_reg = 0;
        for (int n = 0; n < dat.length; ++n) {
            for (int i = 128; i != 0; i >>>= 1) {
                if ((crc_reg & 0x8000) != 0) {
                    crc_reg <<= 1;
                    crc_reg ^= crc_gen;
                } else {
                    crc_reg <<= 1;
                }
                if ((dat[n] & i) == 0) continue;
                crc_reg ^= crc_gen;
            }
        }
        return crc_reg & 0xFFFF;
    }

    public static void main(String[] args) {
        byte[] d = new byte[]{0, 96, 28, -60, 0, 0};
        CRC16.pad_modbus_crc16(d);
        System.out.println(Hex.encodeHexString(d));
    }
}

