/*
 * Decompiled with CFR 0.152.
 */
package jk.utils;

import java.io.IOException;
import javax.comm.SerialPort;
import jk.sp.CommPortUtil;
import jk.utils.CRC16;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class LljUtil {
    private static final Logger log = Logger.getLogger(LljUtil.class);

    public static int tx485_read_SsLl_MBmag(SerialPort serialPort, byte addr) throws Exception {
        byte[] sBuf = new byte[]{addr, 4, 16, 16, 0, 2, 0, 0};
        byte[] rBuf = new byte[9];
        CRC16.pad_modbus_crc16(sBuf);
        int len = CommPortUtil.sendAndRecv(serialPort, sBuf, rBuf, 200);
        if (len != 9) {
            String req = Hex.encodeHexString(sBuf);
            String res = Hex.encodeHexString(rBuf);
            throw new IOException(String.format("Err:ReadLl:\u4e0d\u8db39\u5b57\u8282\uff01", req, res));
        }
        if (rBuf[0] != sBuf[0] || rBuf[1] != sBuf[1]) {
            String req = Hex.encodeHexString(sBuf);
            String res = Hex.encodeHexString(rBuf);
            throw new IOException(String.format("Err:ReadLl:\u5730\u5740\u6216\u529f\u80fd\u7801\u4e0d\u7b26\uff01", req, res));
        }
        double ll = CRC16.ieee754_32(rBuf[3] & 0xFF, rBuf[4] & 0xFF, rBuf[5] & 0xFF, rBuf[6] & 0xFF);
        int ll2 = (int)Math.round(ll * 10.0);
        if (log.isDebugEnabled()) {
            log.debug(String.format("SsLl=%s", ll2));
        }
        return ll2;
    }

    public static int tx485_read_SsLl_P2(SerialPort serialPort, byte addr) throws Exception {
        byte[] sBuf = new byte[]{addr, 3, 0, 0, 0, 2, 0, 0};
        byte[] rBuf = new byte[9];
        CRC16.pad_modbus_crc16(sBuf);
        int len = CommPortUtil.sendAndRecv(serialPort, sBuf, rBuf, 200);
        if (len != 9) {
            String req = Hex.encodeHexString(sBuf);
            String res = Hex.encodeHexString(rBuf);
            throw new IOException(String.format("Err:ReadLl:\u4e0d\u8db39\u5b57\u8282\uff01", req, res));
        }
        if (rBuf[0] != sBuf[0] || rBuf[1] != sBuf[1]) {
            String req = Hex.encodeHexString(sBuf);
            String res = Hex.encodeHexString(rBuf);
            throw new IOException(String.format("Err:ReadLl:\u5730\u5740\u6216\u529f\u80fd\u7801\u4e0d\u7b26\uff01", req, res));
        }
        int ll = 0;
        for (int i = 0; i <= 3; ++i) {
            int b = rBuf[3 + i] & 0xFF;
            ll <<= 8;
            ll += b;
        }
        int ll2 = (int)Math.round((double)ll / 100.0);
        if (log.isDebugEnabled()) {
            log.debug(String.format("SsLl=%s", ll2));
        }
        return ll2;
    }

    public static void main(String[] args) {
        String s;
        byte[] sBuf;
        byte i;
        for (i = 1; i <= 10; i = (byte)(i + 1)) {
            sBuf = new byte[]{i, 3, 0, 0, 0, 2, 0, 0};
            CRC16.pad_modbus_crc16(sBuf);
            s = Hex.encodeHexString(sBuf);
            System.out.printf("P2 %s: %s\n", i, s);
        }
        for (i = 1; i <= 10; i = (byte)(i + 1)) {
            sBuf = new byte[]{i, 4, 16, 16, 0, 2, 0, 0};
            CRC16.pad_modbus_crc16(sBuf);
            s = Hex.encodeHexString(sBuf);
            System.out.printf("MBmag %s: %s\n", i, s);
        }
    }
}

