/*
 * Decompiled with CFR 0.152.
 */
package jk.utils;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtpUtil {
    private static final Logger log = LoggerFactory.getLogger(NtpUtil.class);
    public static List<String> ntpServers = Arrays.asList("fartein.ifi.uio.no", "time.service.uit.no", "time.windows.com");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long checkClockOffsetByNTP() {
        String ntpServer = null;
        NTPUDPClient client = new NTPUDPClient();
        client.setDefaultTimeout(4000);
        Long offset = null;
        for (int i = 0; i < ntpServers.size(); ++i) {
            ntpServer = ntpServers.get(i).trim();
            try {
                client.open(123);
                InetAddress hostAddr = InetAddress.getByName(ntpServer);
                TimeInfo info = client.getTime(hostAddr);
                info.computeDetails();
                if (info.getOffset() == null) continue;
                offset = info.getOffset();
                log.info(String.format("Offset:%d, Stratum:%d, %s", offset, info.getMessage().getStratum(), hostAddr));
                if (i == 0) break;
                ntpServers.remove(ntpServer);
                ntpServers.add(0, ntpServer);
                break;
            }
            catch (Exception e) {
                log.error(ntpServer + "," + e.getMessage());
                continue;
            }
            finally {
                client.close();
            }
        }
        return offset;
    }

    public static void main(String[] args) {
        log.debug(NtpUtil.checkClockOffsetByNTP().toString());
    }
}

