/*
 * Decompiled with CFR 0.152.
 */
package jk.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jk.slave.RunDat_tmp;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class RedisUtil {
    public static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    static String host = System.getProperty("redisHost", "redis.xihewuye.cn");
    static int port = NumberUtils.toInt(System.getProperty("redisPort"), 6379);
    static String pass = System.getProperty("redisAuth", "admalf125vlladswsijkldkljdfsfds0rnmkds4rasftd");
    static int dbn = NumberUtils.toInt(System.getProperty("redisDbn"), 0);

    public static void main(String[] args) throws InterruptedException {
        FastDateFormat df = FastDateFormat.getInstance("HH:mm:ss");
        JedisPool pool = RedisUtil.CreateJedisPool("redis://admalf125vlladswsijkldkljdfsfds0rnmkds4rasftd@redis.xihewuye.cn:6379/2", 1000, 3, 1);
        System.out.println(pool.getResource().time());
        log.debug("start...");
        try {
            log.debug("sub...");
            RedisUtil.startSubscriber(pool, new JedisPubSub(){

                @Override
                public void onSubscribe(String channel, int subscribedChannels) {
                    super.onSubscribe(channel, subscribedChannels);
                    log.debug("sub ok " + channel + "," + subscribedChannels);
                }

                @Override
                public void onMessage(String channel, String message) {
                    super.onMessage(channel, message);
                    log.debug(channel + "@recv:" + message);
                }
            }, "rtd");
            log.debug("send...");
            while (true) {
                String t = df.format(new Date());
                System.out.printf("W:%s, A:%s, I:%s Wt:%s\n", pool.getNumWaiters(), pool.getNumActive(), pool.getNumIdle(), pool.getMaxBorrowWaitTimeMillis());
                try {
                    Jedis j = pool.getResource();
                    j.set("time", t);
                    String v = j.get("time");
                    j.publish("rtd", "v=" + t);
                    j.close();
                    System.out.println(t + "," + v + "\t" + pool.getNumActive());
                }
                catch (Exception e) {
                    System.out.println("Err:" + e.getMessage());
                }
                Thread.sleep(5000L);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void startSubscriber(final JedisPool pool, final JedisPubSub sub, final String ... channels) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Jedis rdsc = null;
                while (true) {
                    try {
                        if (rdsc == null) {
                            rdsc = pool.getResource();
                        }
                        log.info("\u6ce8\u518c\u76d1\u542c\u5668:" + channels[0]);
                        rdsc.psubscribe(sub, channels);
                        continue;
                    }
                    catch (Exception e) {
                        log.error(channels[0] + ":\u6ce8\u518c\u5931\u8d25:" + sub.getClass().getSimpleName(), e);
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (InterruptedException e1) {
                        }
                    }
                    finally {
                        if (rdsc == null) continue;
                        rdsc.close();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public static void publishWarn(JedisPool pool, String msg) {
        Jedis c = null;
        try {
            c = pool.getResource();
            c.publish("ch", msg);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    public static JedisPool CreateJedisPool(String url, int timeoutMills, int max, int idle) {
        Pattern p = Pattern.compile("redis://(([^@]+)@)?([^:/]+)(:([0-9]+))?(/([0-9]+))?");
        Matcher m = p.matcher(url);
        if (!m.find()) {
            System.exit(1);
        }
        String host = m.group(3);
        String pass = m.group(2);
        String portStr = m.group(5);
        String dbnStr = m.group(7);
        int port = NumberUtils.toInt(portStr, 6379);
        int dbn = NumberUtils.toInt(dbnStr, 0);
        log.info(String.format("connect redis:%s,%s,%s", host, port, dbn));
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(max);
        jedisPoolConfig.setMaxIdle(idle);
        jedisPoolConfig.setMaxWaitMillis(2 * timeoutMills);
        jedisPoolConfig.setTestOnBorrow(true);
        if (StringUtils.isEmpty(pass)) {
            return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, timeoutMills);
        }
        return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, timeoutMills, pass, dbn);
    }

    public static Jedis CreateJedis(String host, int port, String pass) {
        Jedis inst = new Jedis(host, port);
        if (StringUtils.isNotEmpty(pass)) {
            inst.auth(pass);
        }
        return inst;
    }

    public static List<String> mget(JedisPool pool, String[] keys) {
        Jedis j = pool.getResource();
        List<String> r = j.mget(keys);
        j.close();
        return r;
    }

    public static void updateRtd2(JedisPool pool, RunDat_tmp dat) {
        if (dat == null) {
            return;
        }
        Jedis c = pool.getResource();
        c.select(dbn);
        String key = dat.code + ":rtd";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("code", dat.code);
        m.put("count", Integer.toString(dat.count));
        m.put("time", Long.toString(dat.time));
        m.put("time_local", Long.toString(dat.time_local));
        m.put("bpqKG", Integer.toString(dat.bpqKG));
        m.put("CtrlPlS1", Integer.toString(dat.CtrlPlS1));
        m.put("ErrCodeS1", Integer.toString(dat.ErrCodeS1));
        m.put("GsWdS1", Integer.toString(dat.GsWdS1));
        m.put("GsYlS1", Integer.toString(dat.GsYlS1));
        m.put("HsYlS1", Integer.toString(dat.HsYlS1));
        m.put("LlS1", Integer.toString(dat.LlS1));
        m.put("SbDlS1", Integer.toString(dat.SbDlS1));
        m.put("Sw", Integer.toString(dat.Sw));
        for (int i = 0; i < dat.count; ++i) {
            m.put("CtrlPlS2_" + i, Integer.toString(dat.CtrlPlS2[i]));
            m.put("SbDlS2_" + i, Integer.toString(dat.SbDlS2[i]));
            m.put("LlS2_" + i, Integer.toString(dat.LlS2[i]));
            m.put("BsBpqFlag_" + i, Integer.toString(dat.BsBpqFlag[i]));
            m.put("HsWdS1_" + i, Integer.toString(dat.HsWdS1[i]));
            m.put("HsWdS2_" + i, Integer.toString(dat.HsWdS2[i]));
            m.put("HsYlS2_" + i, Integer.toString(dat.HsYlS2[i]));
            m.put("GsWdS2_" + i, Integer.toString(dat.GsWdS2[i]));
            m.put("GsYlS2_" + i, Integer.toString(dat.GsYlS2[i]));
            m.put("ErrCodeS2_" + i, Integer.toString(dat.ErrCodeS2[i]));
        }
        c.hmset(key, m);
        c.expire(key, 60);
        c.close();
    }
}

