/*
 * Decompiled with CFR 0.152.
 */
package jk.utils;

import java.util.concurrent.atomic.AtomicBoolean;

public class TimeoutExitMonitor {
    final String exitmsg;
    final long exittimeout;
    final AtomicBoolean on = new AtomicBoolean(false);
    Thread t;

    public TimeoutExitMonitor(long timeout, String msg) {
        this.exitmsg = msg;
        this.exittimeout = timeout;
        this.t = new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(String.format("%1$s[%2$dms:%3$s]", this.getClass().getName(), TimeoutExitMonitor.this.exittimeout, TimeoutExitMonitor.this.exitmsg));
                System.out.printf("%1$tF %1$tT\t\u542f\u52a8\uff1a%2$s\n", System.currentTimeMillis(), Thread.currentThread().getName());
                while (true) {
                    try {
                        if (TimeoutExitMonitor.this.on.get()) {
                            Thread.sleep(TimeoutExitMonitor.this.exittimeout);
                            break;
                        }
                        Thread.sleep(Long.MAX_VALUE);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
                System.err.printf("\n%1$tF %1$tT\t\u7ec8\u6b62\u7a0b\u5e8f\uff1a%2$s\n", System.currentTimeMillis(), Thread.currentThread().getName());
                System.exit(1);
            }
        });
        this.t.setDaemon(true);
        this.t.start();
    }

    public boolean start() {
        if (this.on.compareAndSet(false, true)) {
            this.t.interrupt();
            return true;
        }
        return false;
    }

    public boolean stop() {
        return this.on.compareAndSet(true, false);
    }

    public static void main(String[] args) {
        TimeoutExitMonitor te = new TimeoutExitMonitor(2000L, "\u53d1\u9001\u8d85\u65f6");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int i = 1890;
        while (true) {
            System.out.printf("\n%1$tF %1$tT\t\u5f00\u59cb\u53d1\u9001\uff0c\u542f\u52a8\u76d1\u89c6\uff1a%2$s\n", System.currentTimeMillis(), te.start());
            try {
                Thread.sleep(i);
                System.out.printf("%1$tF %1$tT\t\u53d1\u9001\u5b8c\u6bd5\uff0c\u53d6\u6d88\u76d1\u89c6\uff1a%2$s\n", System.currentTimeMillis(), te.stop());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            i += 100;
        }
    }
}

