/*
 * Decompiled with CFR 0.152.
 */
package jk.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jk.utils.HttpUtil;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherSkTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(WeatherSkTask.class);
    public static final String DEF_URL_WEATHER_SK = "http://www.weather.com.cn/data/sk/101050101.html";
    public static final int DEF_DELAY = 2000;
    public static final int DEF_PERIOD = 300000;
    public static File WSK_DIR;
    public static int WSK_REC_LEN;
    private static ThreadLocal<SimpleDateFormat> DF_FN;
    private static ThreadLocal<SimpleDateFormat> DF_Key;
    private static Map<String, String> cache;
    private static Pattern ptn_time;

    private static long calAddr(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int dd = cal.get(5) - cal.getMinimum(5);
        int hh = cal.get(11) - cal.getMinimum(11);
        long addr = WSK_REC_LEN * (dd * 24 + hh);
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sk_save(Date time, String sk) {
        block21: {
            boolean bl;
            File df = null;
            long addr = 0L;
            StringBuffer dat = new StringBuffer(WSK_REC_LEN);
            RandomAccessFile raf = null;
            try {
                df = new File(WSK_DIR, DF_FN.get().format(time));
                addr = WeatherSkTask.calAddr(time);
                if (addr + (long)WSK_REC_LEN < df.length()) {
                    log.error(df + ":\u4e0d\u5141\u8bb8\u91cd\u65b0\u5199\u5165:" + addr);
                    boolean bl2 = false;
                    return bl2;
                }
                if (addr > 0L) {
                    dat.append("\n");
                }
                dat.append(DF_Key.get().format(time));
                dat.append(sk);
                raf = new RandomAccessFile(df, "rw");
                raf.seek(addr);
                byte[] buf = dat.toString().getBytes("gbk");
                int len = buf.length;
                if (len > WSK_REC_LEN) {
                    raf.write(buf, 0, WSK_REC_LEN);
                } else {
                    raf.write(buf);
                    for (int i = WSK_REC_LEN - len; i > 0; --i) {
                        raf.writeByte(32);
                    }
                }
                raf.writeByte(32);
                raf.getChannel().force(true);
                if (log.isDebugEnabled()) {
                    log.debug("ok:" + addr + "-" + raf.getFilePointer());
                }
                bl = true;
            }
            catch (Exception e) {
                log.error("\u5199\u6570\u636e\u5931\u8d25:" + dat, e);
                break block21;
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sk_read(Date time) {
        String key = DF_Key.get().format(time);
        if (key.equals(cache.get("time"))) {
            return cache.get("sk");
        }
        File df = null;
        long addr = 0L;
        RandomAccessFile raf = null;
        try {
            df = new File(WSK_DIR, DF_FN.get().format(time));
            addr = WeatherSkTask.calAddr(time);
            if (addr + (long)WSK_REC_LEN > df.length()) {
                WeatherSkTask.sk_syn();
                if (key.equals(cache.get("time"))) {
                    String string = cache.get("sk");
                    return string;
                }
                String string = null;
                return string;
            }
            raf = new RandomAccessFile(df, "rw");
            raf.seek(addr);
            byte[] buf = new byte[WSK_REC_LEN];
            raf.read(buf);
            String sk = new String(buf, "gbk").trim();
            if (log.isDebugEnabled()) {
                log.debug(df + ":" + addr + "-" + sk);
            }
            if (!sk.startsWith(key)) {
                String string = null;
                return string;
            }
            String string = sk.substring(key.length());
            return string;
        }
        catch (Exception e) {
            log.error("\u8bfb\u6570\u636e\u5931\u8d25:" + new SimpleDateFormat("yyyy-MM-dd HH:mm").format(time), e);
            return null;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String sk_get() {
        if (cache.get("sk") == null) {
            WeatherSkTask.sk_syn();
        }
        return cache.get("sk");
    }

    public static String sk_query() {
        String sk = WeatherSkTask.v2_sk_query();
        if (sk != null) {
            return sk;
        }
        try {
            sk = IOUtils.toString(new URL(DEF_URL_WEATHER_SK), "utf-8");
            if (sk != null) {
                return sk;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5929\u6c14\u5b9e\u51b5\u9519\u8bef:http://www.weather.com.cn/data/sk/101050101.html");
        }
        return null;
    }

    public static String v2_sk_query() {
        String url = "http://www.nmc.gov.cn/publish/forecast/AHL/haerbin_iframe.html";
        String skt = "{\"weatherinfo\":{\"temp\":\"${temp}\",\"WD\":\"${WD}\",\"WS\":\"\",\"SD\":\"${SD}\",\"time\":\"${time}\"}}";
        Calendar cal = Calendar.getInstance();
        if (cal.get(12) < 20) {
            return null;
        }
        skt = skt.replace("${time}", String.format("%1$tH:00", cal.getTimeInMillis() - 3600000L));
        String res = null;
        try {
            res = HttpUtil.py(url, "gbk");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5b9e\u65f6\u5929\u6c14\u9519\u8bef\uff1a" + url, e);
            return null;
        }
        Matcher m = Pattern.compile("^.*\u6c14\u6e29\uff1a</div>(.+)\u2103\\s*<.*$", 8).matcher(res);
        if (m.find()) {
            skt = skt.replace("${temp}", m.group(1).trim());
        }
        if ((m = Pattern.compile("^.*\u6e7f\u5ea6\uff1a</div>(.+)<.*$", 8).matcher(res)).find()) {
            skt = skt.replace("${SD}", m.group(1).trim());
        }
        if ((m = Pattern.compile("^.*\u98ce\u901f\uff1a</div>(.+)<.*$", 8).matcher(res)).find()) {
            String s = m.group(1).replaceAll("\\s+[0-9.]+M/S$", "").trim();
            skt = skt.replace("${WD}", s);
        }
        return skt;
    }

    public static void start(File dir, boolean deamon) {
        WSK_DIR = dir;
        if (!WSK_DIR.exists()) {
            WSK_DIR.mkdirs();
        }
        new Timer(WeatherSkTask.class.getSimpleName(), deamon).schedule((TimerTask)new WeatherSkTask(), 2000L, 300000L);
    }

    @Override
    public void run() {
        WeatherSkTask.sk_syn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sk_syn() {
        if (DF_Key.get().format(new Date()).equals(cache.get("time"))) {
            return;
        }
        String sk = WeatherSkTask.sk_query();
        if (sk == null) {
            return;
        }
        try {
            Matcher m = ptn_time.matcher(sk);
            if (!m.find()) {
                log.error("\u63d0\u53d6\u5929\u6c14\u5b9e\u51b5\u53d1\u5e03\u65f6\u95f4\u9519\u8bef:" + sk);
                return;
            }
            Calendar cal = Calendar.getInstance();
            Calendar cur = Calendar.getInstance();
            cal.set(11, Integer.parseInt(m.group(2)));
            cal.set(12, Integer.parseInt(m.group(3)));
            if (cur.get(11) == 0 && cal.get(11) != 0) {
                cal.roll(5, -1);
                if (log.isDebugEnabled()) {
                    log.debug("" + cur.get(5));
                }
                if (cur.get(5) == 1) {
                    cal.roll(2, -1);
                }
                if (cur.get(2) == 0) {
                    cal.roll(1, -1);
                }
            }
            Date time = cal.getTime();
            if (DF_Key.get().format(time).equals(cache.get("time"))) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(time) + " # " + sk);
            }
            Map<String, String> map = cache;
            synchronized (map) {
                cache.put("time", DF_Key.get().format(time));
                cache.put("sk", sk);
            }
            WeatherSkTask.sk_save(time, sk);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        System.out.println(WeatherSkTask.v2_sk_query());
        System.exit(1);
        WeatherSkTask.start(new File("d:/weatherinfo"), true);
        Calendar cal = Calendar.getInstance();
        cal.set(2014, 1, 26, 0, 10, 1);
        String sk = WeatherSkTask.sk_query();
        while (sk == null) {
            sk = WeatherSkTask.sk_get();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat df2 = new SimpleDateFormat("HH:mm");
        for (int i = 0; i < 17520; ++i) {
            System.out.println(df1.format(cal.getTime()));
            WeatherSkTask.sk_save(cal.getTime(), sk.replace("09:00", df2.format(cal.getTime())));
            cal.roll(11, 1);
            if (cal.get(11) != cal.getMinimum(11)) continue;
            cal.roll(5, 1);
            if (cal.get(5) != cal.getMinimum(5)) continue;
            cal.roll(2, 1);
            if (cal.get(2) != cal.getMinimum(2)) continue;
            cal.roll(1, 1);
        }
    }

    static {
        WSK_REC_LEN = 250;
        DF_FN = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM.'wsk'");
            }
        };
        DF_Key = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyyMMddHH#");
            }
        };
        cache = new HashMap<String, String>();
        ptn_time = Pattern.compile("\"?time\"?:\"?(([0-9]+):([0-9]+))\"?");
    }
}

