/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpProtocolHandler;
import org.xlightweb.AbstractNetworkBodyDataSink;
import org.xlightweb.BadMessageException;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyDataSinkImplBase;
import org.xlightweb.BodylessBodyDataSink;
import org.xlightweb.DetailedClosedChannelException;
import org.xlightweb.FullMessageBodyDataSink;
import org.xlightweb.FullMessageChunkedBodyDataSink;
import org.xlightweb.HttpProtocolHandlerClientSide;
import org.xlightweb.HttpProtocolHandlerServerSide;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyAccessListener;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IForwardable;
import org.xlightweb.IHeader;
import org.xlightweb.IHttpConnectHandler;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpDisconnectHandler;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpMessageHeader;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpRequestTimeoutHandler;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IHttpSession;
import org.xlightweb.IHttpSocketTimeoutHandler;
import org.xlightweb.IUnsynchronized;
import org.xlightweb.InMemoryBodyDataSink;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.ProtocolException;
import org.xlightweb.SimpleMessageBodyDataSink;
import org.xlightweb.Supports100Continue;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.IDestroyable;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IHandlerChangeListener;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IWriteCompletionHandler;
import org.xsocket.connection.NonBlockingConnectionPool;

public abstract class AbstractHttpConnection
implements IHttpConnection,
IDestroyable {
    private static final Logger LOG = Logger.getLogger(AbstractHttpConnection.class.getName());
    private static final String DEFAULT_MAX_WRITE_BUFFER_SIZE = "65536";
    private static final int MAX_WRITEBUFFER_SIZE = Integer.parseInt(System.getProperty("org.xlightweb.connection.max_write_buffer_size", "65536"));
    private String defaultEncoding = IHttpMessage.DEFAULT_ENCODING;
    private static final DoNothingResponseHandler DO_NOTHING_RESPONSE_HANDLER = new DoNothingResponseHandler();
    private String closeReason = null;
    private final INonBlockingConnection tcpConnection;
    private final AtomicBoolean isPersistentRef = new AtomicBoolean(true);
    private final AtomicBoolean isClosing = new AtomicBoolean(false);
    private final AtomicReference<AbstractNetworkBodyDataSink> networkBodyDataSinkRef = new AtomicReference();
    private AtomicReference<Object> attachmentRef = new AtomicReference<Object>(null);
    private final DataHandler dataHandler = new DataHandler();
    private final AbstractHttpProtocolHandler protocolHandler;
    private final Set<IHttpConnectionHandler> connectionHandlers = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean isDisconnectedRef = new AtomicBoolean(false);
    private final IMultimodeExecutor multimodeExcutor;
    private long bodyDataReceiveTimeoutMillis = Long.MAX_VALUE;
    private long lastTimeDataWritten = System.currentTimeMillis();
    private long lastTimeHeaderReceivedMillis = System.currentTimeMillis();
    private long lastTimeMessageTailReceivedMillis = System.currentTimeMillis();
    private long lastTimeDataReceivedMillis = System.currentTimeMillis();
    boolean isAutoUncompress = false;
    private final AtomicInteger openTransactions = new AtomicInteger(0);
    private final AtomicInteger countReceivedMessages = new AtomicInteger(0);
    private final AtomicInteger countSentMessages = new AtomicInteger(0);
    private int countSendBytes = 0;
    private final AtomicInteger countReceivedBytes = new AtomicInteger(0);

    protected AbstractHttpConnection(INonBlockingConnection tcpConnection, boolean isClientSideConnection) throws IOException {
        this.tcpConnection = tcpConnection;
        this.multimodeExcutor = HttpUtils.newMultimodeExecutor(this.getWorkerpool());
        this.protocolHandler = isClientSideConnection ? new HttpProtocolHandlerClientSide() : new HttpProtocolHandlerServerSide();
        tcpConnection.setFlushmode(IConnection.FlushMode.ASYNC);
        tcpConnection.setAutoflush(false);
        tcpConnection.setAttachment(this);
        tcpConnection.setOption("IPPROTO_TCP.TCP_NODELAY", true);
    }

    protected final void init() throws IOException {
        this.tcpConnection.setHandler(this.dataHandler);
        this.onConnect();
    }

    final boolean isClosing() {
        return this.isClosing.get();
    }

    protected final int incCountMessageReceived() {
        return this.countReceivedMessages.incrementAndGet();
    }

    protected int getCountMessagesReceived() {
        return this.countReceivedMessages.get();
    }

    protected int getCountReceivedBytes() {
        return this.countReceivedBytes.get();
    }

    private void incReveived(int size) {
        this.countReceivedBytes.addAndGet(size);
        this.protocolHandler.incReveived(size);
    }

    protected final int incCountMessageSent() {
        return this.countSentMessages.incrementAndGet();
    }

    protected int getCountMessagesSent() {
        return this.countSentMessages.get();
    }

    protected final int getNumOpenTransactions() {
        return this.openTransactions.get();
    }

    protected final void setLastTimeDataReceivedMillis(long time) {
        this.lastTimeDataReceivedMillis = time;
    }

    protected long getLastTimeDataReceivedMillis() {
        return this.lastTimeDataReceivedMillis;
    }

    protected final void setLastTimeMessageTailReceivedMillis(long time) {
        this.lastTimeMessageTailReceivedMillis = time;
    }

    protected final long getLastTimeMessageTailReceivedMillis() {
        return this.lastTimeMessageTailReceivedMillis;
    }

    protected final void setLastTimeHeaderReceivedMillis(long time) {
        this.lastTimeHeaderReceivedMillis = time;
    }

    protected final long getLastTimeHeaderReceivedMillis() {
        return this.lastTimeHeaderReceivedMillis;
    }

    protected final long getLastTimeWritten() {
        return this.lastTimeDataWritten;
    }

    protected final IMultimodeExecutor getExecutor() {
        return this.multimodeExcutor;
    }

    @Override
    public INonBlockingConnection getUnderlyingTcpConnection() {
        return this.tcpConnection;
    }

    @Override
    public final long getBodyDataReceiveTimeoutMillis() {
        return this.bodyDataReceiveTimeoutMillis;
    }

    final String getCloseReason() {
        return this.closeReason;
    }

    @Override
    public final void addConnectionHandler(IHttpConnectionHandler connectionHandler) {
        if (connectionHandler == null) {
            throw new NullPointerException("conection handler has to be set");
        }
        this.connectionHandlers.add(connectionHandler);
        if (this.isDisconnectedRef.get()) {
            this.callOnDisconnect(connectionHandler, HttpUtils.getHttpConnectionHandlerInfo(connectionHandler));
        }
    }

    @Override
    public final void removeConnectionHandler(IHttpConnectionHandler connectionHandler) {
        this.connectionHandlers.remove(connectionHandler);
    }

    @Override
    public final void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        this.bodyDataReceiveTimeoutMillis = bodyDataReceiveTimeoutMillis;
    }

    @Override
    public final void setAttachment(Object attachment) {
        this.attachmentRef.set(attachment);
    }

    @Override
    public final Object getAttachment() {
        return this.attachmentRef.get();
    }

    @Override
    public final long getConnectionTimeoutMillis() {
        return this.tcpConnection.getConnectionTimeoutMillis();
    }

    @Override
    public final void setConnectionTimeoutMillis(long timeoutMillis) {
        this.tcpConnection.setConnectionTimeoutMillis(timeoutMillis);
    }

    @Override
    public final long getRemainingMillisToConnectionTimeout() {
        return this.tcpConnection.getRemainingMillisToConnectionTimeout();
    }

    @Override
    public final long getIdleTimeoutMillis() {
        return this.tcpConnection.getIdleTimeoutMillis();
    }

    @Override
    public final void setIdleTimeoutMillis(long timeoutInMillis) {
        this.tcpConnection.setIdleTimeoutMillis(timeoutInMillis);
    }

    @Override
    public final long getRemainingMillisToIdleTimeout() {
        return this.tcpConnection.getRemainingMillisToIdleTimeout();
    }

    @Override
    public final Map<String, Class> getOptions() {
        return this.tcpConnection.getOptions();
    }

    @Override
    public final Object getOption(String name) throws IOException {
        return this.tcpConnection.getOption(name);
    }

    @Override
    public final void setOption(String name, Object value) throws IOException {
        this.tcpConnection.setOption(name, value);
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.tcpConnection.getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.tcpConnection.getLocalPort();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.tcpConnection.getRemoteAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.tcpConnection.getRemotePort();
    }

    @Override
    public final void setWriteTransferRate(int bytesPerSecond) throws ClosedChannelException, IOException {
        this.tcpConnection.setWriteTransferRate(bytesPerSecond);
    }

    final IConnection.FlushMode getFlushmode() {
        return this.tcpConnection.getFlushmode();
    }

    @Override
    public final Executor getWorkerpool() {
        return this.tcpConnection.getWorkerpool();
    }

    public void setWorkerpool(Executor workerpool) {
        this.tcpConnection.setWorkerpool(workerpool);
    }

    @Override
    public void activateSecuredMode() throws IOException {
        this.tcpConnection.activateSecuredMode();
    }

    @Override
    public final boolean isSecure() {
        return this.tcpConnection.isSecure();
    }

    @Override
    public final boolean isPersistent() {
        return this.isPersistentRef.get();
    }

    protected final void setPersistent(boolean persistent) {
        this.isPersistentRef.set(persistent);
    }

    public final void setAutoUncompress(boolean isAutoUncompress) {
        this.isAutoUncompress = isAutoUncompress;
    }

    public final boolean isAutoUncompress() {
        return this.isAutoUncompress;
    }

    protected void setBodyDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    String getBodyDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public final String getId() {
        try {
            return this.tcpConnection.getId();
        }
        catch (Throwable t) {
            return "<unknown>";
        }
    }

    @Override
    public final boolean isOpen() {
        return !this.isDisconnectedRef.get() && this.tcpConnection.isOpen();
    }

    protected void onMessageCompleteReceived(IHttpMessageHeader header) {
        this.openTransactions.decrementAndGet();
    }

    @Override
    public void close() throws IOException {
        block7: {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] closing");
            }
            try {
                AbstractNetworkBodyDataSink messageWriter = this.networkBodyDataSinkRef.get();
                if (messageWriter != null) {
                    messageWriter.close();
                }
                this.releaseResources();
                if (this.isReuseable()) {
                    this.tcpConnection.close();
                } else {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] http connection is not reusable (isPersistent=" + this.isPersistentRef.get() + "). destroying it");
                    }
                    NonBlockingConnectionPool.destroy(this.tcpConnection);
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("error occured by closing htttp connection " + this.getId() + " " + DataConverter.toString(e));
            }
        }
    }

    @Override
    public final void closeQuitly() {
        block5: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by closing connection " + this.getId() + " " + ioe.toString());
                }
                try {
                    NonBlockingConnectionPool.destroy(this.tcpConnection);
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("[" + this.getId() + "] error occured by closing connection " + this.getId() + " " + e.toString());
                }
            }
        }
    }

    private void releaseResources() {
        AbstractNetworkBodyDataSink messageWriter = this.networkBodyDataSinkRef.get();
        if (messageWriter != null) {
            this.networkBodyDataSinkRef.set(null);
            messageWriter.onDisconnect();
        }
    }

    protected boolean isReuseable() {
        return this.isPersistentRef.get() && !this.isReceivingSuspended();
    }

    @Override
    public final void destroy() {
        this.destroy(0);
    }

    protected final void destroy(int delayMillis) {
        this.destroy("user initiated", delayMillis);
    }

    protected final void destroy(String reason) {
        this.destroy(reason, 0);
    }

    protected final void destroy(String reason, int delayMillis) {
        if (this.closeReason != null) {
            this.closeReason = "destroyed - " + reason;
        }
        this.setPersistent(false);
        this.isClosing.set(true);
        if (delayMillis > 0) {
            AbstractHttpConnection.schedule(new DelayedCloser(), delayMillis);
        } else {
            this.performDestroy();
        }
    }

    private void performDestroy() {
        block2: {
            this.releaseResources();
            try {
                NonBlockingConnectionPool.destroy(this.tcpConnection);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("[" + this.getId() + "] error occured by destroying htttp connection " + this.getId() + " " + ioe.toString());
            }
        }
    }

    @Override
    public final void suspendReceiving() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] suspend receving");
        }
        this.tcpConnection.suspendReceiving();
    }

    @Override
    public final boolean isReceivingSuspended() {
        return this.tcpConnection.isReceivingSuspended();
    }

    @Override
    public final void resumeReceiving() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] resume receving");
        }
        this.tcpConnection.resumeReceiving();
    }

    protected final void setNetworkBodyDataSinkIgnoreWriteError() {
        AbstractNetworkBodyDataSink ds = this.networkBodyDataSinkRef.get();
        if (ds != null) {
            ds.setIgnoreWriteError();
        }
    }

    final void setNetworkBodyDataSink(AbstractNetworkBodyDataSink networkBodyDataSink) {
        this.networkBodyDataSinkRef.set(networkBodyDataSink);
    }

    final boolean removeNetworkBodyDataSink(AbstractNetworkBodyDataSink networkBodyDataSink) {
        AbstractNetworkBodyDataSink oldNetworkBodyDataSink = this.networkBodyDataSinkRef.get();
        if (oldNetworkBodyDataSink != null && oldNetworkBodyDataSink == networkBodyDataSink) {
            this.networkBodyDataSinkRef.set(networkBodyDataSink);
            return true;
        }
        return false;
    }

    final void flush() throws IOException {
        this.tcpConnection.flush();
    }

    final int write(String txt) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] TCP write: " + txt);
        }
        this.lastTimeDataWritten = System.currentTimeMillis();
        int size = this.tcpConnection.write(txt);
        this.lastTimeDataWritten = System.currentTimeMillis();
        this.countSendBytes += size;
        return size;
    }

    final int write(byte[] bytes, IWriteCompletionHandler completionHandler) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] TCP write: " + new String(bytes));
        }
        this.lastTimeDataWritten = System.currentTimeMillis();
        int size = 0;
        if (completionHandler != null) {
            ByteBuffer[] buffer = new ByteBuffer[]{ByteBuffer.wrap(bytes)};
            size = bytes.length;
            this.tcpConnection.write(buffer, completionHandler);
        } else {
            size = this.tcpConnection.write(bytes);
        }
        this.lastTimeDataWritten = System.currentTimeMillis();
        this.countSendBytes += size;
        return size;
    }

    final long write(ByteBuffer[] buffer, IWriteCompletionHandler completionHandler) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            ByteBuffer[] bufs = new ByteBuffer[buffer.length];
            int i = 0;
            while (i < buffer.length) {
                bufs[i] = buffer[i].duplicate();
                ++i;
            }
            LOG.fine("[" + this.getId() + "] TCP write: " + DataConverter.toString(bufs));
        }
        int size = 0;
        if (completionHandler != null) {
            ByteBuffer[] byteBufferArray = buffer;
            int n = buffer.length;
            int n2 = 0;
            while (n2 < n) {
                ByteBuffer byteBuffer = byteBufferArray[n2];
                size += byteBuffer.remaining();
                ++n2;
            }
            this.tcpConnection.write(buffer, completionHandler);
        } else {
            size = (int)this.tcpConnection.write(buffer);
        }
        this.lastTimeDataWritten = System.currentTimeMillis();
        this.countSendBytes += size;
        return size;
    }

    final long write(ByteBuffer[] buffer) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            ByteBuffer[] bufs = new ByteBuffer[buffer.length];
            int i = 0;
            while (i < buffer.length) {
                bufs[i] = buffer[i].duplicate();
                ++i;
            }
            LOG.fine("[" + this.getId() + "] TCP write: " + DataConverter.toString(bufs));
        }
        int size = (int)this.tcpConnection.write(buffer);
        this.lastTimeDataWritten = System.currentTimeMillis();
        this.countSendBytes += size;
        return size;
    }

    protected abstract IMessageHeaderHandler getMessageHeaderHandler();

    protected void onProtocolException(Exception ex) {
        this.destroy(ex.toString());
    }

    protected void onMessageWritten() {
    }

    protected void onConnect() throws IOException {
        for (final IHttpConnectionHandler connectionHandler : this.connectionHandlers) {
            HttpUtils.HttpConnectionHandlerInfo connectionHandlerInfo = HttpUtils.getHttpConnectionHandlerInfo(connectionHandler);
            if (!connectionHandlerInfo.isConnectHandler()) continue;
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        ((IHttpConnectHandler)connectionHandler).onConnect(AbstractHttpConnection.this);
                    }
                    catch (IOException ioe) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + AbstractHttpConnection.this.getId() + "] error occured by performing onConnect on " + connectionHandler + " reason: " + ioe.toString());
                        }
                        AbstractHttpConnection.this.destroy();
                    }
                }
            };
            if (connectionHandlerInfo.isConnectHandlerMultithreaded()) {
                this.multimodeExcutor.processMultithreaded(task);
                continue;
            }
            this.multimodeExcutor.processNonthreaded(task);
        }
    }

    protected void onDisconnect() {
        block4: {
            try {
                if (!this.isDisconnectedRef.getAndSet(true)) {
                    for (IHttpConnectionHandler connectionHandler : this.connectionHandlers) {
                        HttpUtils.HttpConnectionHandlerInfo connectionHandlerInfo = HttpUtils.getHttpConnectionHandlerInfo(connectionHandler);
                        if (!connectionHandlerInfo.isDisconnectHandler()) continue;
                        this.callOnDisconnect(connectionHandler, connectionHandlerInfo);
                    }
                    this.connectionHandlers.clear();
                    this.releaseResources();
                }
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.fine("[" + this.getId() + "] error occured by closing http connection " + DataConverter.toString(t));
            }
        }
    }

    private void callOnDisconnect(final IHttpConnectionHandler connectionHandler, HttpUtils.HttpConnectionHandlerInfo connectionHandlerInfo) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    ((IHttpDisconnectHandler)connectionHandler).onDisconnect(AbstractHttpConnection.this);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + AbstractHttpConnection.this.getId() + "] error occured by performing ondisconnect on " + connectionHandler + " reason: " + ioe.toString());
                    }
                    AbstractHttpConnection.this.destroy();
                }
            }
        };
        if (connectionHandlerInfo.isDisconnectHandlerMultithreaded()) {
            this.multimodeExcutor.processMultithreaded(task);
        } else {
            this.multimodeExcutor.processNonthreaded(task);
        }
    }

    protected void onConnectionTimeout() {
        this.closeQuitly();
    }

    protected void onIdleTimeout() {
        this.closeQuitly();
    }

    protected final BodyDataSink writeMessage(int autocompressThresholdBytes, IHttpMessageHeader header) throws IOException {
        this.lastTimeDataWritten = System.currentTimeMillis();
        this.openTransactions.incrementAndGet();
        BodyDataSink ds = this.internalWriteMessage(header);
        ds.setAutocompressThreshold(autocompressThresholdBytes);
        return ds;
    }

    private BodyDataSink internalWriteMessage(IHttpMessageHeader header) throws IOException {
        BodyDataSink dataSink = null;
        if (header.getHeader("Upgrade") != null && header.getHeader("Upgrade").equalsIgnoreCase("WebSocket")) {
            dataSink = header.getHeader("Sec-WebSocket-Key1") != null ? this.internalWriteMessage(header, 8) : this.internalWriteMessage(header, 16);
        } else if (AbstractHttpConnection.isChunkedTransferEncoding(header)) {
            dataSink = new FullMessageChunkedBodyDataSink(this, header);
        } else if (header.getContentLength() != -1) {
            dataSink = this.internalWriteMessage(header, header.getContentLength());
        } else if (header.getHeader("Connection") != null && header.getHeader("Connection").equalsIgnoreCase("close")) {
            this.setPersistent(false);
            dataSink = new SimpleMessageBodyDataSink(this, header);
        } else if (header.getContentType() != null) {
            this.setPersistent(false);
            dataSink = new SimpleMessageBodyDataSink(this, header);
        } else {
            dataSink = new BodylessBodyDataSink(this, header);
        }
        return dataSink;
    }

    protected final BodyDataSink writeMessage(IHttpMessageHeader header, int length) throws IOException {
        this.lastTimeDataWritten = System.currentTimeMillis();
        this.openTransactions.incrementAndGet();
        return this.internalWriteMessage(header, length);
    }

    private BodyDataSink internalWriteMessage(IHttpMessageHeader header, int length) throws IOException {
        if (length > 0) {
            return new FullMessageBodyDataSink(this, header, length);
        }
        header.removeHeader("Content-Type");
        return new BodylessBodyDataSink(this, header);
    }

    protected final BodyDataSink writeMessage(int autocompressThreshold, IHttpMessage message) throws IOException {
        this.lastTimeDataWritten = System.currentTimeMillis();
        this.openTransactions.incrementAndGet();
        return this.internalWriteMessage(autocompressThreshold, message);
    }

    protected final BodyDataSink writeMessageSilence(IHttpMessage message) throws IOException {
        this.lastTimeDataWritten = System.currentTimeMillis();
        return this.internalWriteMessage(Integer.MAX_VALUE, message);
    }

    private BodyDataSink internalWriteMessage(int autocompressThreshold, IHttpMessage message) throws IOException {
        if (message.hasBody()) {
            return this.writeMessageWithBody(autocompressThreshold, message);
        }
        return this.writeMessageWithoutBody(message);
    }

    private BodyDataSink writeMessageWithoutBody(IHttpMessage message) throws IOException {
        this.write(String.valueOf(message.getMessageHeader().toString()) + "\r\n");
        this.flush();
        return null;
    }

    private BodyDataSink writeMessageWithBody(int autocompressThreshold, IHttpMessage message) throws IOException {
        BodyDataSink bodyDataSink = this.internalWriteMessage(message.getMessageHeader());
        bodyDataSink.setAutocompressThreshold(autocompressThreshold);
        NonBlockingBodyDataSource bodyDataSource = message.getNonBlockingBody();
        if (bodyDataSource.isComplete()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] message body to sent is complete. writing all data to body data sink");
            }
            bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
            bodyDataSink.setAutoflush(false);
            int available = bodyDataSource.available();
            if (available > 0) {
                bodyDataSink.write(bodyDataSource.readByteBufferByLength(available));
            }
            bodyDataSink.close();
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] message body to sent is not complete. creating forwarder");
            }
            bodyDataSink.setAutoflush(true);
            bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
            bodyDataSource.forwardTo(bodyDataSink);
        }
        return bodyDataSink;
    }

    static boolean isChunkedTransferEncoding(IHttpMessageHeader header) {
        String transferEncoding = header.getTransferEncoding();
        return transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked");
    }

    protected static boolean isNetworkendpoint(NonBlockingBodyDataSource dataSource) {
        return dataSource.isNetworkendpoint();
    }

    protected static int getDataReceived(NonBlockingBodyDataSource dataSource) {
        return dataSource.getDataReceived();
    }

    protected static void setDataHandlerSilence(NonBlockingBodyDataSource dataSource, IBodyDataHandler dataHandler) {
        dataSource.setDataHandlerSilence(dataHandler);
    }

    protected static IBodyDataHandler getDataHandlerSilence(NonBlockingBodyDataSource dataSource) {
        return dataSource.getDataHandlerSilence();
    }

    protected static int availableSilence(NonBlockingBodyDataSource dataSource) throws IOException {
        return dataSource.availableSilence();
    }

    protected static ByteBuffer[] readByteBufferByLengthSilence(NonBlockingBodyDataSource dataSource, int length) throws IOException {
        return dataSource.readByteBufferByLengthSilence(length);
    }

    protected static boolean isAcceptingChunkedResponseBody(IHttpRequest request) {
        String protocolVersion = request.getProtocolVersion();
        if (protocolVersion.equals("1.1")) {
            return true;
        }
        int idx = protocolVersion.indexOf(".");
        int minor = Integer.parseInt(protocolVersion.substring(idx + 1, protocolVersion.length()));
        if (minor > 0) {
            return true;
        }
        int major = Integer.parseInt(protocolVersion.substring(0, idx));
        return major > 1;
    }

    protected static void schedule(TimerTask task, long delay, long period) {
        HttpUtils.schedule(task, delay, period);
    }

    protected static void schedule(TimerTask task, long delay) {
        HttpUtils.schedule(task, delay);
    }

    protected static void setAutocompressThreshold(BodyDataSink dataSink, int autocompressThreshold) {
        dataSink.setAutocompressThreshold(autocompressThreshold);
    }

    protected static IMultimodeExecutor newMultimodeExecutor(Executor workerpool) {
        return HttpUtils.newMultimodeExecutor(workerpool);
    }

    protected static String parseEncoding(String contentType) {
        return HttpUtils.parseEncoding(contentType);
    }

    protected static BodyDataSink newInMemoryBodyDataSink(String id, IHttpMessageHeader header) throws IOException {
        return new InMemoryBodyDataSink(id, header);
    }

    protected static NonBlockingBodyDataSource getDataSourceOfInMemoryBodyDataSink(BodyDataSink dataSink) {
        return ((InMemoryBodyDataSink)dataSink).getDataSource();
    }

    protected static boolean isComplete(NonBlockingBodyDataSource body) {
        return body.isComplete();
    }

    protected static boolean isForwardable(NonBlockingBodyDataSource dataSource) {
        return dataSource.isForwardable();
    }

    protected static void forwardBody(NonBlockingBodyDataSource dataSource, BodyDataSink bodyDataSink) throws IOException {
        ((IForwardable)((Object)dataSource)).forwardTo(bodyDataSink);
    }

    protected static void forward(NonBlockingBodyDataSource dataSource, BodyDataSink dataSink) throws IOException {
        dataSource.forwardTo(dataSink);
    }

    protected static void addConnectionAttribute(IHttpResponseHeader header, IHttpConnection con) {
        HttpUtils.addConnectionAttribute(header, con);
    }

    protected static int getSizeDataReceived(NonBlockingBodyDataSource body) {
        return body.getSizeDataReceived();
    }

    protected static int getSizeWritten(BodyDataSink body) {
        return body.getSizeWritten();
    }

    protected static boolean isEmpty(ByteBuffer[] data) {
        return HttpUtils.isEmpty(data);
    }

    protected static ClosedChannelException newDetailedClosedChannelException(String reason) {
        return new DetailedClosedChannelException(reason);
    }

    protected static final IHttpResponseHandler newDoNothingResponseHandler() {
        return DO_NOTHING_RESPONSE_HANDLER;
    }

    protected static boolean isContentTypeSupportsCharset(String contentType) {
        return HttpUtils.isContentTypeSupportsCharset(contentType);
    }

    protected static boolean isSupports100Contine(IHttpResponseHandler handler) {
        return HttpUtils.getResponseHandlerInfo(handler).isContinueHandler();
    }

    protected static IHeader getReceviedHeader(ProtocolException pe) {
        return pe.getReceivedHeader();
    }

    protected static IHttpRequest newFormEncodedRequestWrapper(IHttpRequest request) throws IOException {
        return HttpUtils.newFormEncodedRequestWrapper(request);
    }

    protected final void setBodyCloseListener(BodyDataSink bodyDataSink, Runnable task) {
        bodyDataSink.addCloseListener(new BodyCloseListener(task));
    }

    protected static int getMaxWriteBufferSize() {
        return MAX_WRITEBUFFER_SIZE;
    }

    protected static String generateErrorMessageHtml(int errorCode, String msg, String connectionId) {
        if (msg == null) {
            msg = HttpUtils.getReason(errorCode);
        }
        msg = msg.replace("\r", "<br/>");
        String txt = "<html>\r\n  <!-- This page is auto-generated by xLightweb (http://xLightweb.org) -->\r\n  <!-- id " + connectionId + " -->\r\n" + "  <!-- xLightweb/" + HttpUtils.getImplementationVersion() + " (xSocket/" + ConnectionUtils.getImplementationVersion() + ") -->\r\n" + "  <head>\r\n" + "    <title>Error " + errorCode + "</title>\r\n" + "    <meta http-equiv=\"cache-control\" content=\"no-cache\"/>" + "  </head>\r\n\r\n" + "  <body>\r\n" + "    <H1 style=\"color:#0a328c;font-size:1.5em;\">ERROR " + errorCode + "</H1>\r\n" + "    <p style=\"font-size:1.5em;\">" + msg + "</p>\r\n" + "    <p style=\"font-size:0.8em;\">" + new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(new Date()) + "    xLightweb (" + HttpUtils.getImplementationVersion() + ")</p>\r\n" + "  <body>\r\n" + "</html>\r\n";
        return txt;
    }

    protected final BodyDataSink newEmtpyBodyDataSink(IHttpMessageHeader header) throws IOException {
        return new EmptyBodyDataSink(header);
    }

    private AbstractHttpProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    private static AbstractHttpConnection getHttpConnection(INonBlockingConnection tcpConnection) {
        return (AbstractHttpConnection)tcpConnection.getAttachment();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.getId()) + " " + this.tcpConnection.getLocalAddress() + ":" + this.tcpConnection.getLocalPort() + " -> " + this.tcpConnection.getRemoteAddress() + ":" + this.tcpConnection.getRemotePort());
        if (!this.tcpConnection.isOpen()) {
            sb.append("  (closed)");
        }
        if (this.tcpConnection.isReceivingSuspended()) {
            sb.append("  (suspended)");
        }
        return sb.toString();
    }

    String toDetailedString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getId());
        try {
            sb.append(this.tcpConnection.getLocalAddress() + ":" + this.tcpConnection.getLocalPort() + " -> " + this.tcpConnection.getRemoteAddress() + ":" + this.tcpConnection.getRemotePort());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.tcpConnection.isOpen()) {
            sb.append("  (closed)");
        }
        if (this.protocolHandler != null) {
            sb.append(" " + this.protocolHandler.toString());
        } else {
            sb.append(" protocolHandler=null");
        }
        sb.append(" isPersistent=" + this.isPersistentRef.get());
        return sb.toString();
    }

    protected static abstract class AbstractExchange
    implements IHttpExchange {
        private final AtomicBoolean isResponseCommitted = new AtomicBoolean(false);
        private boolean is100ContinueSent = false;
        private final AbstractExchange parentExchange;
        private final IMultimodeExecutor executor;
        private IHttpConnection httpCon = null;

        protected AbstractExchange(IHttpExchange parentExchange) {
            if (parentExchange != null && parentExchange instanceof AbstractExchange) {
                this.parentExchange = (AbstractExchange)parentExchange;
                this.executor = ((AbstractExchange)parentExchange).getExecutor();
            } else {
                this.parentExchange = null;
                this.executor = HttpUtils.newMultimodeExecutor();
            }
            if (parentExchange != null) {
                this.httpCon = parentExchange.getConnection();
            }
        }

        protected AbstractExchange(AbstractExchange parentExchange, Executor workerpool) {
            this.parentExchange = parentExchange;
            this.executor = HttpUtils.newMultimodeExecutor();
        }

        protected AbstractExchange(AbstractExchange parentExchange, AbstractHttpConnection httpCon) {
            this.parentExchange = parentExchange;
            this.setHttpConnection(httpCon);
            this.executor = httpCon.getExecutor();
        }

        protected final void setHttpConnection(IHttpConnection httpCon) {
            this.httpCon = httpCon;
        }

        IMultimodeExecutor getExecutor() {
            return this.executor;
        }

        protected final void setHttpConnection(AbstractHttpConnection httpCon) {
            this.httpCon = httpCon;
        }

        protected final boolean isResponseCommitted() {
            return this.isResponseCommitted.get();
        }

        protected final void setResponseCommited(boolean isCommitted) {
            this.isResponseCommitted.set(isCommitted);
        }

        protected final void ensureResponseHasNotBeenCommitted() throws IOException {
            if (this.isResponseCommitted()) {
                throw new IOException("response has already been committed");
            }
        }

        protected String getId() {
            if (this.httpCon != null) {
                return this.httpCon.getId();
            }
            return Integer.toString(this.hashCode());
        }

        @Override
        public final IHttpConnection getConnection() {
            if (this.httpCon != null) {
                return this.httpCon;
            }
            return new NullConnection(this.executor.getWorkerpool());
        }

        @Override
        public final void destroy() {
            if (this.httpCon != null) {
                this.httpCon.destroy();
            }
        }

        protected final void destroy(String reason) {
            if (this.httpCon != null) {
                this.httpCon.destroy();
            }
        }

        @Override
        public void sendRedirect(String location) throws IllegalStateException {
            if (!HttpUtils.isAbsoluteURL(location)) {
                String url = HttpUtils.getRequestURLWithoutQueryParams(this.getRequest().getRequestHeader());
                if (location.startsWith("/")) {
                    String base = url.substring(0, url.length() - this.getRequest().getRequestURI().length());
                    location = String.valueOf(base) + this.getRequest().getContextPath() + location;
                } else {
                    location = String.valueOf(url) + "/" + location;
                }
            }
            String txt = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\r\n<html><head>\r\n<title>302 Found</title>\r\n</head><body>\r\n<h1>Found</h1>\r\n<p>The document has moved <a href=\"" + location + "\">here</a>.</p>\r\n" + "</body></html>";
            try {
                HttpResponse response = new HttpResponse(302, "text/html", txt);
                response.setHeader("Location", location);
                this.send(response);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public final void sendError(int errorCode) {
            this.sendError(errorCode, HttpUtils.getReason(errorCode));
        }

        @Override
        public void sendError(int errorCode, String msg) {
            try {
                this.send(new HttpResponse(errorCode, "text/html", AbstractHttpConnection.generateErrorMessageHtml(errorCode, msg, this.getId())));
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] could not send error message " + errorCode + " reason " + ioe.toString());
                }
                this.destroy(ioe.toString());
            }
        }

        @Override
        public final boolean sendContinue() throws IOException {
            return this.sendContinueIfRequested();
        }

        @Override
        public final boolean sendContinueIfRequested() throws IOException {
            if (HttpUtils.isContainExpect100ContinueHeader(this.getRequest().getRequestHeader()) && !this.is100ContinueSent()) {
                this.is100ContinueSent = true;
                this.doSendContinue();
                if (this.parentExchange != null) {
                    this.parentExchange.set100ContinueSent(this.is100ContinueSent);
                }
                return true;
            }
            return false;
        }

        void set100ContinueSent(boolean is100ContinueSent) {
            this.is100ContinueSent = is100ContinueSent;
            if (this.parentExchange != null) {
                this.parentExchange.set100ContinueSent(is100ContinueSent);
            }
        }

        protected void doSendContinue() throws IOException {
            this.send(new HttpResponse(100));
        }

        protected final boolean is100ContinueSent() {
            if (this.parentExchange != null) {
                return this.parentExchange.is100ContinueSent() || this.is100ContinueSent;
            }
            return this.is100ContinueSent;
        }

        protected final void callResponseHandler(IHttpResponseHandler responseHandler, IHttpResponse response) throws IOException {
            HttpUtils.ResponseHandlerInfo handlerInfo = HttpUtils.getResponseHandlerInfo(responseHandler);
            if (response.hasBody() && handlerInfo.isResponseHandlerInvokeOnMessageReceived()) {
                NonBlockingBodyDataSource ds = response.getNonBlockingBody();
                BodyListener bodyListener = new BodyListener(ds, responseHandler, handlerInfo, response);
                ds.addCompleteListener(bodyListener);
                ds.addDestroyListener(bodyListener);
            } else {
                this.callResponseHandler(responseHandler, handlerInfo, response);
            }
        }

        protected final void callResponseHandler(final IHttpResponseHandler responseHandler, HttpUtils.ResponseHandlerInfo handlerInfo, final IHttpResponse response) {
            if (handlerInfo.isUnsynchronized()) {
                this.call(responseHandler, response);
            } else {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        AbstractExchange.this.call(responseHandler, response);
                    }
                };
                if (handlerInfo.isResponseHandlerMultithreaded()) {
                    this.executor.processMultithreaded(task);
                } else {
                    this.executor.processNonthreaded(task);
                }
            }
        }

        private void call(IHttpResponseHandler responseHandler, IHttpResponse response) {
            block3: {
                try {
                    responseHandler.onResponse(response);
                }
                catch (IOException ioe) {
                    if (this.httpCon == null) break block3;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.httpCon.getId() + "] Error occured by calling response handler " + responseHandler + " " + ioe.toString());
                    }
                    this.destroy(ioe.toString());
                }
            }
        }

        protected final void callResponseHandler(IHttpResponseHandler responseHandler, IOException ioe) {
            this.callResponseHandler(responseHandler, HttpUtils.getResponseHandlerInfo(responseHandler), ioe);
        }

        protected final void callResponseHandler(final IHttpResponseHandler responseHandler, HttpUtils.ResponseHandlerInfo handlerInfo, final IOException ioe) {
            if (handlerInfo.isUnsynchronized()) {
                this.call(responseHandler, ioe);
            } else {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        AbstractExchange.this.call(responseHandler, ioe);
                    }
                };
                if (handlerInfo.isResponseHandlerMultithreaded()) {
                    this.executor.processMultithreaded(task);
                } else {
                    this.executor.processNonthreaded(task);
                }
            }
        }

        private void call(IHttpResponseHandler responseHandler, IOException ioe) {
            block5: {
                try {
                    if (ioe instanceof SocketTimeoutException && HttpUtils.getResponseHandlerInfo(responseHandler).isSocketTimeoutHandler()) {
                        ((IHttpSocketTimeoutHandler)((Object)responseHandler)).onException((SocketTimeoutException)ioe);
                    } else {
                        responseHandler.onException(ioe);
                    }
                }
                catch (IOException e) {
                    if (this.httpCon == null) break block5;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.httpCon.getId() + "] Error occured by calling response handler " + responseHandler + " " + e.toString());
                    }
                    this.destroy(e.toString());
                }
            }
        }

        private final class BodyListener
        implements IBodyCompleteListener,
        IBodyDestroyListener {
            private NonBlockingBodyDataSource ds;
            private IHttpResponseHandler responseHandler;
            private HttpUtils.ResponseHandlerInfo handlerInfo;
            private IHttpResponse response;

            public BodyListener(NonBlockingBodyDataSource ds, IHttpResponseHandler responseHandler, HttpUtils.ResponseHandlerInfo handlerInfo, IHttpResponse response) {
                this.ds = ds;
                this.responseHandler = responseHandler;
                this.handlerInfo = handlerInfo;
                this.response = response;
            }

            @Override
            public void onComplete() throws IOException {
                AbstractExchange.this.callResponseHandler(this.responseHandler, this.handlerInfo, this.response);
            }

            @Override
            public void onDestroyed() throws IOException {
                IOException ioe = this.ds.getException();
                if (ioe == null) {
                    ioe = new IOException("data source hhas been destroyed");
                }
                this.responseHandler.onException(ioe);
            }
        }
    }

    private static final class BodyCloseListener
    implements IBodyCloseListener {
        private Runnable task = null;

        public BodyCloseListener(Runnable task) {
            this.task = task;
        }

        @Override
        public void onClose() throws IOException {
            this.task.run();
        }
    }

    @Execution(value=0)
    final class DataHandler
    implements IDataHandler,
    IConnectHandler,
    IDisconnectHandler,
    IIdleTimeoutHandler,
    IConnectionTimeoutHandler,
    IHandlerChangeListener {
        private ByteBuffer[] rawBuffers = null;

        DataHandler() {
        }

        @Override
        public boolean onData(INonBlockingConnection connection) throws BufferUnderflowException {
            AbstractHttpConnection.this.lastTimeDataReceivedMillis = System.currentTimeMillis();
            if (connection.isOpen() && !AbstractHttpConnection.this.isClosing()) {
                try {
                    AbstractHttpProtocolHandler protocolHandler = AbstractHttpConnection.getHttpConnection(connection).getProtocolHandler();
                    int available = connection.available();
                    if (available > 0) {
                        ByteBuffer[] data = connection.readByteBufferByLength(available);
                        AbstractHttpConnection.this.incReveived(available);
                        this.rawBuffers = this.rawBuffers == null ? data : HttpUtils.merge(this.rawBuffers, data);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + AbstractHttpConnection.this.getId() + "] TCP read (total received: " + protocolHandler.getReceived() + ", currentRawBuffer=" + HttpUtils.computeRemaining(this.rawBuffers) + ") ");
                            LOG.fine("[" + AbstractHttpConnection.this.getId() + "] calling protocol handler " + protocolHandler.getClass().getName() + "#" + protocolHandler.hashCode());
                        }
                        this.rawBuffers = protocolHandler.onData(AbstractHttpConnection.this, this.rawBuffers);
                    }
                    return true;
                }
                catch (ClosedChannelException cce) {
                    AbstractHttpConnection.this.setPersistent(false);
                    AbstractHttpConnection.this.protocolHandler.onDisconnect(AbstractHttpConnection.this, this.rawBuffers);
                }
                catch (IOException ex) {
                    AbstractHttpConnection.this.setPersistent(false);
                    AbstractHttpConnection.this.protocolHandler.onException(AbstractHttpConnection.this, ex, this.rawBuffers);
                    AbstractHttpConnection.this.onProtocolException(ex);
                }
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + AbstractHttpConnection.this.getId() + "] Connection is closed. ignoring  incoming data");
            }
            return true;
        }

        @Override
        public void onHanderReplaced(IHandler oldHandler, IHandler newHandler) {
            block4: {
                if (oldHandler == this) {
                    try {
                        if (this.rawBuffers != null) {
                            AbstractHttpConnection.this.getUnderlyingTcpConnection().unread(HttpUtils.compact(this.rawBuffers));
                        }
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block4;
                        LOG.fine("[" + AbstractHttpConnection.this.getId() + "] could not unread " + ioe.toString());
                    }
                }
            }
        }

        @Override
        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            return true;
        }

        @Override
        public boolean onDisconnect(INonBlockingConnection connection) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + AbstractHttpConnection.this.getId() + "] disconnected");
            }
            AbstractHttpProtocolHandler protocolHandler = AbstractHttpConnection.getHttpConnection(connection).getProtocolHandler();
            protocolHandler.onDisconnect(AbstractHttpConnection.this, this.rawBuffers);
            AbstractHttpConnection.this.onDisconnect();
            return true;
        }

        @Override
        public boolean onConnectionTimeout(INonBlockingConnection connection) {
            if (!AbstractHttpConnection.this.isClosing()) {
                AbstractHttpConnection.this.onConnectionTimeout();
            }
            return true;
        }

        @Override
        public boolean onIdleTimeout(INonBlockingConnection connection) {
            if (!AbstractHttpConnection.this.isClosing()) {
                AbstractHttpConnection.this.onIdleTimeout();
            }
            return true;
        }

        ByteBuffer[] drainBuffer() {
            ByteBuffer[] result = this.rawBuffers;
            this.rawBuffers = null;
            return result;
        }
    }

    private final class DelayedCloser
    extends TimerTask {
        private DelayedCloser() {
        }

        @Override
        public void run() {
            AbstractHttpConnection.this.performDestroy();
        }
    }

    private static final class DoNothingResponseHandler
    implements IHttpResponseHandler,
    IUnsynchronized {
        private DoNothingResponseHandler() {
        }

        @Override
        public void onResponse(IHttpResponse response) throws IOException {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("ignoring response " + response.getResponseHeader());
            }
        }

        @Override
        public void onException(IOException ioe) throws IOException {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("ignoring exception " + ioe.toString());
            }
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    private static final class EmptyBodyDataSink
    extends BodyDataSinkImplBase {
        public EmptyBodyDataSink(IHttpMessageHeader header) throws IOException {
            super(header, HttpUtils.newMultimodeExecutor());
        }

        @Override
        protected boolean isNetworkendpoint() {
            return false;
        }

        @Override
        void onClose() throws IOException {
        }

        @Override
        void onDestroy(String reason) {
        }

        @Override
        int getPendingWriteDataSize() {
            return 0;
        }

        @Override
        int onWriteData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
            int written = 0;
            ByteBuffer[] byteBufferArray = dataToWrite;
            int n = dataToWrite.length;
            int n2 = 0;
            while (n2 < n) {
                ByteBuffer buffer = byteBufferArray[n2];
                written += buffer.remaining();
                ++n2;
            }
            return written;
        }
    }

    protected static interface IMessageHandler {
        public void onBodyException(IOException var1, ByteBuffer[] var2);

        public void onMessageReceived() throws IOException;

        public void onHeaderProcessed() throws IOException;
    }

    protected static interface IMessageHeaderHandler {
        public IMessageHandler onMessageHeaderReceived(IHttpMessage var1) throws IOException;

        public void onHeaderException(IOException var1, ByteBuffer[] var2);

        public IHttpMessageHeader getAssociatedHeader();
    }

    protected static interface IMultimodeExecutor {
        public void processMultithreaded(Runnable var1);

        public void processNonthreaded(Runnable var1);

        public Executor getWorkerpool();
    }

    private static interface IResponseHandlerAdapter {
        public void onResponse(IHttpResponse var1, AbstractHttpConnection var2);
    }

    private static final class NullConnection
    implements IHttpConnection {
        private Object attachment;
        private final Executor workerpool;

        public NullConnection(Executor workerpool) {
            this.workerpool = workerpool;
        }

        @Override
        public void activateSecuredMode() throws IOException {
        }

        @Override
        public void addConnectionHandler(IHttpConnectionHandler connectionHandler) {
        }

        @Override
        public long getBodyDataReceiveTimeoutMillis() {
            return 0L;
        }

        @Override
        public INonBlockingConnection getUnderlyingTcpConnection() {
            return null;
        }

        @Override
        public Executor getWorkerpool() {
            return this.workerpool;
        }

        @Override
        public boolean isPersistent() {
            return false;
        }

        @Override
        public boolean isReceivingSuspended() {
            return false;
        }

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public void removeConnectionHandler(IHttpConnectionHandler connectionHandler) {
        }

        @Override
        public void resumeReceiving() throws IOException {
        }

        @Override
        public void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        }

        @Override
        public void setWriteTransferRate(int bytesPerSecond) throws ClosedChannelException, IOException {
        }

        @Override
        public void suspendReceiving() throws IOException {
        }

        @Override
        public long getConnectionTimeoutMillis() {
            return 0L;
        }

        @Override
        public String getId() {
            return "<unset>";
        }

        @Override
        public long getIdleTimeoutMillis() {
            return 0L;
        }

        @Override
        public InetAddress getLocalAddress() {
            return null;
        }

        @Override
        public int getLocalPort() {
            return 0;
        }

        @Override
        public Object getOption(String name) throws IOException {
            return null;
        }

        @Override
        public Map<String, Class> getOptions() {
            return null;
        }

        @Override
        public long getRemainingMillisToConnectionTimeout() {
            return 0L;
        }

        @Override
        public long getRemainingMillisToIdleTimeout() {
            return 0L;
        }

        @Override
        public InetAddress getRemoteAddress() {
            return null;
        }

        @Override
        public int getRemotePort() {
            return 0;
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public boolean isServerSide() {
            return false;
        }

        @Override
        public void setAttachment(Object obj) {
            this.attachment = obj;
        }

        @Override
        public Object getAttachment() {
            return this.attachment;
        }

        @Override
        public void setConnectionTimeoutMillis(long timeoutMillis) {
        }

        @Override
        public void setIdleTimeoutMillis(long timeoutInMillis) {
        }

        @Override
        public void setOption(String name, Object value) throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void closeQuitly() {
        }

        @Override
        public void destroy() {
        }
    }

    protected static final class RequestHandlerAdapter {
        private final IHttpRequestHandler requestHandler;
        private final IHttpRequestTimeoutHandler requestTimeoutHandler;
        private final boolean isInvokeOnMessageReceived;
        private final boolean isContinueHandler;

        public RequestHandlerAdapter(IHttpRequestHandler delegate) {
            HttpUtils.RequestHandlerInfo handlerInfo = HttpUtils.getRequestHandlerInfo(delegate);
            this.isInvokeOnMessageReceived = handlerInfo.isRequestHandlerInvokeOnMessageReceived();
            this.isContinueHandler = handlerInfo.isContinueHandler();
            this.requestTimeoutHandler = handlerInfo.isRequestTimeoutHandler() ? (handlerInfo.isUnsynchronized() ? (IHttpRequestTimeoutHandler)((Object)delegate) : (handlerInfo.isRequestTimeoutHandlerMultithreaded() ? new MultithreadedRequestTimeoutHandlerAdapter((IHttpRequestTimeoutHandler)((Object)delegate)) : new NonthreadedRequestTimeoutHandlerAdapter((IHttpRequestTimeoutHandler)((Object)delegate)))) : new EmptyRequestTimeoutHandlerAdapter();
            if (handlerInfo.isRequestHandlerSynchronizedOnSession()) {
                delegate = new SessionSynchronizedRequestHandlerAdapter(delegate);
            }
            this.requestHandler = handlerInfo.isRequestHandlerSynchronizedOnSession() ? new MultithreadedRequestHandlerAdapter(delegate) : (handlerInfo.isUnsynchronized() ? delegate : (handlerInfo.isRequestHandlerMultithreaded() ? new MultithreadedRequestHandlerAdapter(delegate) : new NonthreadedRequestHandlerAdapter(delegate)));
        }

        public String toString() {
            return this.requestHandler.toString();
        }

        public final IHttpRequestHandler getDelegate() {
            return this.requestHandler;
        }

        public final boolean isInvokeOnMessageReceived() {
            return this.isInvokeOnMessageReceived;
        }

        private final boolean isContinueHandler() {
            return this.isContinueHandler;
        }

        public final void onRequest(IHttpExchange exchange) {
            this.performRequestHandler(this.requestHandler, exchange);
        }

        private void performRequestHandler(IHttpRequestHandler handler, final IHttpExchange exchange) {
            try {
                if (!this.isContinueHandler() && HttpUtils.isContainExpect100ContinueHeader(exchange.getRequest().getRequestHeader()) && exchange.getRequest().hasBody()) {
                    IBodyAccessListener al = new IBodyAccessListener(){

                        @Override
                        public boolean onBodyAccess() {
                            block2: {
                                try {
                                    exchange.sendContinueIfRequested();
                                }
                                catch (IOException ioe) {
                                    if (!LOG.isLoggable(Level.FINE)) break block2;
                                    LOG.fine("error occured by trying to dsend 100-continue " + ioe.toString());
                                }
                            }
                            return true;
                        }
                    };
                    exchange.getRequest().getNonBlockingBody().setBodyAccessListener(al);
                }
                handler.onRequest(exchange);
            }
            catch (BadMessageException bme) {
                if (HttpUtils.isShowDetailedError()) {
                    exchange.sendError(bme.getStatus(), DataConverter.toString(bme));
                } else {
                    exchange.sendError(bme.getStatus());
                }
            }
            catch (IOException e) {
                if (exchange.getConnection() instanceof AbstractHttpConnection) {
                    ((AbstractHttpConnection)exchange.getConnection()).setPersistent(false);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + exchange.getConnection().getId() + "] error occured by calling on request " + this.requestHandler + " " + DataConverter.toString(e));
                }
                if (exchange instanceof AbstractExchange && !((AbstractExchange)exchange).isResponseCommitted()) {
                    exchange.sendError(e);
                    return;
                }
                exchange.destroy();
            }
            catch (IllegalStateException e) {
                if (exchange.getConnection() instanceof AbstractHttpConnection) {
                    ((AbstractHttpConnection)exchange.getConnection()).setPersistent(false);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + exchange.getConnection().getId() + "] error occured by calling on request " + this.requestHandler + " " + DataConverter.toString(e));
                }
                if (exchange instanceof AbstractExchange && !((AbstractExchange)exchange).isResponseCommitted()) {
                    exchange.sendError(e);
                    return;
                }
                exchange.destroy();
            }
            catch (Exception e) {
                if (exchange.getConnection() instanceof AbstractHttpConnection) {
                    ((AbstractHttpConnection)exchange.getConnection()).setPersistent(false);
                }
                LOG.warning("[" + exchange.getConnection().getId() + "] error occured by calling on request " + this.requestHandler + " " + DataConverter.toString(e));
                if (exchange instanceof AbstractExchange && !((AbstractExchange)exchange).isResponseCommitted()) {
                    exchange.sendError(e);
                    return;
                }
                exchange.destroy();
            }
        }

        public final void onRequestTimeout(IHttpConnection connection) {
            this.performRequestTimeoutHandler(this.requestTimeoutHandler, connection);
        }

        private void performRequestTimeoutHandler(IHttpRequestTimeoutHandler handler, IHttpConnection connection) {
            block5: {
                try {
                    boolean isHandled = handler.onRequestTimeout(connection);
                    if (!isHandled) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + connection.getId() + "] request timeout reached for http server connection. terminate connection (timeout handler returned false)");
                        }
                        this.closeConnection(connection);
                    }
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + connection.getId() + "] error occured by calling on request " + handler + " " + e.toString());
                    }
                    if (!(connection instanceof AbstractHttpConnection)) break block5;
                    ((AbstractHttpConnection)connection).destroy(e.toString());
                }
            }
        }

        private void closeConnection(IHttpConnection connection) {
            block2: {
                try {
                    connection.close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("[" + connection.getId() + "] error occured by closing connection");
                }
            }
        }

        private static final class EmptyRequestTimeoutHandlerAdapter
        implements IHttpRequestTimeoutHandler {
            private EmptyRequestTimeoutHandlerAdapter() {
            }

            @Override
            public boolean onRequestTimeout(IHttpConnection connection) throws IOException {
                return false;
            }

            public String toString() {
                return String.valueOf(this.getClass().getSimpleName()) + "#" + this.hashCode();
            }
        }

        @Supports100Continue
        private final class MultithreadedRequestHandlerAdapter
        implements IHttpRequestHandler {
            private final IHttpRequestHandler delegate;

            public MultithreadedRequestHandlerAdapter(IHttpRequestHandler delegate) {
                this.delegate = delegate;
            }

            @Override
            public void onRequest(final IHttpExchange exchange) throws IOException, BadMessageException {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        RequestHandlerAdapter.this.performRequestHandler(MultithreadedRequestHandlerAdapter.this.delegate, exchange);
                    }
                };
                if (exchange instanceof AbstractExchange) {
                    ((AbstractExchange)exchange).getExecutor().processMultithreaded(task);
                } else {
                    HttpUtils.newMultimodeExecutor().processMultithreaded(task);
                }
            }

            public String toString() {
                return String.valueOf(super.getClass().getName()) + "*" + this.delegate.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
            }
        }

        private final class MultithreadedRequestTimeoutHandlerAdapter
        implements IHttpRequestTimeoutHandler {
            private final IHttpRequestTimeoutHandler delegate;

            public MultithreadedRequestTimeoutHandlerAdapter(IHttpRequestTimeoutHandler delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean onRequestTimeout(final IHttpConnection connection) throws IOException {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        RequestHandlerAdapter.this.performRequestTimeoutHandler(MultithreadedRequestTimeoutHandlerAdapter.this.delegate, (AbstractHttpConnection)connection);
                    }
                };
                if (connection instanceof AbstractHttpConnection) {
                    ((AbstractHttpConnection)connection).getExecutor().processMultithreaded(task);
                } else {
                    HttpUtils.newMultimodeExecutor().processMultithreaded(task);
                }
                return true;
            }

            public String toString() {
                return String.valueOf(super.getClass().getName()) + "*" + this.delegate.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
            }
        }

        @Supports100Continue
        private final class NonthreadedRequestHandlerAdapter
        implements IHttpRequestHandler {
            private final IHttpRequestHandler delegate;

            public NonthreadedRequestHandlerAdapter(IHttpRequestHandler delegate) {
                this.delegate = delegate;
            }

            @Override
            public void onRequest(final IHttpExchange exchange) throws IOException, BadMessageException {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        RequestHandlerAdapter.this.performRequestHandler(NonthreadedRequestHandlerAdapter.this.delegate, exchange);
                    }
                };
                if (exchange instanceof AbstractExchange) {
                    ((AbstractExchange)exchange).getExecutor().processNonthreaded(task);
                } else {
                    HttpUtils.newMultimodeExecutor().processNonthreaded(task);
                }
            }

            public String toString() {
                return String.valueOf(super.getClass().getName()) + "*" + this.delegate.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
            }
        }

        private final class NonthreadedRequestTimeoutHandlerAdapter
        implements IHttpRequestTimeoutHandler {
            private final IHttpRequestTimeoutHandler delegate;

            public NonthreadedRequestTimeoutHandlerAdapter(IHttpRequestTimeoutHandler delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean onRequestTimeout(final IHttpConnection connection) throws IOException {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        RequestHandlerAdapter.this.performRequestTimeoutHandler(NonthreadedRequestTimeoutHandlerAdapter.this.delegate, (AbstractHttpConnection)connection);
                    }
                };
                if (connection instanceof AbstractHttpConnection) {
                    ((AbstractHttpConnection)connection).getExecutor().processNonthreaded(task);
                } else {
                    HttpUtils.newMultimodeExecutor().processNonthreaded(task);
                }
                return true;
            }

            public String toString() {
                return String.valueOf(super.getClass().getName()) + "*" + this.delegate.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
            }
        }

        @Supports100Continue
        private static final class SessionSynchronizedRequestHandlerAdapter
        implements IHttpRequestHandler {
            private IHttpRequestHandler delegate = null;

            public SessionSynchronizedRequestHandlerAdapter(IHttpRequestHandler delegate) {
                this.delegate = delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequest(IHttpExchange exchange) throws IOException {
                IHttpSession session = exchange.getSession(false);
                if (session == null) {
                    this.delegate.onRequest(exchange);
                } else {
                    IHttpSession iHttpSession = session;
                    synchronized (iHttpSession) {
                        this.delegate.onRequest(exchange);
                    }
                }
            }

            public String toString() {
                return String.valueOf(super.getClass().getName()) + "*" + this.delegate.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
            }
        }
    }

    protected static final class ResponseHandlerAdapter
    implements IResponseHandlerAdapter {
        private final IResponseHandlerAdapter responseHandlerAdapter;
        private final IHttpResponseHandler exceptionHandler;
        private final HttpUtils.ResponseHandlerInfo handlerInfo;
        private final boolean isContinueResponseExpected;
        private final AtomicBoolean is100ContinueHandled = new AtomicBoolean(false);

        public ResponseHandlerAdapter(IHttpResponseHandler delegate, IHttpRequestHeader requestHeader) {
            this.handlerInfo = HttpUtils.getResponseHandlerInfo(delegate);
            this.isContinueResponseExpected = HttpUtils.isContainExpect100ContinueHeader(requestHeader);
            this.exceptionHandler = delegate;
            this.responseHandlerAdapter = this.handlerInfo.isUnsynchronized() ? new UnsynchronizedResponseHandlerAdapter(delegate) : (this.handlerInfo.isResponseHandlerMultithreaded() ? new MultithreadedResponseHandlerAdapter(delegate) : new NonthreadedResponseHandlerAdapter(delegate));
        }

        public boolean isInvokeOnMessageReceived() {
            return this.handlerInfo.isResponseHandlerInvokeOnMessageReceived();
        }

        public boolean isContinueHandler() {
            return this.handlerInfo.isContinueHandler();
        }

        @Override
        public void onResponse(IHttpResponse response, AbstractHttpConnection httpConnection) {
            if (response.getStatus() == 100) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("got 100-continue response");
                }
                if (this.isContinueResponseExpected && this.handlerInfo.isContinueHandler()) {
                    if (this.is100ContinueHandled.getAndSet(true)) {
                        return;
                    }
                } else {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("ignore 100-continue (isContinueResponseExpected=" + this.isContinueResponseExpected + ", isContinueHandler=" + this.handlerInfo.isContinueHandler() + ")");
                    }
                    return;
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("call response handler " + this.responseHandlerAdapter);
            }
            this.responseHandlerAdapter.onResponse(response, httpConnection);
        }

        private void performResponseHandler(IHttpResponseHandler handler, IHttpResponse response, AbstractHttpConnection httpConnection) {
            HttpUtils.addConnectionAttribute(response.getResponseHeader(), httpConnection);
            try {
                handler.onResponse(response);
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by calling on response " + this.responseHandlerAdapter + " " + e.toString());
                }
                httpConnection.destroy(e.toString());
            }
        }

        public void onException(final IOException ioe, final AbstractHttpConnection httpConnection) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("notifing response handler");
            }
            if (this.handlerInfo.isUnsynchronized()) {
                this.performResponseHandler(ioe, httpConnection);
                return;
            }
            boolean isMultithreaded = false;
            if (ioe instanceof SocketTimeoutException) {
                if (this.handlerInfo.isSocketTimeoutHandlerMultithreaded()) {
                    isMultithreaded = true;
                }
            } else if (this.handlerInfo.isResponseExeptionHandlerMultithreaded()) {
                isMultithreaded = true;
            }
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    ResponseHandlerAdapter.this.performResponseHandler(ioe, httpConnection);
                }
            };
            if (isMultithreaded) {
                httpConnection.getExecutor().processMultithreaded(task);
            } else {
                httpConnection.getExecutor().processNonthreaded(task);
            }
        }

        private void performResponseHandler(IOException ioe, AbstractHttpConnection httpConnection) {
            try {
                if (ioe instanceof SocketTimeoutException && this.handlerInfo.isSocketTimeoutHandler()) {
                    ((IHttpSocketTimeoutHandler)((Object)this.exceptionHandler)).onException((SocketTimeoutException)ioe);
                } else {
                    this.exceptionHandler.onException(ioe);
                }
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by calling on exception " + this.responseHandlerAdapter + " " + e.toString());
                }
                httpConnection.destroy(e.toString());
            }
        }

        private final class MultithreadedResponseHandlerAdapter
        implements IResponseHandlerAdapter {
            private final IHttpResponseHandler delegate;

            public MultithreadedResponseHandlerAdapter(IHttpResponseHandler delegate) {
                this.delegate = delegate;
            }

            @Override
            public void onResponse(final IHttpResponse response, final AbstractHttpConnection httpConnection) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        ResponseHandlerAdapter.this.performResponseHandler(MultithreadedResponseHandlerAdapter.this.delegate, response, httpConnection);
                    }
                };
                httpConnection.getExecutor().processMultithreaded(task);
            }

            public String toString() {
                return String.valueOf(this.getClass().getName()) + "*" + this.delegate;
            }
        }

        private final class NonthreadedResponseHandlerAdapter
        implements IResponseHandlerAdapter {
            private final IHttpResponseHandler delegate;

            public NonthreadedResponseHandlerAdapter(IHttpResponseHandler delegate) {
                this.delegate = delegate;
            }

            @Override
            public void onResponse(final IHttpResponse response, final AbstractHttpConnection httpConnection) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        ResponseHandlerAdapter.this.performResponseHandler(NonthreadedResponseHandlerAdapter.this.delegate, response, httpConnection);
                    }
                };
                httpConnection.getExecutor().processNonthreaded(task);
            }

            public String toString() {
                return String.valueOf(this.getClass().getName()) + "*" + this.delegate;
            }
        }

        private final class UnsynchronizedResponseHandlerAdapter
        implements IResponseHandlerAdapter {
            private final IHttpResponseHandler delegate;

            public UnsynchronizedResponseHandlerAdapter(IHttpResponseHandler delegate) {
                this.delegate = delegate;
            }

            @Override
            public void onResponse(IHttpResponse response, AbstractHttpConnection httpConnection) {
                ResponseHandlerAdapter.this.performResponseHandler(this.delegate, response, httpConnection);
            }

            public String toString() {
                return String.valueOf(this.getClass().getName()) + "*" + this.delegate;
            }
        }
    }
}

