/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkBodyDataSource;
import org.xlightweb.AbstractParser;
import org.xlightweb.BadMessageException;
import org.xlightweb.HttpUtils;
import org.xlightweb.ProtocolException;
import org.xsocket.DataConverter;

abstract class AbstractHttpProtocolHandler
extends AbstractParser {
    private static final Logger LOG = Logger.getLogger(AbstractHttpProtocolHandler.class.getName());
    static final int BODY_TYPE_EMTPY = 0;
    static final int BODY_TYPE_FULL_MESSAGE = 1;
    static final int BODY_TYPE_CHUNKED = 2;
    static final int BODY_TYPE_SIMPLE = 3;
    static final int BODY_TYPE_MULTIPART_BYTERANGE = 4;
    static final int BODY_TYPE_WEBSOCKET = 5;
    static final int RECEIVING_HEADER = 5;
    static final int RECEIVING_BODY = 10;
    private int state = 5;
    private AbstractNetworkBodyDataSource dataSource = null;
    private AbstractHttpConnection.IMessageHandler messageHandler = null;
    int received = 0;

    AbstractHttpProtocolHandler() {
    }

    final void incReveived(int addSize) {
        this.received += addSize;
    }

    final int getReceived() {
        return this.received;
    }

    final void setState(int state) {
        this.state = state;
    }

    final int getState() {
        return this.state;
    }

    final void setBodyDataSource(AbstractNetworkBodyDataSource dataSource) {
        this.dataSource = dataSource;
    }

    final AbstractNetworkBodyDataSource getBodyDataSource() {
        return this.dataSource;
    }

    final void setMessageHandler(AbstractHttpConnection.IMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    final AbstractHttpConnection.IMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public final ByteBuffer[] onData(AbstractHttpConnection httpConnection, ByteBuffer[] rawData) throws BadMessageException, IOException {
        try {
            switch (this.state) {
                case 5: {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("parsing header");
                    }
                    return this.parseHeader(httpConnection, rawData);
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("parsing body (" + this.getClass().getName() + "#" + this.hashCode() + ")");
            }
            if ((rawData = this.parserBody(httpConnection, rawData)) != null) {
                return this.onData(httpConnection, rawData);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        catch (Exception e) {
            IOException ioe = null;
            ioe = e instanceof IOException ? (IOException)e : HttpUtils.toIOException(e);
            if (this.messageHandler != null) {
                this.messageHandler.onBodyException(ioe, rawData);
            }
            throw ioe;
        }
        return HttpUtils.compact(rawData);
    }

    final ByteBuffer[] parserBody(AbstractHttpConnection httpConnection, ByteBuffer[] rawData) throws IOException {
        this.dataSource.parse(rawData);
        if (this.dataSource.isComplete()) {
            AbstractHttpConnection.IMessageHandler mh = this.messageHandler;
            this.reset();
            if (mh != null) {
                mh.onMessageReceived();
            }
        }
        if ((rawData = HttpUtils.compact(rawData)) != null) {
            return this.onData(httpConnection, rawData);
        }
        return rawData;
    }

    void reset() {
        this.setState(5);
        this.messageHandler = null;
        this.dataSource = null;
    }

    abstract ByteBuffer[] parseHeader(AbstractHttpConnection var1, ByteBuffer[] var2) throws BadMessageException, IOException;

    final void onDisconnect(AbstractHttpConnection httpConnection, ByteBuffer[] rawData) {
        block16: {
            if (this.getState() == 5) {
                if (!httpConnection.isClosing() && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + httpConnection.getId() + "] connection disconnected while receving header");
                }
                if (!HttpUtils.isEmpty(rawData)) {
                    try {
                        this.onDisconnectInHeader(httpConnection, rawData);
                    }
                    catch (IOException ioe) {
                        AbstractHttpConnection.IMessageHeaderHandler messageHeaderHandler;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + httpConnection.getId() + "] Error occured by calling on disconnect while receiving header " + ioe.toString());
                        }
                        if ((messageHeaderHandler = httpConnection.getMessageHeaderHandler()) != null) {
                            messageHeaderHandler.onHeaderException(ioe, rawData);
                        }
                    }
                } else if (!httpConnection.isClosing()) {
                    this.onDisconnectInHeaderNothingReceived(httpConnection, rawData);
                }
            } else {
                AbstractNetworkBodyDataSource ds = this.getBodyDataSource();
                if (ds != null) {
                    try {
                        ds.append((ByteBuffer)null);
                    }
                    catch (IOException ioe) {
                        ds.setException(ioe);
                    }
                    try {
                        ds.onDisconnect();
                    }
                    catch (IOException ioe) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + httpConnection.getId() + "] Error occured by calling on disconnect while receiving header  " + ioe.toString());
                        }
                        if (this.messageHandler == null) break block16;
                        this.messageHandler.onBodyException(ioe, rawData);
                    }
                }
            }
        }
    }

    void onDisconnectInHeader(AbstractHttpConnection httpConnection, ByteBuffer[] rawData) throws IOException {
        ByteBuffer[] received = HttpUtils.copy(rawData);
        throw new ProtocolException("connection " + httpConnection.getId() + " has been disconnected while receiving header. Already received: " + DataConverter.toString(received, "ISO-8859-1"), null);
    }

    void onDisconnectInHeaderNothingReceived(AbstractHttpConnection httpConnection, ByteBuffer[] rawData) {
        AbstractHttpConnection.IMessageHeaderHandler messageHeaderHandler;
        String detailedReason = httpConnection.isOpen() ? (httpConnection.getCountMessagesSent() > 0 ? String.valueOf(httpConnection.getCountMessagesSent()) + " messages sent, " + httpConnection.getCountMessagesReceived() + " messages recieved (closed by peer?)" : "no messages sent (closed by peer?)") : (httpConnection.isClosing() ? "connection is closing " + httpConnection.getCountMessagesSent() + " messages sent, " + httpConnection.getCountMessagesReceived() + " messages recieve" : "closeReason=" + httpConnection.getCloseReason() + ")");
        ProtocolException pe = new ProtocolException("connection " + httpConnection.getId() + " has been disconnected while receiving header. no data received. " + detailedReason, null);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + httpConnection.getId() + "] error occured " + pe.toString());
        }
        if ((messageHeaderHandler = httpConnection.getMessageHeaderHandler()) != null) {
            messageHeaderHandler.onHeaderException(pe, rawData);
        }
    }

    public final void onException(AbstractHttpConnection httpConnection, IOException ioe, ByteBuffer[] rawData) {
        switch (this.getState()) {
            case 5: {
                if (!LOG.isLoggable(Level.FINE)) break;
                try {
                    LOG.info("error occured by receiving header. Reason: " + ioe.toString() + " received" + DataConverter.toString(HttpUtils.copy(rawData)));
                }
                catch (UnsupportedEncodingException use) {
                    LOG.info("error occured by receiving header. Reason: " + ioe.toString());
                }
                break;
            }
            default: {
                if (this.dataSource == null) break;
                this.dataSource.onException(ioe, rawData);
            }
        }
    }
}

