/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyDestroyListener;

abstract class AbstractListeners<T> {
    private static final Logger LOG = Logger.getLogger(AbstractListeners.class.getName());
    private final ArrayList<ListenerHolder> listenerHolders = new ArrayList();

    AbstractListeners() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(T listener, boolean callAndRemove, AbstractHttpConnection.IMultimodeExecutor executor, int executionMode) {
        ListenerHolder holder = new ListenerHolder(listener, executionMode);
        ArrayList<ListenerHolder> arrayList = this.listenerHolders;
        synchronized (arrayList) {
            this.listenerHolders.add(holder);
        }
        if (callAndRemove) {
            this.callAndRemoveListener(holder, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeListener(ListenerHolder holder) {
        ArrayList<ListenerHolder> arrayList = this.listenerHolders;
        synchronized (arrayList) {
            return this.listenerHolders.remove(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeListener(T listener) {
        ArrayList<ListenerHolder> arrayList = this.listenerHolders;
        synchronized (arrayList) {
            for (ListenerHolder holder : this.listenerHolders) {
                if (holder.getListener() != listener) continue;
                return this.removeListener(holder);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callAndRemoveListeners(AbstractHttpConnection.IMultimodeExecutor executor) {
        ArrayList listenersHolderCopy = null;
        ArrayList<ListenerHolder> arrayList = this.listenerHolders;
        synchronized (arrayList) {
            listenersHolderCopy = (ArrayList)this.listenerHolders.clone();
        }
        for (ListenerHolder holder : listenersHolderCopy) {
            this.callAndRemoveListener(holder, executor);
        }
    }

    private void callAndRemoveListener(ListenerHolder holder, AbstractHttpConnection.IMultimodeExecutor executor) {
        this.removeListener(holder);
        holder.call(executor);
    }

    abstract void onCall(T var1) throws IOException;

    static final class CloseListeners
    extends AbstractListeners<IBodyCloseListener> {
        CloseListeners() {
        }

        @Override
        void onCall(IBodyCloseListener listener) throws IOException {
            listener.onClose();
        }
    }

    static final class DestroyListeners
    extends AbstractListeners<IBodyDestroyListener> {
        DestroyListeners() {
        }

        @Override
        void onCall(IBodyDestroyListener listener) throws IOException {
            listener.onDestroyed();
        }
    }

    private final class ListenerHolder {
        private final int executionMode;
        private final T listener;
        private final AtomicBoolean isCalled = new AtomicBoolean(false);

        public ListenerHolder(T listener, int executionMode) {
            this.listener = listener;
            this.executionMode = executionMode;
        }

        T getListener() {
            return this.listener;
        }

        void call(AbstractHttpConnection.IMultimodeExecutor executor) {
            block7: {
                if (!this.isCalled.getAndSet(true)) {
                    try {
                        if (this.executionMode == HttpUtils.EXECUTIONMODE_UNSYNCHRONIZED) {
                            AbstractListeners.this.onCall(this.listener);
                        } else {
                            Runnable task = new Runnable(){

                                @Override
                                public void run() {
                                    block2: {
                                        try {
                                            AbstractListeners.this.onCall(ListenerHolder.this.listener);
                                        }
                                        catch (IOException ioe) {
                                            if (!LOG.isLoggable(Level.FINE)) break block2;
                                            LOG.fine("error occured by calling " + ListenerHolder.this.listener + " " + ioe.toString());
                                        }
                                    }
                                }
                            };
                            if (this.executionMode == 1) {
                                executor.processMultithreaded(task);
                            } else {
                                executor.processNonthreaded(task);
                            }
                        }
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block7;
                        LOG.fine("error occured by calling " + this.listener + " " + ioe.toString());
                    }
                }
            }
        }
    }
}

