/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSinkImplBase;
import org.xlightweb.HttpMessageHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpMessageHeader;
import org.xsocket.DataConverter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

abstract class AbstractNetworkBodyDataSink
extends BodyDataSinkImplBase {
    private static final Logger LOG = Logger.getLogger(AbstractNetworkBodyDataSink.class.getName());
    private final AbstractHttpConnection httpConnection;
    private CompressingOutputStream cos = null;

    public AbstractNetworkBodyDataSink(IHttpMessageHeader header, AbstractHttpConnection httpConnection) throws IOException {
        super(header, httpConnection.getExecutor());
        this.httpConnection = httpConnection;
        this.httpConnection.setNetworkBodyDataSink(this);
        httpConnection.getUnderlyingTcpConnection().setFlushmode(IConnection.FlushMode.ASYNC);
        httpConnection.getUnderlyingTcpConnection().setAutoflush(false);
    }

    void onDisconnect() {
        this.httpConnection.setNetworkBodyDataSink(null);
        if (this.isOpen()) {
            this.destroy();
        }
    }

    @Override
    final int onWriteData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
        if (this.cos == null) {
            return this.onWriteNetworkData(dataToWrite, completionHandler);
        }
        return this.cos.write(dataToWrite, completionHandler);
    }

    abstract int onWriteNetworkData(ByteBuffer[] var1, IWriteCompletionHandler var2) throws IOException;

    @Override
    protected boolean isNetworkendpoint() {
        return true;
    }

    protected final AbstractHttpConnection getHttpConnection() {
        return this.httpConnection;
    }

    @Override
    void setAutocompressThreshold(int autocompressThreshold) {
        if (this.cos == null && autocompressThreshold != Integer.MAX_VALUE) {
            if (((HttpMessageHeader)this.getHeader()).getAttribute("org.xlightweb.autouncopmressed") != null && ((Boolean)((HttpMessageHeader)this.getHeader()).getAttribute("org.xlightweb.autouncopmressed")).booleanValue()) {
                this.getHeader().removeHeader("X-XLightweb-Uncompressed");
                autocompressThreshold = 0;
            }
            this.cos = new CompressingOutputStream(autocompressThreshold);
            if (autocompressThreshold == 0) {
                this.getHeader().setHeader("Content-Encoding", "gzip");
            }
        }
    }

    final AbstractHttpConnection getConnection() {
        return this.httpConnection;
    }

    @Override
    public final String getId() {
        return this.httpConnection.getId();
    }

    @Override
    final void onClose() throws IOException {
        if (this.cos != null) {
            this.cos.close();
        }
        this.httpConnection.removeNetworkBodyDataSink(this);
        try {
            this.performClose();
            this.httpConnection.onMessageWritten();
        }
        catch (IOException ioe) {
            if (this.isIgnoreWriteError()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by closing connection. ignoring it (isIgnoreWriteError=true) " + ioe.toString());
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] error occured by closing connection. destroying it " + ioe.toString());
            }
            this.destroy();
            throw ioe;
        }
    }

    abstract void performClose() throws IOException;

    @Override
    void onDestroy(String reason) {
        block4: {
            this.httpConnection.removeNetworkBodyDataSink(this);
            if (this.isOpen()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] destroying connection");
                }
                try {
                    this.performDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine(ioe.toString());
                }
            }
        }
        this.httpConnection.destroy(reason);
    }

    abstract void performDestroy() throws IOException;

    @Override
    public int getPendingWriteDataSize() {
        return this.httpConnection.getUnderlyingTcpConnection().getPendingWriteDataSize();
    }

    @Override
    public String toString() {
        if (this.isOpen()) {
            return String.valueOf(this.getClass().getName()) + "#" + this.hashCode();
        }
        return String.valueOf(this.getClass().getName()) + "#" + this.hashCode() + " closed";
    }

    private static final class BufferOutputStream
    extends OutputStream {
        private final int bufferSize;
        private boolean isSafeUse = false;
        private byte[] buffer;
        private int pos;

        public BufferOutputStream(int bufferSize) {
            this.bufferSize = bufferSize;
            this.buffer = new byte[bufferSize];
            this.pos = 0;
        }

        public ByteBuffer drainBuffer() {
            if (this.pos > 0) {
                ByteBuffer buf = DataConverter.toByteBuffer(this.buffer, 0, this.pos);
                this.pos = 0;
                if (!this.isSafeUse) {
                    this.buffer = new byte[this.bufferSize];
                }
                return buf;
            }
            return null;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.append(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.append(b);
        }

        private void append(byte[] b) {
            this.append(b, 0, b.length);
        }

        private void append(byte[] b, int off, int len) {
            int remainingSize = this.buffer.length - this.pos;
            if (remainingSize < len) {
                this.incBuffer(len - remainingSize);
            }
            System.arraycopy(b, off, this.buffer, this.pos, len);
            this.pos += len;
        }

        private void incBuffer(int incSize) {
            byte[] newBuffer = new byte[this.buffer.length + incSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.pos);
            this.buffer = newBuffer;
        }
    }

    private static final class CompletionHandlerAdapter
    implements IWriteCompletionHandler {
        private final int size;
        private final IWriteCompletionHandler completionHandler;

        public CompletionHandlerAdapter(IWriteCompletionHandler completionHandler, int size) {
            this.completionHandler = completionHandler;
            this.size = size;
        }

        @Override
        public void onWritten(int written) throws IOException {
            block2: {
                try {
                    this.completionHandler.onWritten(this.size);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by calling onWritten on " + this.completionHandler + " " + ioe.toString());
                }
            }
        }

        @Override
        public void onException(IOException ioe) {
            this.completionHandler.onException(ioe);
        }
    }

    private final class CompressingOutputStream {
        private static final int INITIAL = 0;
        private static final int COMPRESSING = 5;
        private static final int PLAIN = 9;
        private int mode = 0;
        private int compressThresholdByte;
        private GZIPOutputStream gos = null;
        private BufferOutputStream bos = null;
        private int sizePlainData = 0;
        private int sizeNetworkData = 0;

        public CompressingOutputStream(int compressThresholdByte) {
            this.compressThresholdByte = compressThresholdByte;
        }

        public int write(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
            int length = 0;
            if (dataToWrite != null) {
                length = HttpUtils.computeRemaining(dataToWrite);
                this.sizePlainData += length;
            }
            switch (this.mode) {
                case 0: {
                    if (AbstractNetworkBodyDataSink.this.getHeader().containsHeader("Content-Encoding") && AbstractNetworkBodyDataSink.this.getHeader().getHeader("Content-Encoding").equalsIgnoreCase("gzip") || this.compressThresholdByte > 0 && HttpUtils.computeRemaining(dataToWrite) > this.compressThresholdByte) {
                        this.mode = 5;
                        AbstractNetworkBodyDataSink.this.getHeader().setHeader("Content-Encoding", "gzip");
                    } else {
                        this.mode = 9;
                    }
                    return this.write(dataToWrite, completionHandler);
                }
                case 5: {
                    if (completionHandler != null) {
                        completionHandler = new CompletionHandlerAdapter(completionHandler, length);
                    }
                    if (this.gos == null) {
                        this.bos = length > 1024 ? new BufferOutputStream(length) : new BufferOutputStream(1024);
                        this.gos = new GZIPOutputStream(this.bos);
                    }
                    byte[] plain = DataConverter.toBytes(dataToWrite);
                    this.gos.write(plain);
                    this.gos.flush();
                    ByteBuffer buffer = this.bos.drainBuffer();
                    return this.writeCompressedToNetwork(buffer, completionHandler);
                }
            }
            this.sizeNetworkData += length;
            return AbstractNetworkBodyDataSink.this.onWriteNetworkData(dataToWrite, completionHandler);
        }

        private int writeCompressedToNetwork(ByteBuffer buffer, IWriteCompletionHandler completionHandler) throws IOException {
            if (buffer == null) {
                if (completionHandler != null) {
                    completionHandler.onWritten(0);
                }
                return 0;
            }
            this.sizeNetworkData += buffer.remaining();
            if (completionHandler == null) {
                buffer = HttpUtils.copy(buffer);
            }
            return AbstractNetworkBodyDataSink.this.onWriteNetworkData(new ByteBuffer[]{buffer}, completionHandler);
        }

        public void close() throws IOException {
            if (this.mode == 5) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("closing gzip stream");
                }
                this.gos.close();
                ByteBuffer buffer = this.bos.drainBuffer();
                this.writeCompressedToNetwork(buffer, null);
            }
            if (LOG.isLoggable(Level.FINE)) {
                int ratio = 100 - this.sizeNetworkData * 100 / this.sizePlainData;
                LOG.fine(String.valueOf(this.sizeNetworkData) + " data written to network (plain size " + this.sizePlainData + ", compression=" + ratio + "%)");
            }
        }
    }
}

