/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSink;
import org.xlightweb.HttpMessageHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.ProtocolException;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnection;

abstract class AbstractNetworkBodyDataSource
extends NonBlockingBodyDataSource {
    private static final Logger LOG = Logger.getLogger(AbstractNetworkBodyDataSource.class.getName());
    static final String UNCOMPRESSED_KEY = "X-XLightweb-Uncompressed";
    static final String AUTOUNCOPMRESSED_ATTR_KEY = "org.xlightweb.autouncopmressed";
    private static final int COMPRESS_BUFFER_SIZE = 512;
    private final AbstractHttpConnection httpConnection;
    private final HttpMessageHeader header;
    private static final boolean DEFAULT_IS_AUTODETECTEDING_ENCODING = Boolean.parseBoolean(System.getProperty("org.xlightweb.autodetectedingEncoding", "true"));
    private boolean isDetectEncoding = !DEFAULT_IS_AUTODETECTEDING_ENCODING;
    private final AtomicReference<Runnable> autoEncodingCallbackRef = new AtomicReference<Object>(null);
    private byte[] encodingBuffer = null;
    private final AtomicBoolean isConnected = new AtomicBoolean(true);
    private final Object suspendGuard = new Object();
    private boolean isSuspended = false;
    private final BufferInputStream bis;
    private GZIPInputStream gis;
    private boolean dataFinished = false;

    public AbstractNetworkBodyDataSource(HttpMessageHeader header, AbstractHttpConnection httpConnection) throws IOException {
        super(header, httpConnection.getExecutor());
        this.header = header;
        this.httpConnection = httpConnection;
        this.isDetectEncoding = header.getContentType() != null && HttpUtils.isTextMimeType(header.getContentType()) && HttpUtils.parseEncoding(header.getContentType()) == null;
        if (httpConnection.isAutoUncompress() && HttpUtils.isGzipEncoded(header)) {
            this.bis = new BufferInputStream();
            this.isDetectEncoding = false;
        } else {
            this.bis = null;
            this.gis = null;
        }
    }

    final void postCreate() {
        if (this.bis != null) {
            this.header.removeHeader("Content-Length");
            this.header.removeHeader("Content-Encoding");
            this.header.setProtocolVersionSilence("1.1");
            this.header.setHeader("Transfer-Encoding", "chunked");
            this.header.addHeader(UNCOMPRESSED_KEY, "true (auto uncompress)");
            this.header.setAttribute(AUTOUNCOPMRESSED_ATTR_KEY, true);
        }
    }

    @Override
    protected boolean isNetworkendpoint() {
        return true;
    }

    @Override
    void forwardTo(BodyDataSink bodyDataSink) throws IOException {
        if (bodyDataSink.isNetworkendpoint()) {
            bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
        }
        super.forwardTo(bodyDataSink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDetectEncoding(boolean isDetectEncoding) {
        AtomicReference<Runnable> atomicReference = this.autoEncodingCallbackRef;
        synchronized (atomicReference) {
            Runnable task;
            this.isDetectEncoding = isDetectEncoding;
            if (!isDetectEncoding && (task = (Runnable)this.autoEncodingCallbackRef.getAndSet(null)) != null) {
                task.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerAutoEncondingDetectCallback(Runnable task) {
        AtomicReference<Runnable> atomicReference = this.autoEncodingCallbackRef;
        synchronized (atomicReference) {
            if (!this.isDetectEncoding) {
                task.run();
            } else {
                this.autoEncodingCallbackRef.set(task);
            }
        }
    }

    protected final AbstractHttpConnection getHttpConnection() {
        return this.httpConnection;
    }

    @Override
    protected final String getId() {
        return this.httpConnection.getId();
    }

    protected final void setNonPersistent() {
        this.httpConnection.setPersistent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final boolean suspend() throws IOException {
        Object object = this.suspendGuard;
        synchronized (object) {
            block4: {
                if (!this.isSuspended) break block4;
                return false;
            }
            this.isSuspended = true;
            Runnable suspendTask = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = AbstractNetworkBodyDataSource.this.suspendGuard;
                    synchronized (object) {
                        block6: {
                            if (AbstractNetworkBodyDataSource.this.isSuspended) {
                                try {
                                    AbstractNetworkBodyDataSource.this.httpConnection.suspendReceiving();
                                }
                                catch (IOException ioe) {
                                    if (!LOG.isLoggable(Level.FINE)) break block6;
                                    LOG.fine("[" + AbstractNetworkBodyDataSource.this.getId() + "] error occured by calling suspendReceiving " + ioe);
                                }
                            }
                        }
                    }
                }
            };
            this.httpConnection.getExecutor().processNonthreaded(suspendTask);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean resume() throws IOException {
        Object object = this.suspendGuard;
        synchronized (object) {
            block4: {
                if (!this.isSuspended) break block4;
                this.isSuspended = false;
                Runnable resumeTask = new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("[" + AbstractNetworkBodyDataSource.this.getId() + "] resume receiving data");
                            }
                            try {
                                AbstractNetworkBodyDataSource.this.httpConnection.resumeReceiving();
                            }
                            catch (IOException ioe) {
                                if (!LOG.isLoggable(Level.FINE)) break block3;
                                LOG.fine("[" + AbstractNetworkBodyDataSource.this.getId() + "] error occured by calling suspendReceiving " + ioe);
                            }
                        }
                        AbstractNetworkBodyDataSource.this.callBodyDataHandler(true);
                    }
                };
                this.httpConnection.getExecutor().processNonthreaded(resumeTask);
                return true;
            }
            return false;
        }
    }

    final void onDisconnect() throws IOException {
        this.setDetectEncoding(false);
        if (this.isConnected.getAndSet(false)) {
            try {
                this.performOnDisconnect();
            }
            catch (ProtocolException pe) {
                this.setException(pe);
                throw pe;
            }
        }
    }

    final long getLastTimeDataReceivedMillis() {
        return this.httpConnection.getLastTimeDataReceivedMillis();
    }

    abstract void performOnDisconnect() throws IOException;

    @Override
    void onDestroy(String reason) {
        this.setDetectEncoding(false);
        this.httpConnection.destroy(reason);
    }

    @Override
    final void setComplete() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] completed reveived");
        }
        this.dataFinished = true;
        this.onReadNetworkData((ByteBuffer)null);
        this.setDetectEncoding(false);
        super.setComplete();
        this.httpConnection.onMessageCompleteReceived(this.header);
    }

    final int readByteBufferByLength(ByteBuffer[] buffers, int length) throws IOException {
        if (buffers == null) {
            return 0;
        }
        if (this.isDetectEncoding) {
            byte[] data = DataConverter.toBytes(HttpUtils.copy(buffers));
            if (this.encodingBuffer != null) {
                byte[] newData = new byte[this.encodingBuffer.length + data.length];
                System.arraycopy(this.encodingBuffer, 0, newData, 0, this.encodingBuffer.length);
                System.arraycopy(data, 0, newData, this.encodingBuffer.length, data.length);
                data = newData;
            }
            try {
                String encoding = HttpUtils.detectEncoding(data);
                if (encoding != null) {
                    this.setEncoding(encoding);
                    this.header.setCharacterEncoding(encoding);
                }
                this.encodingBuffer = null;
                this.setDetectEncoding(false);
            }
            catch (BufferUnderflowException bue) {
                this.encodingBuffer = data;
            }
        }
        int remaining = length;
        int i = 0;
        while (i < buffers.length) {
            int available;
            ByteBuffer buffer = buffers[i];
            if (buffer != null && (available = buffer.remaining()) != 0) {
                if (available < remaining) {
                    this.onReadNetworkData(buffer);
                    buffers[i] = null;
                    remaining -= available;
                } else {
                    if (available == remaining) {
                        this.onReadNetworkData(buffer);
                        buffers[i] = null;
                        return 0;
                    }
                    int limit = buffer.limit();
                    buffer.limit(buffer.position() + remaining);
                    ByteBuffer buf = buffer.slice();
                    this.onReadNetworkData(buf);
                    buffer.position(buffer.limit());
                    buffer.limit(limit);
                    return 0;
                }
            }
            ++i;
        }
        return remaining;
    }

    /*
     * Unable to fully structure code
     */
    protected final void onReadNetworkData(ByteBuffer buffer) throws IOException {
        block5: {
            block4: {
                if (this.bis != null) break block4;
                this.append(buffer);
                break block5;
            }
            this.bis.addBuffer(buffer);
            if (this.gis != null) ** GOTO lbl23
            this.bis.mark();
            try {
                this.gis = new GZIPInputStream((InputStream)this.bis, 512);
                if (true) ** GOTO lbl23
            }
            catch (BufferUnderflowException bue) {
                this.bis.reset();
                return;
            }
            do {
                if ((read = this.gis.read(data = new byte[512])) > 0) {
                    buf = DataConverter.toByteBuffer(data, 0, read);
                    this.append(buf);
                    continue;
                }
                if (read != -1) continue;
                return;
lbl23:
                // 4 sources

            } while (this.bis.available() > 1024 || this.dataFinished);
        }
    }

    protected final void onReadNetworkData(ByteBuffer[] buffers) throws IOException {
        if (this.bis == null) {
            this.append(buffers);
        } else {
            ByteBuffer[] byteBufferArray = buffers;
            int n = buffers.length;
            int n2 = 0;
            while (n2 < n) {
                ByteBuffer buffer = byteBufferArray[n2];
                this.onReadNetworkData(buffer);
                ++n2;
            }
        }
    }

    final void parse(ByteBuffer[] rawData) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (!this.isComplete()) {
            try {
                this.doParse(rawData);
            }
            catch (BufferUnderflowException bue) {
                throw bue;
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.httpConnection.getId() + "] (protocol?) error occured by reading body " + ioe.toString());
                }
                if (!this.isComplete()) {
                    this.setException(ioe);
                }
                throw ioe;
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("do not parse, because body is already complete");
        }
    }

    abstract void doParse(ByteBuffer[] var1) throws IOException;

    void onException(IOException ioe, ByteBuffer[] rawData) {
        this.setException(ioe);
    }

    private final class BufferInputStream
    extends InputStream {
        private ByteBuffer buffer;
        private int markedPos;
        private int markedLimit;

        private BufferInputStream() {
        }

        public void addBuffer(ByteBuffer buf) {
            this.buffer = HttpUtils.merge(this.buffer, buf);
        }

        public void mark() {
            this.mark(Integer.MAX_VALUE);
        }

        @Override
        public void mark(int readlimit) {
            this.markedPos = this.buffer.position();
            this.markedLimit = this.buffer.limit();
        }

        @Override
        public void reset() throws IOException {
            this.buffer.position(this.markedPos);
            this.buffer.limit(this.markedLimit);
        }

        @Override
        public int available() throws IOException {
            return this.buffer.remaining();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int remaining = this.buffer.remaining();
            if (remaining == 0) {
                throw new BufferUnderflowException();
            }
            if (len > remaining) {
                len = remaining;
            }
            this.buffer.get(b, off, len);
            if (!AbstractNetworkBodyDataSource.this.dataFinished && AbstractNetworkBodyDataSource.this.gis != null && this.buffer.remaining() < 512) {
                throw new IOException("Buffer underflow (remaining " + this.buffer.remaining() + ")");
            }
            return remaining - this.buffer.remaining();
        }

        @Override
        public int read() throws IOException {
            return this.buffer.get() & 0xFF;
        }

        public String toString() {
            return DataConverter.toHexString(HttpUtils.copy(this.buffer));
        }
    }
}

