/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.xlightweb.IHeader;

abstract class AbstractParser {
    AbstractParser() {
    }

    static void skipPositions(int length, ByteBuffer[] rawBuffer) {
        ByteBuffer[] byteBufferArray = rawBuffer;
        int n = rawBuffer.length;
        int n2 = 0;
        while (n2 < n) {
            ByteBuffer buf = byteBufferArray[n2];
            int remaining = buf.remaining();
            if (remaining < length) {
                buf.position(buf.limit());
                length -= remaining;
            } else {
                buf.position(buf.position() + length);
                break;
            }
            ++n2;
        }
    }

    static String extractString(int posStart, int length, ByteBuffer buffer) {
        byte[] data = new byte[length];
        buffer.position(posStart);
        buffer.get(data);
        try {
            return new String(data, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException usee) {
            throw new RuntimeException(usee);
        }
    }

    static int extractInt(int posStart, int length, ByteBuffer buffer) {
        String s = AbstractParser.extractString(posStart, length, buffer);
        return Integer.parseInt(s);
    }

    static String extractStringWithoutTailingCR(int posStart, int length, ByteBuffer buffer) {
        buffer.position(posStart + length - 1);
        if (buffer.get() == 13 && --length == -1) {
            return "";
        }
        byte[] data = new byte[length];
        buffer.position(posStart);
        buffer.get(data);
        try {
            return new String(data, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException usee) {
            throw new RuntimeException(usee);
        }
    }

    static String consumeStringWithoutTailingCR(int offset, int length, ByteBuffer buffer) {
        int size = length;
        buffer.position(offset + length - 1);
        if (buffer.get() == 13 && --size == -1) {
            return "";
        }
        byte[] data = new byte[size];
        buffer.position(offset);
        buffer.get(data);
        buffer.position(offset + length);
        try {
            return new String(data, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException usee) {
            throw new RuntimeException(usee);
        }
    }

    static void removeTailingCRLF(ByteBuffer buffer) {
        int pos = buffer.position();
        if (buffer.get(buffer.limit() - 1) == 10) {
            if (buffer.get(buffer.limit() - 2) == 13) {
                buffer.limit(buffer.limit() - 2);
            } else {
                buffer.limit(buffer.limit() - 1);
            }
        }
        buffer.position(pos);
    }

    static void parseHeaderLines(ByteBuffer buffer, IHeader header) throws BufferUnderflowException {
        String name = null;
        String value = null;
        int posLF = buffer.position();
        while (true) {
            byte firstCharOfLine;
            if ((firstCharOfLine = buffer.get()) < 33) {
                if (firstCharOfLine == 13) {
                    byte secondCharOfLine = buffer.get();
                    if (secondCharOfLine == 10) {
                        if (name != null) {
                            header.addHeader(name, value);
                        }
                        return;
                    }
                } else {
                    if (firstCharOfLine == 10) {
                        if (name != null) {
                            header.addHeader(name, value);
                        }
                        return;
                    }
                    if (firstCharOfLine == 32 || firstCharOfLine == 9) {
                        byte c;
                        int pos = 0;
                        while ((c = buffer.get()) == 32 || c == 9) {
                        }
                        pos = buffer.position();
                        while (buffer.get() != 10) {
                        }
                        posLF = buffer.position();
                        String v2 = AbstractParser.extractStringWithoutTailingCR(pos - 1, posLF - pos, buffer);
                        value = value == null ? v2 : String.valueOf(value) + " " + v2;
                        value = value.trim();
                        buffer.position(posLF);
                        continue;
                    }
                }
            } else if (name != null) {
                header.addHeader(name, value);
            }
            while (buffer.get() != 58) {
            }
            int posColon = buffer.position();
            name = AbstractParser.extractString(posLF, posColon - (posLF + 1), buffer);
            buffer.position(posColon);
            while (buffer.get() != 10) {
            }
            posLF = buffer.position();
            value = AbstractParser.extractStringWithoutTailingCR(posColon, posLF - (posColon + 1), buffer);
            value = value.trim();
            buffer.position(posLF);
        }
    }
}

