/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.logging.Logger;
import org.xlightweb.HttpUtils;

public final class BadMessageException
extends IOException {
    private static final Logger LOG = Logger.getLogger(BadMessageException.class.getName());
    private static final long serialVersionUID = -8030258963989509537L;
    private final int statusCode;

    public BadMessageException(String reason) {
        this(400, reason);
    }

    public BadMessageException(int statusCode) {
        this(statusCode, HttpUtils.getReason(statusCode));
    }

    public BadMessageException(int statusCode, String reason) {
        super(reason);
        this.statusCode = statusCode;
        if (statusCode < 400) {
            LOG.warning("status code should be 4xx");
        }
    }

    public int getStatus() {
        return this.statusCode;
    }
}

