/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BadMessageException;
import org.xlightweb.BodyDataSink;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHeader;
import org.xlightweb.IPart;
import org.xlightweb.IPartHandler;
import org.xlightweb.IUnsynchronized;
import org.xlightweb.NoMultipartTypeException;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.ProtocolException;
import org.xlightweb.ReceiveTimeoutException;
import org.xsocket.DataConverter;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;

public class BodyDataSource
implements IDataSource,
ReadableByteChannel,
Closeable {
    private static final Logger LOG = Logger.getLogger(BodyDataSource.class.getName());
    public static final int DEFAULT_RECEIVE_TIMEOUT = Integer.MAX_VALUE;
    private final Listener handler = new Listener();
    private final Object readGuard = new Object();
    private final AtomicInteger notifyRevision = new AtomicInteger();
    private final AtomicBoolean isComplete = new AtomicBoolean(false);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final NonBlockingBodyDataSource delegate;
    private int receiveTimeoutSec = Integer.MAX_VALUE;
    private PartHandler partHandler = null;

    BodyDataSource(NonBlockingBodyDataSource delegate) throws IOException {
        this.delegate = delegate;
        this.setReceiveTimeoutSec(HttpUtils.convertMillisToSec(delegate.getBodyDataReceiveTimeoutMillisSilence()));
        delegate.setDataHandler(this.handler);
        delegate.addCompleteListener(this.handler);
        delegate.addDestroyListener(this.handler);
    }

    IHeader getHeader() {
        return this.delegate.getHeader();
    }

    String getEncoding() {
        return this.delegate.getEncoding();
    }

    NonBlockingBodyDataSource getUnderliyingBodyDataSource() {
        return this.delegate;
    }

    public void setReceiveTimeoutSec(int timeout) {
        this.receiveTimeoutSec = timeout;
    }

    public int getReceiveTimeoutSec() {
        return this.receiveTimeoutSec;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public final boolean isMultipart() {
        return this.delegate.isMultipart();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public int size() throws IOException {
        return (Integer)new SizeReadTask().read();
    }

    public void markReadPosition() {
        this.delegate.markReadPosition();
    }

    public boolean resetToReadMark() {
        return this.delegate.resetToReadMark();
    }

    public void removeReadMark() {
        this.delegate.removeReadMark();
    }

    public IPart readPart() throws NoMultipartTypeException, IOException {
        this.initPartReader();
        return (IPart)new PartReadTask().read();
    }

    public List<IPart> readParts() throws NoMultipartTypeException, IOException {
        ArrayList<IPart> parts = new ArrayList<IPart>();
        try {
            while (true) {
                parts.add(this.readPart());
            }
        }
        catch (ClosedChannelException cce) {
            return parts;
        }
    }

    private synchronized void initPartReader() throws IOException {
        if (this.partHandler == null) {
            this.partHandler = new PartHandler();
            this.delegate.setBodyPartHandler(this.partHandler);
        }
    }

    public ByteBuffer[] readByteBuffer() throws IOException {
        return (ByteBuffer[])new ByteBuffersReadTask().read();
    }

    public byte[] readBytes() throws IOException {
        return (byte[])new BytesReadTask().read();
    }

    public String readString() throws IOException {
        return this.readString(this.delegate.getEncoding());
    }

    public String readString(String encoding) throws IOException {
        return (String)new StringReadTask(encoding).read();
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        int size = buffer.remaining();
        if (size < 1) {
            return 0;
        }
        return (Integer)new ByteBufferReadTask(buffer).read();
    }

    @Override
    public byte readByte() throws IOException, BufferUnderflowException, SocketTimeoutException {
        return (Byte)new ByteReadTask().read();
    }

    @Override
    public short readShort() throws IOException, BufferUnderflowException, SocketTimeoutException {
        return (Short)new ShortReadTask().read();
    }

    @Override
    public int readInt() throws IOException, BufferUnderflowException, SocketTimeoutException {
        return (Integer)new IntegerReadTask().read();
    }

    @Override
    public long readLong() throws IOException, BufferUnderflowException, SocketTimeoutException {
        return (Long)new LongReadTask().read();
    }

    @Override
    public double readDouble() throws IOException, BufferUnderflowException, SocketTimeoutException {
        return (Double)new DoubleReadTask().read();
    }

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, SocketTimeoutException {
        return (ByteBuffer[])new ByteBufferByDelimiterReadTask(delimiter, maxLength).read();
    }

    @Override
    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException, SocketTimeoutException {
        if (length <= 0) {
            return new ByteBuffer[0];
        }
        return (ByteBuffer[])new ByteBufferByLengthReadTask(length).read();
    }

    @Override
    public byte[] readBytesByDelimiter(String delimiter) throws IOException, BufferUnderflowException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, maxLength));
    }

    @Override
    public byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    @Override
    public String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, this.delegate.getEncoding());
    }

    public String readStringByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, SocketTimeoutException {
        this.delegate.removeLeadingBOM();
        return DataConverter.toString(this.readByteBufferByDelimiter(delimiter), encoding);
    }

    @Override
    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, maxLength, this.delegate.getEncoding());
    }

    public String readStringByDelimiter(String delimiter, int maxLength, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        this.delegate.removeLeadingBOM();
        return DataConverter.toString(this.readByteBufferByDelimiter(delimiter, maxLength), encoding);
    }

    @Override
    public String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByLength(length, this.delegate.getEncoding());
    }

    public String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, SocketTimeoutException {
        this.delegate.removeLeadingBOM();
        return DataConverter.toString(this.readByteBufferByLength(length), encoding);
    }

    @Override
    public long transferTo(WritableByteChannel target, int length) throws IOException, BufferUnderflowException, SocketTimeoutException {
        ByteBuffer[] buffers;
        long written = 0L;
        ByteBuffer[] byteBufferArray = buffers = this.readByteBufferByLength(length);
        int n = buffers.length;
        int n2 = 0;
        while (n2 < n) {
            ByteBuffer buffer = byteBufferArray[n2];
            written += (long)target.write(buffer);
            ++n2;
        }
        return written;
    }

    public long transferTo(WritableByteChannel target) throws IOException, BufferUnderflowException, SocketTimeoutException {
        long written = 0L;
        long w;
        while ((w = ((Long)new TransferToTask(target).read()).longValue()) != -1L) {
            written += w;
        }
        return written;
    }

    public long transferTo(BodyDataSink dataSink) throws ProtocolException, IOException, ClosedChannelException, BufferUnderflowException {
        return this.transferTo(dataSink, this.size());
    }

    public long transferTo(OutputStream dataSink) throws ProtocolException, IOException, ClosedChannelException, BufferUnderflowException {
        return this.transferTo(Channels.newChannel(dataSink));
    }

    public long transferTo(BodyDataSink dataSink, int length) throws ProtocolException, IOException, ClosedChannelException, BufferUnderflowException {
        long written = 0L;
        while ((written += ((Long)new TransferToByLengthTask(dataSink, (int)((long)length - written)).read()).longValue()) < (long)length) {
        }
        return written;
    }

    public String toString() {
        try {
            return (String)new ToStringReadTask().read();
        }
        catch (Exception e) {
            return "error occured by performing toString: " + e.toString();
        }
    }

    public InputStream toInputStream() {
        return Channels.newInputStream(this);
    }

    public Reader toReader() {
        return Channels.newReader((ReadableByteChannel)this, this.getEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onData() {
        if (LOG.isLoggable(Level.FINE)) {
            try {
                LOG.fine("notifying waiting threads isCompleteReceived=" + this.delegate.isCompleteReceived() + " available=" + this.delegate.size() + " moreDataExpected=" + this.delegate.isMoreInputDataExpected() + " (guard: " + this.readGuard + ")");
            }
            catch (IOException ioe) {
                LOG.fine("logging error occured " + ioe.toString());
            }
        }
        Object object = this.readGuard;
        synchronized (object) {
            this.notifyRevision.incrementAndGet();
            this.readGuard.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onComplete() {
        Object object = this.readGuard;
        synchronized (object) {
            this.notifyRevision.incrementAndGet();
            this.isComplete.set(true);
            this.readGuard.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDestroy() {
        Object object = this.readGuard;
        synchronized (object) {
            this.notifyRevision.incrementAndGet();
            this.isDestroyed.set(true);
            this.readGuard.notifyAll();
        }
    }

    private final class ByteBufferByDelimiterReadTask
    extends ReadTask<ByteBuffer[]> {
        private final String delimiter;
        private final int maxLength;

        ByteBufferByDelimiterReadTask(String delimiter, int maxLength) {
            this.delimiter = delimiter;
            this.maxLength = maxLength;
        }

        @Override
        ByteBuffer[] doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BodyDataSource.this.delegate.readByteBufferByDelimiter(this.delimiter, this.maxLength);
        }
    }

    private final class ByteBufferByLengthReadTask
    extends ReadTask<ByteBuffer[]> {
        private final int length;

        ByteBufferByLengthReadTask(int length) {
            this.length = length;
        }

        @Override
        ByteBuffer[] doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BodyDataSource.this.delegate.readByteBufferByLength(this.length);
        }
    }

    private final class ByteBufferReadTask
    extends ReadTask<Integer> {
        private final ByteBuffer buffer;

        public ByteBufferReadTask(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        Integer doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            try {
                this.available(1);
                return BodyDataSource.this.delegate.read(this.buffer);
            }
            catch (ClosedChannelException cce) {
                return -1;
            }
        }

        @Override
        Integer doNotOpen() throws ClosedChannelException {
            return -1;
        }
    }

    private final class ByteBuffersReadTask
    extends ReadTask<ByteBuffer[]> {
        private ByteBuffersReadTask() {
        }

        @Override
        ByteBuffer[] doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            this.throwBufferUnderflowExceptionIfNotComplete();
            return BodyDataSource.this.readByteBufferByLength(BodyDataSource.this.delegate.available());
        }
    }

    private final class ByteReadTask
    extends ReadTask<Byte> {
        private ByteReadTask() {
        }

        @Override
        Byte doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BodyDataSource.this.delegate.readByte();
        }
    }

    private final class BytesReadTask
    extends ReadTask<byte[]> {
        private BytesReadTask() {
        }

        @Override
        byte[] doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            this.throwBufferUnderflowExceptionIfNotComplete();
            return BodyDataSource.this.readBytesByLength(BodyDataSource.this.delegate.available());
        }
    }

    private final class DoubleReadTask
    extends ReadTask<Double> {
        private DoubleReadTask() {
        }

        @Override
        Double doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BodyDataSource.this.delegate.readDouble();
        }
    }

    private final class IntegerReadTask
    extends ReadTask<Integer> {
        private IntegerReadTask() {
        }

        @Override
        Integer doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BodyDataSource.this.delegate.readInt();
        }
    }

    private final class Listener
    implements IBodyDataHandler,
    IBodyCompleteListener,
    IBodyDestroyListener,
    IUnsynchronized {
        private Listener() {
        }

        @Override
        public boolean onData(NonBlockingBodyDataSource bodyDataSource) {
            BodyDataSource.this.onData();
            return true;
        }

        @Override
        public void onComplete() throws IOException {
            BodyDataSource.this.onComplete();
        }

        @Override
        public void onDestroyed() throws IOException {
            BodyDataSource.this.onDestroy();
        }
    }

    private final class LongReadTask
    extends ReadTask<Long> {
        private LongReadTask() {
        }

        @Override
        Long doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BodyDataSource.this.delegate.readLong();
        }
    }

    private final class PartHandler
    implements IPartHandler,
    IUnsynchronized {
        @Override
        public void onPart(NonBlockingBodyDataSource dataSource) throws IOException, BadMessageException {
            BodyDataSource.this.onData();
        }
    }

    private final class PartReadTask
    extends ReadTask<IPart> {
        private PartReadTask() {
        }

        @Override
        IPart doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BodyDataSource.this.delegate.readPart();
        }
    }

    private abstract class ReadTask<T> {
        private ReadTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final T read() throws IOException, SocketTimeoutException, MaxReadSizeExceededException, ClosedChannelException {
            long start = System.currentTimeMillis();
            long remainingTime = BodyDataSource.this.receiveTimeoutSec;
            do {
                Object object;
                int revision = BodyDataSource.this.notifyRevision.get();
                try {
                    try {
                        return this.doRead();
                    }
                    catch (RevisionAwareBufferUnderflowException nce) {
                        object = BodyDataSource.this.readGuard;
                        synchronized (object) {
                            if (nce.getRevision() != BodyDataSource.this.notifyRevision.get()) {
                                continue;
                            }
                            throw new BufferUnderflowException();
                        }
                    }
                }
                catch (BufferUnderflowException bue) {
                    object = BodyDataSource.this.readGuard;
                    synchronized (object) {
                        if (revision != BodyDataSource.this.notifyRevision.get()) {
                            continue;
                        }
                        if (BodyDataSource.this.isDestroyed.get()) {
                            return this.doNotOpen();
                        }
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("waiting for more reveived data (guard: " + BodyDataSource.this.readGuard + ")");
                        }
                        try {
                            BodyDataSource.this.readGuard.wait(remainingTime);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    remainingTime = HttpUtils.computeRemainingTime(start, BodyDataSource.this.receiveTimeoutSec);
                }
            } while (remainingTime > 0L);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("receive timeout " + BodyDataSource.this.receiveTimeoutSec + " sec reached. throwing timeout exception");
            }
            throw new ReceiveTimeoutException((long)BodyDataSource.this.receiveTimeoutSec * 1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void throwBufferUnderflowExceptionIfNotComplete() throws RevisionAwareBufferUnderflowException {
            Object object = BodyDataSource.this.readGuard;
            synchronized (object) {
                if (!BodyDataSource.this.isComplete.get()) {
                    throw new RevisionAwareBufferUnderflowException(BodyDataSource.this.notifyRevision.get());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int available(int required) throws IOException, BufferUnderflowException, ClosedChannelException {
            Object object = BodyDataSource.this.readGuard;
            synchronized (object) {
                int available = BodyDataSource.this.delegate.available();
                if (available == -1) {
                    this.throwBufferUnderflowExceptionIfNotComplete();
                    throw new ClosedChannelException();
                }
                if (available < required) {
                    throw new BufferUnderflowException();
                }
                return available;
            }
        }

        T doNotOpen() throws IOException, ClosedChannelException, ProtocolException {
            IOException ioe = BodyDataSource.this.delegate.getException();
            if (ioe == null) {
                throw new ProtocolException("connection destroyed ", null);
            }
            throw ioe;
        }

        abstract T doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException;
    }

    private static final class RevisionAwareBufferUnderflowException
    extends BufferUnderflowException {
        private static final long serialVersionUID = 3183778067682558356L;
        private final int revision;

        public RevisionAwareBufferUnderflowException(int revision) {
            this.revision = revision;
        }

        public int getRevision() {
            return this.revision;
        }
    }

    private final class ShortReadTask
    extends ReadTask<Short> {
        private ShortReadTask() {
        }

        @Override
        Short doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BodyDataSource.this.delegate.readShort();
        }
    }

    private final class SizeReadTask
    extends ReadTask<Integer> {
        private SizeReadTask() {
        }

        @Override
        Integer doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            this.throwBufferUnderflowExceptionIfNotComplete();
            return BodyDataSource.this.delegate.available();
        }
    }

    private final class StringReadTask
    extends ReadTask<String> {
        private String encoding;

        public StringReadTask(String encoding) {
            this.encoding = encoding;
        }

        @Override
        String doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            this.throwBufferUnderflowExceptionIfNotComplete();
            BodyDataSource.this.delegate.removeLeadingBOM();
            return BodyDataSource.this.readStringByLength(BodyDataSource.this.delegate.available(), this.encoding);
        }
    }

    private final class ToStringReadTask
    extends ReadTask<String> {
        private ToStringReadTask() {
        }

        @Override
        String doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            this.throwBufferUnderflowExceptionIfNotComplete();
            return BodyDataSource.this.delegate.toString();
        }
    }

    private final class TransferToByLengthTask
    extends ReadTask<Long> {
        private final BodyDataSink dataSink;
        private final int length;

        public TransferToByLengthTask(BodyDataSink dataSink, int length) {
            this.dataSink = dataSink;
            this.length = length;
        }

        @Override
        Long doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            this.available(this.length);
            return BodyDataSource.this.delegate.transferTo(this.dataSink, this.length);
        }
    }

    private final class TransferToTask
    extends ReadTask<Long> {
        private final WritableByteChannel target;

        public TransferToTask(WritableByteChannel target) {
            this.target = target;
        }

        @Override
        Long doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            try {
                int available = this.available(1);
                return BodyDataSource.this.transferTo(this.target, available);
            }
            catch (ClosedChannelException cce) {
                return -1L;
            }
        }
    }
}

