/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyDataSource;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHeader;
import org.xlightweb.IUnsynchronized;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

public class BodyForwarder
implements IBodyDataHandler {
    private static final Logger LOG = Logger.getLogger(BodyForwarder.class.getName());
    private static final int DEFAULT_AUTOSUSPEND_THRESHOLD = 32768;
    private static final int AUTO_SUSPEND_THRESHOLD = BodyForwarder.readAutosuspendThreshold(32768);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final NonBlockingBodyDataSource bodyDataSource;
    private final BodyDataSink bodyDataSink;
    private final IBodyCompleteListener completeListener;
    private boolean isCompleteLisgenerCalled = false;

    public BodyForwarder(NonBlockingBodyDataSource bodyDataSource, BodyDataSink bodyDataSink) {
        this(null, bodyDataSource, bodyDataSink, null);
    }

    BodyForwarder(IHeader header, NonBlockingBodyDataSource bodyDataSource, BodyDataSink bodyDataSink, IBodyCompleteListener completeListener) {
        this.bodyDataSource = bodyDataSource;
        this.completeListener = completeListener;
        this.bodyDataSink = header != null && bodyDataSink.getFlushmode() == IConnection.FlushMode.ASYNC && bodyDataSource.isNetworkendpoint() && bodyDataSink.isNetworkendpoint() && AUTO_SUSPEND_THRESHOLD != Integer.MAX_VALUE ? new FlowControlledBodyDataSink(header, bodyDataSource, bodyDataSink) : bodyDataSink;
        bodyDataSink.addDestroyListener(new DestroyListener());
    }

    private static int readAutosuspendThreshold(int dflt) {
        int threshold = Integer.parseInt(System.getProperty("org.xlightweb.forwarding.autosuspend.thresholdbytes", Integer.toString(dflt)));
        if (threshold <= 0) {
            threshold = Integer.MAX_VALUE;
        }
        return threshold;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean onData(NonBlockingBodyDataSource bodyDataSource) throws BufferUnderflowException {
        boolean isModified = true;
        int available = 0;
        try {
            do {
                try {
                    available = bodyDataSource.availableSilence();
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + bodyDataSource.getId() + " -> " + this.bodyDataSink.getId() + "] data source error occured " + e.toString());
                    }
                    this.bodyDataSink.destroy();
                    this.onException(e);
                    return true;
                }
                if (available >= 0) {
                    isModified = this.forwardData();
                    continue;
                }
                if (this.completeListener == null || !bodyDataSource.isComplete()) continue;
                if (this.isCompleteLisgenerCalled) return true;
                this.isCompleteLisgenerCalled = true;
                this.completeListener.onComplete();
                return true;
            } while (available > 0 && isModified);
            if (available != -1) return true;
            this.handleEndOfSourceStream();
            return true;
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + bodyDataSource.getId() + " -> " + this.bodyDataSink.getId() + "] error by reading body source or forwarding (" + available + ") data to data sink " + e);
            }
            this.onException(e);
            this.destroy(e.toString());
        }
        return true;
    }

    private boolean forwardData() throws IOException {
        int version = this.bodyDataSource.getReadBufferVersionSilence();
        this.onData(this.bodyDataSource, this.bodyDataSink);
        return version != this.bodyDataSource.getReadBufferVersionSilence();
    }

    public void onData(NonBlockingBodyDataSource bodyDataSource, BodyDataSink bodyDataSink) throws BufferUnderflowException, IOException {
        int available = bodyDataSource.availableSilence();
        if (available >= 0) {
            ByteBuffer[] data;
            if (available == 0) {
                data = new ByteBuffer[]{};
            } else {
                data = bodyDataSource.readByteBufferByLengthSilence(available);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + bodyDataSource.getId() + " -> " + bodyDataSink.getId() + "] forwarding " + DataConverter.toString(HttpUtils.copy(data)));
                }
            }
            bodyDataSink.write(data);
        }
    }

    public void onException(Exception e) {
    }

    private void handleEndOfSourceStream() {
        if (!this.isClosed.getAndSet(true)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.bodyDataSource.getId() + " -> " + this.bodyDataSink.getId() + "] end of stream reached. dettach data source and closing data sink");
            }
            this.bodyDataSource.setDataHandler(null);
            this.onComplete();
            try {
                this.bodyDataSink.close();
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.bodyDataSource.getId() + " -> " + this.bodyDataSink.getId() + "] error occured by closing body data sink " + e.toString());
                }
                this.destroy(e.toString());
            }
        }
    }

    public void onComplete() {
    }

    private void destroy(String reason) {
        this.bodyDataSink.destroy();
        this.bodyDataSource.destroy(reason);
    }

    private final class DestroyListener
    implements IBodyDestroyListener {
        private DestroyListener() {
        }

        @Override
        public void onDestroyed() throws IOException {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + BodyForwarder.this.bodyDataSource.getId() + " -> " + BodyForwarder.this.bodyDataSink.getId() + "] data sink has been destroyed. destroying data source");
            }
            boolean isIgnoreWriteError = BodyForwarder.this.bodyDataSink.isIgnoreWriteError();
            BodyForwarder.this.bodyDataSource.destroy("Forwarder: body data sink is closed", isIgnoreWriteError);
        }
    }

    private static final class FlowControlledBodyDataSink
    extends BodyDataSink {
        private final BodyDataSink dataSink;
        private final NonBlockingBodyDataSource dataSource;
        private final WriteCompletionHandler writeCompletionHandler;

        public FlowControlledBodyDataSink(IHeader header, NonBlockingBodyDataSource dataSource, BodyDataSink dataSink) {
            super(header);
            this.writeCompletionHandler = new WriteCompletionHandler(dataSource, dataSink);
            this.dataSource = dataSource;
            this.dataSink = dataSink;
        }

        @Override
        void addCloseListener(IBodyCloseListener closeListener) {
            this.dataSink.addCloseListener(closeListener);
        }

        @Override
        public void addDestroyListener(IBodyDestroyListener destroyListener) {
            this.dataSink.addDestroyListener(destroyListener);
        }

        @Override
        AbstractHttpConnection.IMultimodeExecutor getExecutor() {
            return this.dataSink.getExecutor();
        }

        @Override
        public void doClose() throws IOException {
            this.dataSink.close();
        }

        @Override
        public void closeQuitly() {
            this.dataSink.closeQuitly();
        }

        @Override
        public void destroy() {
            this.dataSink.destroy();
        }

        @Override
        public void flush() throws IOException {
            this.dataSink.flush();
        }

        @Override
        public Object getAttachment() {
            return this.dataSink.getAttachment();
        }

        @Override
        public String getEncoding() {
            return this.dataSink.getEncoding();
        }

        @Override
        public IConnection.FlushMode getFlushmode() {
            return this.dataSink.getFlushmode();
        }

        @Override
        public String getId() {
            return this.dataSink.getId();
        }

        @Override
        public boolean isAutoflush() {
            return this.dataSink.isAutoflush();
        }

        @Override
        public boolean isOpen() {
            return this.dataSink.isOpen();
        }

        @Override
        public void markWritePosition() {
            this.dataSink.markWritePosition();
        }

        @Override
        public void removeWriteMark() {
            this.dataSink.removeWriteMark();
        }

        @Override
        public boolean resetToWriteMark() {
            return this.dataSink.resetToWriteMark();
        }

        @Override
        public void setAttachment(Object obj) {
            this.dataSink.setAttachment(obj);
        }

        @Override
        public void setAutoflush(boolean autoflush) {
            this.dataSink.setAutoflush(autoflush);
        }

        @Override
        public void setEncoding(String defaultEncoding) {
            this.dataSink.setEncoding(defaultEncoding);
        }

        @Override
        public void setFlushmode(IConnection.FlushMode flushMode) {
            this.dataSink.setFlushmode(flushMode);
        }

        @Override
        public void setSendTimeoutMillis(long sendTimeoutMillis) {
            this.dataSink.setSendTimeoutMillis(sendTimeoutMillis);
        }

        @Override
        boolean isNetworkendpoint() {
            return false;
        }

        @Override
        boolean isIgnoreWriteError() {
            return this.dataSink.isIgnoreWriteError();
        }

        @Override
        int getPendingWriteDataSize() {
            return this.dataSink.getPendingWriteDataSize();
        }

        @Override
        int getSizeWritten() {
            return this.dataSink.getSizeWritten();
        }

        @Override
        public long transferFrom(BodyDataSource source) throws IOException {
            return this.dataSink.transferFrom(source);
        }

        @Override
        public long transferFrom(BodyDataSource source, int length) throws IOException {
            return this.dataSink.transferFrom(source, length);
        }

        @Override
        public long transferFrom(FileChannel fileChannel) throws IOException, BufferOverflowException {
            return this.dataSink.transferFrom(fileChannel);
        }

        @Override
        public long transferFrom(NonBlockingBodyDataSource source) throws IOException {
            return this.dataSink.transferFrom(source);
        }

        @Override
        public long transferFrom(NonBlockingBodyDataSource source, int length) throws IOException {
            return this.dataSink.transferFrom(source, length);
        }

        @Override
        public long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException {
            return this.dataSink.transferFrom(source, chunkSize);
        }

        @Override
        public int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
            return this.dataSink.write(buffer);
        }

        @Override
        public long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
            boolean isSuspended;
            int size = HttpUtils.computeRemaining(buffers);
            if (size > 0 && this.dataSink.getPendingWriteDataSize() + size > AUTO_SUSPEND_THRESHOLD && (isSuspended = this.dataSource.suspend()) && LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.dataSource.getId() + " -> " + this.dataSink.getId() + "] suspended (auto suspend threshold " + AUTO_SUSPEND_THRESHOLD + " exceeded)");
            }
            this.dataSink.write(buffers, this.writeCompletionHandler);
            return size;
        }

        @Override
        public void write(ByteBuffer[] buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            this.dataSink.write(buffers, writeCompletionHandler);
        }
    }

    private static final class WriteCompletionHandler
    implements IWriteCompletionHandler,
    IUnsynchronized {
        private final NonBlockingBodyDataSource bodyDataSource;
        private final BodyDataSink bodyDataSink;

        public WriteCompletionHandler(NonBlockingBodyDataSource bodyDataSource, BodyDataSink bodyDataSink) {
            this.bodyDataSource = bodyDataSource;
            this.bodyDataSink = bodyDataSink;
        }

        @Override
        public void onWritten(int size) throws IOException {
            boolean isResumed;
            if (this.bodyDataSink.getPendingWriteDataSize() <= AUTO_SUSPEND_THRESHOLD && (isResumed = this.bodyDataSource.resume()) && LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.bodyDataSource.getId() + " -> " + this.bodyDataSink.getId() + "] resumed");
            }
        }

        @Override
        public void onException(IOException ex) {
            try {
                this.bodyDataSource.resume();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bodyDataSource.destroy();
            this.bodyDataSink.destroy();
        }
    }
}

