/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.IWebMessage;

public class Event
implements IWebMessage {
    private static final Logger LOG = Logger.getLogger(Event.class.getName());
    private static final char COLON = ':';
    private static final char SPACE = ' ';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private String eventname;
    private String id;
    private Integer retry;
    private final List<String> dataList = new ArrayList<String>();
    private final List<String> commentList = new ArrayList<String>();

    public Event() {
    }

    public Event(String data) {
        this.addData(data);
    }

    public Event(String data, long id) {
        this(data, Long.toString(id));
    }

    public Event(String data, String id) {
        this.addData(data);
        this.setId(id);
    }

    public Event(String data, long id, String eventname) {
        this(data, Long.toString(id), eventname);
    }

    public Event(String data, String id, String eventname) {
        this.addData(data);
        this.setId(id);
        this.setEventname(eventname);
    }

    public boolean isCommentMessage() {
        return this.getData() == null && this.getEventname() == null;
    }

    public String getEventname() {
        return this.eventname;
    }

    public void setEventname(String eventname) {
        this.eventname = eventname;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getRetryMillis() {
        return this.retry;
    }

    public void setRetryMillis(Integer retry) {
        this.retry = retry;
    }

    public void addData(String data) {
        if (data != null) {
            this.dataList.add(data);
        }
    }

    public void setData(String data) {
        this.dataList.clear();
        if (data != null) {
            this.addData(data);
        }
    }

    public String getData() {
        if (this.dataList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String t : this.dataList) {
            sb.append(t);
        }
        return sb.toString();
    }

    public String getComment() {
        if (this.commentList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String t : this.commentList) {
            sb.append(t);
        }
        return sb.toString();
    }

    public void addComment(String comment) {
        if (comment != null) {
            this.commentList.add(comment);
        }
    }

    public void setComment(String comment) {
        this.commentList.clear();
        this.addComment(comment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.commentList) {
            sb.append(": " + s + "\r\n");
        }
        if (this.eventname != null) {
            sb.append("event: " + this.eventname + "\r\n");
        }
        if (this.id != null) {
            sb.append("id: " + this.id + "\r\n");
        }
        if (this.retry != null) {
            sb.append("retry: " + this.retry + "\r\n");
        }
        for (String s : this.dataList) {
            sb.append("data: " + s + "\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }

    public static Event parse(String event) {
        Event webEvent = new Event();
        if (event != null) {
            String field = null;
            String value = null;
            boolean colonFound = false;
            boolean isComment = false;
            boolean isScanningForSpace = false;
            int offset = 0;
            int i = 0;
            while (i < event.length()) {
                char c = event.charAt(i);
                if (c == '\r' || c == '\n' || i + 1 == event.length()) {
                    if (i + 1 == event.length()) {
                        ++i;
                    }
                    if (isComment) {
                        webEvent.commentList.add(event.substring(offset, i));
                    } else {
                        if (field == null) {
                            field = event.substring(offset, i).trim();
                        } else {
                            value = event.substring(offset, i);
                        }
                        if (field.equalsIgnoreCase("event")) {
                            if (webEvent == null) {
                                webEvent = new Event();
                            }
                            webEvent.eventname = value;
                        } else if (field.equalsIgnoreCase("id")) {
                            if (webEvent == null) {
                                webEvent = new Event();
                            }
                            webEvent.id = value;
                        } else if (field.equalsIgnoreCase("retry")) {
                            if (webEvent == null) {
                                webEvent = new Event();
                            }
                            try {
                                webEvent.retry = Integer.parseInt(value);
                            }
                            catch (NumberFormatException nfe) {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("illegal format for retry field. ignoring it");
                                }
                            }
                        } else if (field.equalsIgnoreCase("data")) {
                            if (webEvent == null) {
                                webEvent = new Event();
                            }
                            webEvent.dataList.add(value);
                        } else if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("unknown field \"" + field + "\". ignoring it");
                        }
                    }
                    if (c == '\r' && i + 1 < event.length() && event.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    if (c == '\r' && i + 2 < event.length() && event.charAt(i + 1) == '\r' && event.charAt(i + 2) == '\n') {
                        return webEvent;
                    }
                    if (c == '\r' && i + 1 < event.length() && event.charAt(i + 1) == '\r') {
                        return webEvent;
                    }
                    if (c == '\n' && i + 1 < event.length() && event.charAt(i + 1) == '\n') {
                        return webEvent;
                    }
                    offset = i + 1;
                    isComment = false;
                    isScanningForSpace = false;
                    colonFound = false;
                } else if (c == ':' && !colonFound) {
                    colonFound = true;
                    if (offset == i) {
                        isComment = true;
                    } else {
                        field = event.substring(offset, i).trim();
                    }
                    isScanningForSpace = true;
                    offset = i + 1;
                } else if (isScanningForSpace) {
                    if (c == ' ') {
                        ++offset;
                    } else {
                        isScanningForSpace = false;
                    }
                }
                ++i;
            }
        }
        return webEvent;
    }
}

