/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSinkImplBase;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHeader;
import org.xsocket.connection.IWriteCompletionHandler;

final class FileDataSink
extends BodyDataSinkImplBase {
    private static final Logger LOG = Logger.getLogger(FileDataSink.class.getName());
    private final File file;
    private final RandomAccessFile raf;
    private final FileChannel fc;

    FileDataSink(IHeader header, AbstractHttpConnection.IMultimodeExecutor executor, File file) throws IOException {
        super(header, executor);
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.fc = this.raf.getChannel();
    }

    @Override
    int onWriteData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
        int size = HttpUtils.computeRemaining(dataToWrite);
        if (size > 0) {
            try {
                this.fc.write(dataToWrite);
            }
            catch (IOException ioe) {
                if (completionHandler != null) {
                    completionHandler.onException(ioe);
                }
                throw ioe;
            }
        }
        if (completionHandler != null) {
            completionHandler.onWritten(size);
        }
        return size;
    }

    @Override
    void onClose() throws IOException {
        this.fc.close();
        this.raf.close();
    }

    @Override
    void onDestroy(String reason) {
        try {
            this.onClose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean isDeleted = this.file.delete();
        if (!isDeleted) {
            LOG.warning("connection terminated abnormally " + reason + ". Could not delete file " + this.file.getAbsolutePath() + " ");
        }
    }

    @Override
    int getPendingWriteDataSize() {
        return 0;
    }

    @Override
    boolean isNetworkendpoint() {
        return false;
    }
}

