/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BadMessageException;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xsocket.DataConverter;
import org.xsocket.Execution;

@Execution(value=1)
public class FileServiceRequestHandler
implements IHttpRequestHandler {
    private static final Logger LOG = Logger.getLogger(FileServiceRequestHandler.class.getName());
    public static final boolean SHOW_DIRECTORY_TREE_DEFAULT = false;
    private final File fileBase;
    private final boolean isShowDirectoryTree;
    private final Integer expireSec;
    private int countFound = 0;
    private int countNotFound = 0;

    public FileServiceRequestHandler(String fileBasepath) throws FileNotFoundException {
        this(fileBasepath, false);
    }

    public FileServiceRequestHandler(String fileBasepath, Integer expireSec) throws FileNotFoundException {
        this(fileBasepath, expireSec, false);
    }

    public FileServiceRequestHandler(String fileBasepath, boolean isShowDirectoryTree) throws FileNotFoundException {
        this(fileBasepath, null, isShowDirectoryTree);
    }

    public FileServiceRequestHandler(String fileBasepath, Integer expireSec, boolean isShowDirectoryTree) throws FileNotFoundException {
        this.fileBase = new File(fileBasepath);
        this.expireSec = expireSec;
        this.isShowDirectoryTree = isShowDirectoryTree;
        if (!new File(fileBasepath).exists()) {
            throw new FileNotFoundException("base path " + fileBasepath + " does not exits");
        }
    }

    boolean isShowDirectoryTree() {
        return this.isShowDirectoryTree;
    }

    String getBasepath() {
        return this.fileBase.getAbsolutePath();
    }

    int getCountFound() {
        return this.countFound;
    }

    int getCountNotFound() {
        return this.countNotFound;
    }

    @Override
    public void onRequest(IHttpExchange exchange) throws IOException, BadMessageException {
        IHttpRequest request = exchange.getRequest();
        boolean isGET = request.getMethod().equalsIgnoreCase("GET");
        boolean isHEAD = request.getMethod().equalsIgnoreCase("HEAD");
        if (isGET || isHEAD) {
            String requestURI = URLDecoder.decode(request.getRequestURI(), "utf-8");
            int ctxLength = request.getContextPath().length() + request.getRequestHandlerPath().length();
            if (requestURI.length() > ctxLength) {
                String filepath = requestURI.substring(ctxLength, requestURI.length());
                if (filepath.length() > 0) {
                    File file;
                    filepath = filepath.replaceAll("[/\\\\]+", "\\" + File.separator);
                    String path = String.valueOf(this.fileBase.getAbsolutePath()) + filepath;
                    if (path.endsWith(File.separator)) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if ((file = new File(path)).exists()) {
                        if (file.isFile()) {
                            String ifModifiedSinceRequestHeader = request.getHeader("If-Modified-Since");
                            if (ifModifiedSinceRequestHeader != null && !HttpUtils.isAfter(ifModifiedSinceRequestHeader, file.lastModified())) {
                                HttpResponse response = new HttpResponse(304);
                                this.enhanceFoundResponseHeader((HttpResponseHeader)response.getResponseHeader(), file.lastModified());
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine(String.valueOf(filepath) + " requested. returning not modified");
                                }
                                exchange.send(response);
                                return;
                            }
                            HttpResponseHeader responseHeader = new HttpResponseHeader(200);
                            this.enhanceFoundResponseHeader(responseHeader, file.lastModified());
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine(String.valueOf(filepath) + " requested. returning data");
                            }
                            String range = request.getHeader("Range");
                            HttpResponse response = new HttpResponse((IHttpResponseHeader)responseHeader, file, range);
                            if (isHEAD) {
                                response = new HttpResponse(response.getResponseHeader());
                            }
                            exchange.send(response);
                            ++this.countFound;
                            return;
                        }
                        this.handleNotFound(exchange, request, file);
                        return;
                    }
                    this.handleNotFound(exchange, request, file);
                    return;
                }
            } else {
                exchange.sendError(404, String.valueOf(request.getRequestURI()) + " not found");
                return;
            }
        }
        exchange.forward(request, (IHttpResponseHandler)new HttpResponseHandler(exchange));
    }

    private void enhanceFoundResponseHeader(HttpResponseHeader responseHeader, long lastModified) {
        responseHeader.setDate(System.currentTimeMillis());
        if (this.expireSec == null) {
            responseHeader.setLastModifiedHeader(lastModified);
        } else {
            responseHeader.setExpireHeaders(this.expireSec);
        }
    }

    private void handleNotFound(IHttpExchange exchange, IHttpRequest request, File file) throws IOException {
        ++this.countNotFound;
        if (this.isShowDirectoryTree && file.isDirectory() && this.fileBase.getAbsolutePath().length() <= file.getAbsolutePath().length()) {
            String body = this.printDirectoryTree(request, file);
            exchange.send(new HttpResponse(200, "text/html", body));
            return;
        }
        exchange.forward(request, (IHttpResponseHandler)new HttpResponseHandler(exchange));
    }

    private String printDirectoryTree(IHttpRequest request, File directory) throws IOException {
        StringBuilder sb = new StringBuilder();
        String requestResource = directory.getAbsolutePath();
        requestResource = requestResource.substring(this.fileBase.getAbsolutePath().length(), requestResource.length());
        if (request.getRequestHandlerPath().length() > 0) {
            requestResource = String.valueOf(request.getRequestHandlerPath()) + "/" + requestResource;
        }
        if (request.getContextPath().length() > 0) {
            requestResource = String.valueOf(request.getContextPath()) + "/" + requestResource;
        }
        requestResource = requestResource.replace("\\", "/");
        sb.append("<html>\r\n");
        sb.append("  <!-- This page is auto-generated by xLightweb (http://xLightweb.org) -->\r\n");
        sb.append("  <head>\r\n");
        sb.append("    <title>Index of " + requestResource + "</title>\r\n");
        sb.append("  </head>\r\n");
        sb.append("  <body>\r\n");
        sb.append("    <H1 style=\"color:#0a328c;font-size:1.5em;\">Index of " + requestResource + "</H1>\r\n");
        sb.append("    <p style=\"font-size:0.8em;\">\r\n");
        sb.append("    <table border=\"0\" style=\"color:#0a328c;font-size:1.0em;\">\r\n");
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            sb.append("      <tr>");
            sb.append("        <td align=\"right\">");
            if (file.isDirectory()) {
                sb.append("[DIR]");
            } else {
                sb.append("[TXT]");
            }
            sb.append("        </td>\r\n");
            sb.append("        <td>");
            sb.append("<a href=");
            String[] parts = requestResource.split("/");
            if (parts.length > 0) {
                sb.append(String.valueOf(URLEncoder.encode(parts[parts.length - 1], "utf-8")) + "/");
            }
            sb.append(String.valueOf(URLEncoder.encode(file.getName(), "utf-8")) + "> " + file.getName() + "</a>");
            sb.append("        </td>\r\n");
            sb.append("        <td>");
            sb.append(DataConverter.toFormatedDate(file.lastModified()));
            sb.append("        </td>\r\n");
            sb.append("        <td align=\"right\">");
            if (!file.isDirectory()) {
                sb.append(DataConverter.toFormatedBytesSize(file.length()));
            } else {
                sb.append("-");
            }
            sb.append("        </td>\r\n");
            sb.append("      </tr>");
            ++n2;
        }
        sb.append("    </table>\r\n");
        sb.append("    </p>\r\n");
        sb.append("    <p style=\"font-size:0.8em;\">" + new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(new Date()) + "    xLightweb (" + HttpUtils.getImplementationVersion() + ") at " + request.getServerName() + " Port " + request.getServerPort() + "</p>\r\n");
        sb.append("  </body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private static final class HttpResponseHandler
    implements IHttpResponseHandler {
        private IHttpExchange exchange = null;

        public HttpResponseHandler(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public void onResponse(IHttpResponse response) throws IOException {
            this.exchange.send(response);
        }

        @Override
        public void onException(IOException ioe) {
            this.exchange.sendError(500);
        }
    }
}

