/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkBodyDataSource;
import org.xlightweb.HttpMessageHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.ProtocolException;

final class FullMessageBodyDataSource
extends AbstractNetworkBodyDataSource {
    private static final Logger LOG = Logger.getLogger(FullMessageBodyDataSource.class.getName());
    private final int size;
    private int remaining;

    public FullMessageBodyDataSource(HttpMessageHeader header, int size, AbstractHttpConnection httpConnection) throws IOException {
        super(header, httpConnection);
        this.size = size;
        this.remaining = size;
        this.postCreate();
    }

    @Override
    void doParse(ByteBuffer[] rawData) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("parsing full message body (" + (this.size - this.remaining) + " of " + this.size + " read. New available=" + HttpUtils.computeRemaining(rawData) + ")");
        }
        this.remaining = this.readByteBufferByLength(rawData, this.remaining);
        if (this.remaining == 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] complete body received (size=" + this.size + ")");
            }
            this.setComplete();
            return;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("[" + this.getId() + "] body data read. wating for more data");
        }
    }

    private int received() {
        return this.size - this.remaining;
    }

    @Override
    void onClose() throws IOException {
        if (this.remaining > 0) {
            throw new ProtocolException("connection has been closed (by user?) while receiving body data. only " + this.received() + " of " + this.size + " bytes have been recevied (FullMessage)", this.getHeader());
        }
    }

    @Override
    void performOnDisconnect() throws ProtocolException {
        if (this.remaining > 0) {
            throw new ProtocolException("connection " + this.getId() + " has been closed (by peer?) while receiving body data. only " + this.received() + " of " + this.size + " bytes have been recevied. (FullMessage)", this.getHeader());
        }
    }
}

