/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.ContentType;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHeader;
import org.xlightweb.IHttpMessage;

public class Header
implements IHeader,
Cloneable {
    private static final Logger LOG = Logger.getLogger(Header.class.getName());
    static final int MAX_HEADER_SIZE = 8192;
    static final String CONTENT_TYPE = "Content-Type";
    static final String CONTENT_DISPOSITION = "Content-Disposition";
    static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final int MAX_HEADER_LINE_LENGTH = 250;
    private static final int MIN_HEADER_LINE_LENGTH_THRESHOLD = 15;
    private ArrayList<HeaderEntry> headers = new ArrayList();
    private String defaultEncoding = IHttpMessage.DEFAULT_ENCODING;
    private String characterEncoding = null;
    private String contentType;
    private String contentDisposition;
    private String contentDispositionType;
    private Map<String, String> contentDispositionParams;
    private String transferEncoding;

    public Header() {
    }

    public Header(String contentType) {
        this.setContentType(contentType);
    }

    void setBodyDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public final void addHeaderLine(String line) {
        String[] kvp = line.split(":");
        this.addHeader(kvp[0], kvp[1].trim());
    }

    @Override
    public final void addHeaderlines(String ... lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String headerline = stringArray[n2];
            this.addHeaderLine(headerline);
            ++n2;
        }
    }

    @Override
    public final void setHeader(String headername, String headervalue) {
        this.removeHeader(headername);
        this.addHeader(headername, headervalue);
    }

    @Override
    public final void addHeader(String headername, String headervalue) {
        boolean isHandled = this.onHeaderAdded(headername, headervalue);
        if (!isHandled) {
            HeaderEntry entry = new HeaderEntry(headername, headervalue);
            this.headers.add(entry);
        }
    }

    boolean onHeaderAdded(String headername, String headervalue) {
        if (headername.equalsIgnoreCase(CONTENT_TYPE)) {
            this.contentType = headervalue;
            return true;
        }
        if (headername.equalsIgnoreCase(TRANSFER_ENCODING)) {
            this.transferEncoding = headervalue;
            return true;
        }
        return false;
    }

    @Override
    public final void removeHeader(String headername) {
        boolean isHandled = this.onHeaderRemoved(headername);
        if (!isHandled) {
            ArrayList<HeaderEntry> removeList = new ArrayList<HeaderEntry>();
            for (HeaderEntry headerEntry : this.headers) {
                if (!headerEntry.isNameEquals(headername)) continue;
                removeList.add(headerEntry);
            }
            this.headers.removeAll(removeList);
        }
    }

    boolean onHeaderRemoved(String headername) {
        if (headername.equalsIgnoreCase(CONTENT_TYPE)) {
            this.contentType = null;
            return true;
        }
        if (headername.equalsIgnoreCase(CONTENT_DISPOSITION)) {
            this.contentDisposition = null;
            this.contentDispositionType = null;
            this.contentDispositionParams = null;
            return true;
        }
        if (headername.equalsIgnoreCase(TRANSFER_ENCODING)) {
            this.transferEncoding = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsHeader(String headername) {
        if (this.contentType != null && headername.equalsIgnoreCase(CONTENT_TYPE)) {
            return true;
        }
        if (this.transferEncoding != null && headername.equalsIgnoreCase(TRANSFER_ENCODING)) {
            return true;
        }
        for (HeaderEntry entry : this.headers) {
            if (!entry.isNameEquals(headername)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getHeaderNameSet() {
        HashSet<String> headerNames = new HashSet<String>();
        if (this.contentType != null) {
            headerNames.add(CONTENT_TYPE);
        }
        if (this.transferEncoding != null) {
            headerNames.add(TRANSFER_ENCODING);
        }
        for (HeaderEntry entry : this.headers) {
            headerNames.add(entry.getName());
        }
        return headerNames;
    }

    @Override
    public final Enumeration getHeaderNames() {
        return Collections.enumeration(this.getHeaderNameSet());
    }

    @Override
    public List<String> getHeaderList(String headername) {
        if (headername.equalsIgnoreCase(TRANSFER_ENCODING)) {
            if (this.transferEncoding == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.transferEncoding);
            return Collections.unmodifiableList(result);
        }
        if (headername.equalsIgnoreCase(CONTENT_TYPE)) {
            if (this.contentType == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.contentType);
            return Collections.unmodifiableList(result);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (HeaderEntry entry : this.headers) {
            if (!entry.isNameEquals(headername)) continue;
            values.add(entry.getValue());
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public final Enumeration getHeaders(String headername) {
        return Collections.enumeration(this.getHeaderList(headername));
    }

    @Override
    public String getHeader(String headername) {
        if (headername.equalsIgnoreCase(TRANSFER_ENCODING)) {
            if (this.transferEncoding == null) {
                return null;
            }
            return this.transferEncoding;
        }
        if (headername.equalsIgnoreCase(CONTENT_TYPE)) {
            if (this.contentType == null) {
                return null;
            }
            return this.contentType;
        }
        for (HeaderEntry entry : this.headers) {
            if (!entry.isNameEquals(headername)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public String getHeader(String headername, String dflt) {
        String value = this.getHeader(headername);
        if (value == null) {
            return dflt;
        }
        return value;
    }

    @Override
    public final void setContentType(String contentType) {
        this.contentType = contentType;
        String encoding = HttpUtils.parseEncodingWithDefault(contentType, this.defaultEncoding);
        if (encoding != null) {
            this.characterEncoding = encoding;
        }
    }

    @Override
    public final String getCharacterEncoding() {
        if (this.characterEncoding == null && this.contentType != null) {
            this.characterEncoding = HttpUtils.parseEncodingWithDefault(this.contentType, this.defaultEncoding);
        }
        if (this.characterEncoding == null) {
            this.characterEncoding = this.defaultEncoding;
        }
        return this.characterEncoding;
    }

    final void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    public final List<ContentType> getAccept() {
        ArrayList<ContentType> result = new ArrayList<ContentType>();
        String acceptHeader = this.getHeader("Accept");
        if (acceptHeader != null) {
            if (acceptHeader.indexOf(",") == -1) {
                result.add(new ContentType(acceptHeader));
            } else {
                String[] acceptList = acceptHeader.split(",");
                ArrayList<WeightContentType> weightContentTypes = new ArrayList<WeightContentType>();
                String[] stringArray = acceptList;
                int n = acceptList.length;
                int n2 = 0;
                while (n2 < n) {
                    String acceptString = stringArray[n2];
                    weightContentTypes.add(new WeightContentType(acceptString));
                    ++n2;
                }
                Collections.sort(weightContentTypes);
                for (WeightContentType weightContentType : weightContentTypes) {
                    result.add(weightContentType.contentType);
                }
            }
        }
        return result;
    }

    @Override
    public final String getDisposition() {
        if (this.contentDisposition == null) {
            this.contentDisposition = this.getHeader(CONTENT_DISPOSITION);
        }
        return this.contentDisposition;
    }

    @Override
    public final String getDispositionType() {
        if (this.contentDispositionType == null) {
            this.resolveContentDisposition();
        }
        return this.contentDispositionType;
    }

    @Override
    public final String getDispositionParam(String name) {
        if (this.contentDispositionParams == null) {
            this.resolveContentDisposition();
        }
        if (this.contentDispositionParams != null) {
            return this.contentDispositionParams.get(name.toUpperCase(Locale.US));
        }
        return null;
    }

    private void resolveContentDisposition() {
        String cd = this.getDisposition();
        if (cd != null) {
            this.contentDispositionParams = new HashMap<String, String>();
            String[] parts = cd.split(";");
            int i = 0;
            while (i < parts.length) {
                parts[i] = parts[i].trim();
                if (i == 0) {
                    this.contentDispositionType = parts[i];
                } else {
                    int idx = parts[i].indexOf("=");
                    if (idx != -1) {
                        String name = parts[i].substring(0, idx).toUpperCase(Locale.US);
                        String value = this.removeQuote(parts[i].substring(idx + 1, parts[i].length()));
                        this.contentDispositionParams.put(name, value);
                    } else if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by parsing content disposition param " + parts[i]);
                    }
                }
                ++i;
            }
        }
    }

    private String removeQuote(String txt) {
        if (txt.charAt(0) == '\"') {
            txt = txt.substring(1, txt.length());
        }
        if (txt.charAt(txt.length() - 1) == '\"') {
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt;
    }

    @Override
    public final String getTransferEncoding() {
        return this.transferEncoding;
    }

    @Override
    public final void setTransferEncoding(String transferEncoding) {
        this.transferEncoding = transferEncoding;
    }

    void writeHeadersTo(StringBuilder sb) {
        if (this.contentType != null) {
            sb.append("Content-Type: ");
            sb.append(this.contentType);
            sb.append("\r\n");
        }
        if (this.transferEncoding != null) {
            sb.append("Transfer-Encoding: ");
            sb.append(this.transferEncoding);
            sb.append("\r\n");
        }
        for (HeaderEntry entry : this.headers) {
            entry.writeTo(sb);
            sb.append("\r\n");
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        Header copy = (Header)super.clone();
        copy.headers = (ArrayList)this.headers.clone();
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.writeHeadersTo(sb);
        return sb.toString();
    }

    private static class HeaderEntry {
        private String name = null;
        private String value = null;

        public HeaderEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        boolean isNameEquals(String name) {
            return this.name.equalsIgnoreCase(name);
        }

        public String toString() {
            return String.valueOf(this.name) + ": " + this.value;
        }

        void writeTo(StringBuilder sb) {
            sb.append(this.name);
            sb.append(": ");
            sb.append(this.value);
        }

        void writeFoldedTo(StringBuilder sb) {
            sb.append(this.name);
            if (this.value.length() > 250) {
                sb.append(":");
                sb.append(this.foldLine(this.value));
            } else {
                sb.append(": ");
                sb.append(this.value);
            }
        }

        private String foldLine(String line) {
            StringBuffer foldedLine = new StringBuffer();
            String[] tokens = line.split(" ");
            int currentLineLength = 0;
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (token.length() + currentLineLength > 250 || token.length() > 15) {
                    foldedLine.append("\r\n ");
                    foldedLine.append(token);
                    currentLineLength = token.length();
                } else {
                    foldedLine.append(" ");
                    foldedLine.append(token);
                    currentLineLength += token.length();
                }
                ++n2;
            }
            return foldedLine.toString();
        }
    }

    private static final class WeightContentType
    implements Comparable<WeightContentType> {
        private final ContentType contentType;
        private final double weight;

        WeightContentType(String acceptString) {
            int idx = acceptString.indexOf(";q=");
            if (idx == -1) {
                this.contentType = new ContentType(acceptString.trim());
                this.weight = 1.0;
            } else {
                this.contentType = new ContentType(acceptString.substring(0, idx).trim());
                String acceptParams = acceptString.substring(idx + 3, acceptString.length());
                if ((acceptParams = acceptParams.trim()).endsWith(";")) {
                    acceptParams = acceptParams.substring(0, acceptParams.length() - 1).trim();
                }
                if ((idx = acceptParams.indexOf(";")) != -1) {
                    acceptParams = acceptParams.substring(0, idx).trim();
                }
                this.weight = Double.parseDouble(acceptParams);
            }
        }

        @Override
        public int compareTo(WeightContentType other) {
            if (this.weight > other.weight) {
                return -1;
            }
            if (this.weight < other.weight) {
                return 1;
            }
            if (this.contentType.getPrimaryType().equals("*")) {
                return 1;
            }
            if (other.contentType.getPrimaryType().equals("*")) {
                return -1;
            }
            if (this.contentType.getPrimaryType().equalsIgnoreCase(other.contentType.getPrimaryType())) {
                if (this.contentType.getSubType().equals("*")) {
                    return 1;
                }
                if (other.contentType.getSubType().equals("*")) {
                    return -1;
                }
                if (this.contentType.getSubType().equalsIgnoreCase(other.contentType.getSubType())) {
                    if (this.contentType.toString().length() > other.contentType.toString().length()) {
                        return -1;
                    }
                    if (this.contentType.toString().length() < other.contentType.toString().length()) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        public boolean equals(Object other) {
            if (other instanceof WeightContentType) {
                WeightContentType otherWeightContentType = (WeightContentType)other;
                if (otherWeightContentType.weight == this.weight && otherWeightContentType.contentType.equals(this.contentType)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return (String.valueOf(this.contentType.toString()) + Double.toString(this.weight)).hashCode();
        }

        public String toString() {
            return String.valueOf(this.contentType.toString()) + " [q=" + this.weight + "]";
        }
    }
}

