/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.Header;
import org.xlightweb.IHttpMessageHeader;
import org.xsocket.connection.INonBlockingConnection;

class HttpMessageHeader
extends Header
implements IHttpMessageHeader {
    private static final Logger LOG = Logger.getLogger(HttpMessageHeader.class.getName());
    static final byte CR = 13;
    static final byte LF = 10;
    static final byte SPACE = 32;
    static final byte HTAB = 9;
    static final String HOST = "Host";
    static final String USER_AGENT = "User-Agent";
    static final String SERVER = "Server";
    static final String DATE = "Date";
    static final String CONTENT_LENGTH = "Content-Length";
    private int parsedChars = 0;
    private HashMap<String, Object> attributes = new HashMap();
    private int contentLength = -1;
    private String protocolScheme;
    private String protocolVersion;

    public HttpMessageHeader() {
    }

    public HttpMessageHeader(String contentType) {
        this.setContentType(contentType);
    }

    final void setProtocolSchemeSilence(String protocolScheme) {
        this.protocolScheme = protocolScheme;
    }

    final String getProtocolScheme() {
        return this.protocolScheme;
    }

    final void setProtocolVersionSilence(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String getProtocol() {
        return String.valueOf(this.protocolScheme) + "/" + this.protocolVersion;
    }

    @Override
    public final void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    @Override
    public final Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public final Set<String> getAttributeNameSet() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public final Enumeration getAttributeNames() {
        return Collections.enumeration(this.getAttributeNameSet());
    }

    int getCountParsedChars() {
        return this.parsedChars;
    }

    int incCountParsedChars(int parsedChars) {
        this.parsedChars += parsedChars;
        return this.parsedChars;
    }

    @Override
    public final int getContentLength() {
        return this.contentLength;
    }

    @Override
    public final void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    public final void copyHeaderFrom(IHttpMessageHeader otherHeader, String ... upperExcludenames) {
        block0: for (String headername : otherHeader.getHeaderNameSet()) {
            String upperheadername = headername.toUpperCase(Locale.US);
            String[] stringArray = upperExcludenames;
            int n = upperExcludenames.length;
            int n2 = 0;
            while (n2 < n) {
                String upperExcludename = stringArray[n2];
                if (upperheadername.equals(upperExcludename)) continue block0;
                ++n2;
            }
            for (String headervalue : otherHeader.getHeaderList(headername)) {
                this.addHeader(headername, headervalue);
            }
        }
    }

    @Override
    boolean onHeaderAdded(String headername, String headervalue) {
        if (headername.equalsIgnoreCase(CONTENT_LENGTH)) {
            try {
                this.contentLength = Integer.parseInt(headervalue);
            }
            catch (NumberFormatException nfe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error oocured by paring content length " + headervalue + " " + nfe.toString());
                }
                return super.onHeaderAdded(headername, headervalue);
            }
            return true;
        }
        return super.onHeaderAdded(headername, headervalue);
    }

    @Override
    boolean onHeaderRemoved(String headername) {
        if (headername.equalsIgnoreCase(CONTENT_LENGTH)) {
            this.contentLength = -1;
            return true;
        }
        return super.onHeaderRemoved(headername);
    }

    @Override
    public boolean containsHeader(String headername) {
        if (this.contentLength != -1 && headername.equalsIgnoreCase(CONTENT_LENGTH)) {
            return true;
        }
        return super.containsHeader(headername);
    }

    @Override
    public Set<String> getHeaderNameSet() {
        HashSet<String> headerNames = new HashSet<String>();
        if (this.contentLength != -1) {
            headerNames.add(CONTENT_LENGTH);
        }
        headerNames.addAll(super.getHeaderNameSet());
        return headerNames;
    }

    @Override
    public List<String> getHeaderList(String headername) {
        if (headername.equalsIgnoreCase(CONTENT_LENGTH)) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(Integer.toString(this.contentLength));
            return Collections.unmodifiableList(result);
        }
        return super.getHeaderList(headername);
    }

    @Override
    public String getHeader(String headername) {
        if (headername.equalsIgnoreCase(CONTENT_LENGTH)) {
            if (this.contentLength == -1) {
                return null;
            }
            return Integer.toString(this.contentLength);
        }
        return super.getHeader(headername);
    }

    @Override
    public final void removeHopByHopHeaders() {
        for (String connectionHeader : this.getHeaderList("Connection")) {
            this.removeHeader(connectionHeader);
        }
        this.removeHeader("Connection");
        this.removeHeader("Proxy-Connection");
        this.removeHeader("Keep-Alive");
        this.removeHeader("Proxy-Authenticate");
        this.removeHeader("Proxy-Authorization");
        this.removeHeader("TE");
        this.removeHeader("Trailers");
        this.removeHeader("Upgrade");
        if (this.getHeader("Transfer-Encoding") != null && !this.getHeader("Transfer-Encoding").equalsIgnoreCase("chunked")) {
            this.removeHeader("Transfer-Encoding");
        }
    }

    @Override
    final void writeHeadersTo(StringBuilder sb) {
        if (this.contentLength != -1) {
            sb.append("Content-Length: ");
            sb.append(this.contentLength);
            sb.append("\r\n");
        }
        super.writeHeadersTo(sb);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        HttpMessageHeader copy = (HttpMessageHeader)super.clone();
        copy.attributes = (HashMap)this.attributes.clone();
        return copy;
    }

    static String computeScheme(String protcolLeft, INonBlockingConnection connection) {
        if (protcolLeft == null || protcolLeft.equalsIgnoreCase("HTTP")) {
            if (connection.isSecure()) {
                return "https";
            }
            return "http";
        }
        return null;
    }

    @Override
    public IHttpMessageHeader copy() {
        try {
            return (IHttpMessageHeader)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse.toString());
        }
    }
}

