/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractHttpProtocolHandler;
import org.xlightweb.BadMessageException;
import org.xlightweb.FullMessageBodyDataSource;
import org.xlightweb.FullMessageChunkedBodyDataSource;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpRequestHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;
import org.xsocket.connection.INonBlockingConnection;

final class HttpProtocolHandlerServerSide
extends AbstractHttpProtocolHandler {
    HttpProtocolHandlerServerSide() {
    }

    @Override
    ByteBuffer[] parseHeader(AbstractHttpConnection httpConnection, ByteBuffer[] rawData) throws BadMessageException, IOException {
        block15: {
            HttpRequestHeader requestHeader = HttpProtocolHandlerServerSide.parse(httpConnection.getUnderlyingTcpConnection(), rawData);
            if (requestHeader == null) break block15;
            requestHeader.setBodyDefaultEncoding(httpConnection.getBodyDefaultEncoding());
            httpConnection.setLastTimeHeaderReceivedMillis(System.currentTimeMillis());
            httpConnection.incCountMessageReceived();
            AbstractHttpConnection.IMessageHeaderHandler messageHeaderHandler = httpConnection.getMessageHeaderHandler();
            if (messageHeaderHandler == null) {
                throw new IOException("no message handler set");
            }
            HttpRequest request = null;
            switch (HttpProtocolHandlerServerSide.getBodyType(requestHeader)) {
                case 0: {
                    request = new HttpRequest(requestHeader);
                    AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(request);
                    messageHandler.onHeaderProcessed();
                    messageHandler.onMessageReceived();
                    httpConnection.onMessageCompleteReceived(requestHeader);
                    rawData = HttpUtils.compact(rawData);
                    this.reset();
                    if (rawData == null) break;
                    return this.onData(httpConnection, rawData);
                }
                case 1: {
                    FullMessageBodyDataSource dataSource = new FullMessageBodyDataSource(requestHeader, requestHeader.getContentLength(), httpConnection);
                    this.setBodyDataSource(dataSource);
                    request = new HttpRequest((IHttpRequestHeader)requestHeader, (NonBlockingBodyDataSource)dataSource);
                    AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(request);
                    try {
                        this.setMessageHandler(messageHandler);
                        this.setState(10);
                        request.getNonBlockingBody().setBodyDataReceiveTimeoutMillisSilence(httpConnection.getBodyDataReceiveTimeoutMillis());
                        rawData = this.parserBody(httpConnection, rawData);
                    }
                    finally {
                        messageHandler.onHeaderProcessed();
                    }
                    return rawData;
                }
                case 5: {
                    FullMessageBodyDataSource dataSource = new FullMessageBodyDataSource(requestHeader, 8, httpConnection);
                    this.setBodyDataSource(dataSource);
                    request = new HttpRequest((IHttpRequestHeader)requestHeader, (NonBlockingBodyDataSource)dataSource);
                    request.removeHeader("Content-Length");
                    AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(request);
                    try {
                        this.setMessageHandler(messageHandler);
                        this.setState(10);
                        request.getNonBlockingBody().setBodyDataReceiveTimeoutMillisSilence(httpConnection.getBodyDataReceiveTimeoutMillis());
                        rawData = this.parserBody(httpConnection, rawData);
                    }
                    finally {
                        messageHandler.onHeaderProcessed();
                    }
                    return rawData;
                }
                default: {
                    FullMessageChunkedBodyDataSource dataSource = new FullMessageChunkedBodyDataSource(httpConnection, requestHeader);
                    this.setBodyDataSource(dataSource);
                    request = new HttpRequest((IHttpRequestHeader)requestHeader, (NonBlockingBodyDataSource)dataSource);
                    AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(request);
                    try {
                        this.setMessageHandler(messageHandler);
                        this.setState(10);
                        request.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                        rawData = this.parserBody(httpConnection, rawData);
                    }
                    finally {
                        messageHandler.onHeaderProcessed();
                    }
                    return rawData;
                }
            }
        }
        return rawData;
    }

    private static int getBodyType(HttpRequestHeader requestHeader) throws BadMessageException {
        String method = requestHeader.getMethod();
        if (method.equals("GET")) {
            if (requestHeader.getHeader("Sec-WebSocket-Key1") != null) {
                return 5;
            }
            return 0;
        }
        if (method.equals("POST")) {
            return HttpProtocolHandlerServerSide.getBodyTypeByHeader(requestHeader);
        }
        if (method.equals("CONNECT") || method.equals("HEAD") || method.equals("TRACE") || method.equals("DELETE") || method.equals("OPTIONS")) {
            return 0;
        }
        return HttpProtocolHandlerServerSide.getBodyTypeByHeader(requestHeader);
    }

    private static int getBodyTypeByHeader(HttpRequestHeader requestHeader) throws BadMessageException {
        if (requestHeader.getContentLength() != -1) {
            if (requestHeader.getContentLength() > 0) {
                return 1;
            }
            return 0;
        }
        String transferEncoding = requestHeader.getTransferEncoding();
        if (transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked")) {
            return 2;
        }
        throw new BadMessageException(requestHeader.toString());
    }

    private static HttpRequestHeader parse(INonBlockingConnection connection, ByteBuffer[] rawData) throws BadMessageException, IOException {
        HttpRequestHeader requestHeader = new HttpRequestHeader(connection);
        if (rawData == null) {
            return null;
        }
        ByteBuffer workBuffer = HttpUtils.duplicateAndMerge(rawData);
        int savePosition = workBuffer.position();
        int saveLimit = workBuffer.limit();
        try {
            block21: {
                int posStart;
                byte b;
                block20: {
                    do {
                        if ((b = workBuffer.get()) <= 32) continue;
                        posStart = workBuffer.position();
                        break block20;
                    } while (b == 13 || b == 10);
                    if (HttpUtils.isShowDetailedError()) {
                        workBuffer.position(savePosition);
                        workBuffer.limit(saveLimit);
                        throw new BadMessageException("bad request (by parsing method name): " + DataConverter.toString(HttpUtils.copy(workBuffer)));
                    }
                    throw new BadMessageException("bad request");
                }
                while (workBuffer.get() != 32) {
                }
                int posEnd = workBuffer.position();
                String method = HttpProtocolHandlerServerSide.extractString(posStart - 1, posEnd - posStart, workBuffer);
                requestHeader.setMethodSilence(method);
                workBuffer.position(posEnd);
                while (workBuffer.get() <= 32) {
                }
                posStart = workBuffer.position();
                while (true) {
                    String path;
                    if ((b = workBuffer.get()) >= 64) {
                        continue;
                    }
                    int posEnd2 = workBuffer.position();
                    if (b == 32) {
                        path = HttpProtocolHandlerServerSide.extractString(posStart - 1, posEnd2 - posStart, workBuffer);
                        requestHeader.setPathSilence(path);
                        workBuffer.position(posEnd2);
                        break;
                    }
                    if (b == 63) {
                        path = HttpProtocolHandlerServerSide.extractString(posStart - 1, posEnd2 - posStart, workBuffer);
                        requestHeader.setPathSilence(path);
                        workBuffer.position(posEnd2);
                        HttpProtocolHandlerServerSide.parserQueryParams(workBuffer, posEnd2, requestHeader);
                        break;
                    }
                    if (b > 32) continue;
                    if (b == 10) {
                        throw new BadMessageException("simple request messages are not supported");
                    }
                    if (b != 13) continue;
                    b = workBuffer.get();
                    if (b == 10) {
                        throw new BadMessageException("simple request messages are not supported");
                    }
                    workBuffer.position(workBuffer.position() - 1);
                }
                while (true) {
                    if ((b = workBuffer.get()) >= 48) {
                        continue;
                    }
                    if (b == 47) {
                        int posSlash = workBuffer.position();
                        String protocolScheme = HttpProtocolHandlerServerSide.extractString(posSlash - 5, 4, workBuffer);
                        requestHeader.setProtocolSchemeSilence(protocolScheme);
                        String protocolVersion = HttpProtocolHandlerServerSide.extractString(posSlash, 3, workBuffer);
                        requestHeader.setProtocolVersionSilence(protocolVersion);
                        workBuffer.position(posSlash + 3);
                        break block21;
                    }
                    if (b < 32 && b != 9) break;
                }
                if (HttpUtils.isShowDetailedError()) {
                    workBuffer.position(savePosition);
                    workBuffer.limit(saveLimit);
                    throw new BadMessageException("bad request (by parsing protocol): " + DataConverter.toString(HttpUtils.copy(workBuffer)));
                }
                throw new BadMessageException("bad message");
            }
            while (workBuffer.get() != 10) {
            }
            HttpProtocolHandlerServerSide.parseHeaderLines(workBuffer, requestHeader);
            HttpProtocolHandlerServerSide.skipPositions(workBuffer.position() - savePosition, rawData);
            return requestHeader;
        }
        catch (BadMessageException bme) {
            throw bme;
        }
        catch (Exception e) {
            workBuffer.position(savePosition);
            workBuffer.limit(saveLimit);
            if (workBuffer.remaining() > 8192) {
                throw new BadMessageException("max header size reached");
            }
            return null;
        }
    }

    private static void parserQueryParams(ByteBuffer buffer, int pos, HttpRequestHeader requestHeader) throws BadMessageException, IOException {
        String paramName = null;
        String paramValue = "";
        boolean isQueryParameterRead = false;
        block0: while (true) {
            byte b;
            if ((b = buffer.get()) >= 62) {
                continue;
            }
            if (b == 61) {
                isQueryParameterRead = true;
                paramName = HttpProtocolHandlerServerSide.extractString(pos, buffer.position() - 1 - pos, buffer);
                pos = buffer.position() + 1;
                while (true) {
                    if ((b = buffer.get()) >= 39) {
                        continue;
                    }
                    if (b == 38) {
                        paramValue = HttpProtocolHandlerServerSide.extractString(pos, buffer.position() - 1 - pos, buffer);
                        pos = buffer.position() + 1;
                        buffer.position(pos);
                        requestHeader.addRawQueryParameterSilence(paramName, paramValue);
                        paramName = null;
                        paramValue = "";
                        continue block0;
                    }
                    if (b == 32) {
                        paramValue = HttpProtocolHandlerServerSide.extractString(pos, buffer.position() - 1 - pos, buffer);
                        buffer.position(buffer.position() + 1);
                        requestHeader.addRawQueryParameterSilence(paramName, paramValue);
                        return;
                    }
                    if (b > 32) continue;
                    if (b == 10) {
                        throw new BadMessageException("simple request messages are not supported");
                    }
                    if (b != 13) continue;
                    b = buffer.get();
                    if (b == 10) {
                        throw new BadMessageException("simple request messages are not supported");
                    }
                    buffer.position(buffer.position() - 1);
                }
            }
            if (b == 32) {
                if (!isQueryParameterRead) {
                    String queryString = HttpProtocolHandlerServerSide.extractString(pos, buffer.position() - 1 - pos, buffer);
                    requestHeader.setQueryString(queryString);
                }
                buffer.position(buffer.position() + 1);
                return;
            }
            if (b > 32) continue;
            if (b == 10) {
                throw new BadMessageException("simple request messages are not supported");
            }
            if (b != 13) continue;
            b = buffer.get();
            if (b == 10) {
                throw new BadMessageException("simple request messages are not supported");
            }
            buffer.position(buffer.position() - 1);
        }
    }

    @Override
    void onDisconnectInHeaderNothingReceived(AbstractHttpConnection httpConnection, ByteBuffer[] rawData) {
    }
}

