/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.xlightweb.HttpMessageHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpResponseHeader;
import org.xsocket.DataConverter;

public class HttpResponseHeader
extends HttpMessageHeader
implements IHttpResponseHeader {
    private int statusCode = -1;
    private String reason;
    private String server;
    private String date;

    HttpResponseHeader() {
    }

    public HttpResponseHeader(int statusCode) {
        this(statusCode, null, HttpUtils.getReason(statusCode));
    }

    public HttpResponseHeader(String contentType) {
        this(200, contentType);
    }

    public HttpResponseHeader(int statusCode, String contentType) {
        this(statusCode, contentType, HttpUtils.getReason(statusCode));
    }

    public HttpResponseHeader(int statusCode, String contentType, String reason) {
        this("1.1", statusCode, contentType, reason);
    }

    HttpResponseHeader(String protocolVersion, int statusCode, String contentType, String reason) {
        this.setProtocolSchemeSilence("HTTP");
        this.setProtocolVersionSilence(protocolVersion);
        this.statusCode = statusCode;
        this.reason = reason;
        if (contentType != null) {
            this.setContentType(contentType);
        }
    }

    public final void copyHeaderFrom(HttpResponseHeader otherHeader, String ... upperExcludenames) {
        super.copyHeaderFrom(otherHeader, upperExcludenames);
    }

    @Override
    public final int getStatus() {
        return this.statusCode;
    }

    @Override
    public final void setStatus(int status) {
        this.statusCode = status;
    }

    @Override
    public final String getReason() {
        return this.reason;
    }

    @Override
    public final void setReason(String reason) {
        this.reason = reason;
    }

    public final void setExpireHeaders(int expireSec) {
        HttpUtils.setExpireHeaders(this, expireSec);
    }

    public final void setLastModifiedHeader(long timeMillis) {
        HttpUtils.setLastModifiedHeader(this, timeMillis);
    }

    public final void setDate(long timeMillis) {
        this.setDate(DataConverter.toFormatedRFC822Date(timeMillis));
    }

    @Override
    public final void setProtocol(String protocol) {
        int idx = protocol.indexOf("/");
        this.setProtocolSchemeSilence(protocol.substring(0, idx));
        this.setProtocolVersionSilence(protocol.substring(idx + 1, protocol.length()));
    }

    @Override
    public final String getDate() {
        return this.getHeader("Date");
    }

    @Override
    public final void setDate(String date) {
        this.setHeader("Date", date);
    }

    @Override
    public final void setServer(String server) {
        this.server = server;
    }

    @Override
    public final String getServer() {
        return this.server;
    }

    @Override
    protected final boolean onHeaderAdded(String headername, String headervalue) {
        if (headername.equalsIgnoreCase("Server")) {
            this.server = headervalue;
            return true;
        }
        if (headername.equalsIgnoreCase("Date")) {
            this.date = headervalue;
            return true;
        }
        return super.onHeaderAdded(headername, headervalue);
    }

    @Override
    protected final boolean onHeaderRemoved(String headername) {
        if (headername.equalsIgnoreCase("Server")) {
            this.server = null;
            return true;
        }
        if (headername.equalsIgnoreCase("Date")) {
            this.date = null;
            return true;
        }
        return super.onHeaderRemoved(headername);
    }

    @Override
    public final Set<String> getHeaderNameSet() {
        Set<String> headerNames = super.getHeaderNameSet();
        if (this.server != null) {
            headerNames.add("Server");
        }
        if (this.date != null) {
            headerNames.add("Date");
        }
        return headerNames;
    }

    @Override
    public final List<String> getHeaderList(String headername) {
        if (headername.equalsIgnoreCase("Server") && this.server != null) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.server);
            return Collections.unmodifiableList(result);
        }
        if (headername.equalsIgnoreCase("Date") && this.date != null) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.date);
            return Collections.unmodifiableList(result);
        }
        return super.getHeaderList(headername);
    }

    @Override
    public final String getHeader(String headername) {
        if (headername.equalsIgnoreCase("Server") && this.server != null) {
            return this.server;
        }
        if (headername.equalsIgnoreCase("Date") && this.date != null) {
            return this.date;
        }
        return super.getHeader(headername);
    }

    @Override
    public final boolean containsHeader(String headername) {
        if (headername.equalsIgnoreCase("Server") && this.server != null) {
            return true;
        }
        if (headername.equalsIgnoreCase("Date") && this.date != null) {
            return true;
        }
        return super.containsHeader(headername);
    }

    @Override
    protected final Object clone() throws CloneNotSupportedException {
        HttpResponseHeader copy = (HttpResponseHeader)super.clone();
        return copy;
    }

    @Override
    public final IHttpResponseHeader copy() {
        try {
            return (IHttpResponseHeader)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse.toString());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        if (this.getProtocolScheme() != null) {
            sb.append(this.getProtocolScheme());
            sb.append("/");
            sb.append(this.getProtocolVersion());
            sb.append(" ");
        }
        if (this.statusCode != -1) {
            sb.append(this.statusCode);
        }
        if (this.reason != null) {
            sb.append(" ");
            sb.append(this.reason);
        }
        sb.append("\r\n");
        if (this.server != null) {
            sb.append("Server: ");
            sb.append(this.server);
            sb.append("\r\n");
        }
        if (this.date != null) {
            sb.append("Date: ");
            sb.append(this.date);
            sb.append("\r\n");
        }
        this.writeHeadersTo(sb);
        return sb.toString();
    }
}

