/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import org.xlightweb.HttpUtils;
import org.xlightweb.IEventDataSource;
import org.xlightweb.IEventHandler;
import org.xlightweb.IUnsynchronized;

final class IEventHandlerInfo {
    private final boolean isUnsynchronized;
    private final boolean isOnConnectMultithreaded;
    private final boolean isOnMessageMultithreaded;
    private final boolean isOnDisconnectMultithreaded;

    IEventHandlerInfo(Class<IEventHandler> clazz) {
        if (clazz != null) {
            boolean isMultiThreaded = HttpUtils.isHandlerMultithreaded(clazz, true);
            this.isUnsynchronized = IUnsynchronized.class.isAssignableFrom(clazz);
            this.isOnConnectMultithreaded = HttpUtils.isMethodMultithreaded(clazz, "onConnect", isMultiThreaded, IEventDataSource.class);
            this.isOnDisconnectMultithreaded = HttpUtils.isMethodMultithreaded(clazz, "onDisconnect", isMultiThreaded, IEventDataSource.class);
            this.isOnMessageMultithreaded = HttpUtils.isMethodMultithreaded(clazz, "onMessage", isMultiThreaded, IEventDataSource.class);
        } else {
            this.isUnsynchronized = true;
            this.isOnConnectMultithreaded = false;
            this.isOnMessageMultithreaded = false;
            this.isOnDisconnectMultithreaded = false;
        }
    }

    public boolean isOnConnectMultithreaded() {
        return this.isOnConnectMultithreaded;
    }

    public boolean isOnMessageMultithreaded() {
        return this.isOnMessageMultithreaded;
    }

    public boolean isOnDisconnectMultithreaded() {
        return this.isOnDisconnectMultithreaded;
    }

    public boolean isUnsynchronized() {
        return this.isUnsynchronized;
    }
}

