/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSinkImplBase;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHttpMessageHeader;
import org.xlightweb.InMemoryBodyDataSource;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.Execution;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

final class InMemoryBodyDataSink
extends BodyDataSinkImplBase {
    private static final Logger LOG = Logger.getLogger(InMemoryBodyDataSink.class.getName());
    private final InMemoryBodyDataSource dataSource;
    private final DestroyListener destroyListener = new DestroyListener();
    private final String id;

    public InMemoryBodyDataSink(String id, IHttpMessageHeader header) throws IOException {
        this(id, new InMemoryBodyDataSource(header), HttpUtils.newMultimodeExecutor());
    }

    private InMemoryBodyDataSink(String id, InMemoryBodyDataSource dataSource, AbstractHttpConnection.IMultimodeExecutor executor) throws IOException {
        super(dataSource.getHeader(), executor);
        this.id = id;
        this.dataSource = dataSource;
        dataSource.addDestroyListenerSilence(this.destroyListener);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + " -> " + dataSource.getId() + "] body data sink created");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    NonBlockingBodyDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    protected boolean isNetworkendpoint() {
        return false;
    }

    @Override
    ByteBuffer[] preWrite(ByteBuffer[] buffers) throws IOException {
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            return HttpUtils.copy(buffers);
        }
        return buffers;
    }

    @Override
    ByteBuffer preWrite(ByteBuffer buffer) throws IOException {
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            return HttpUtils.copy(buffer);
        }
        return buffer;
    }

    @Override
    protected void onDestroy(String reason) {
        this.dataSource.destroy(reason);
    }

    @Override
    protected void onClose() throws IOException {
        this.dataSource.setComplete();
    }

    @Override
    int getPendingWriteDataSize() {
        return this.dataSource.size();
    }

    @Override
    int onWriteData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
        return this.dataSource.append(dataToWrite, completionHandler);
    }

    @Execution(value=0)
    private final class DestroyListener
    implements IBodyDestroyListener {
        private DestroyListener() {
        }

        @Override
        public void onDestroyed() throws IOException {
            boolean ignoreAppendError = InMemoryBodyDataSink.this.dataSource.isIgnoreAppendError();
            InMemoryBodyDataSink.this.destroy(ignoreAppendError);
        }
    }
}

