/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHeader;
import org.xlightweb.NonBlockingBodyDataSource;

final class InMemoryBodyDataSource
extends NonBlockingBodyDataSource {
    InMemoryBodyDataSource(IHeader header) throws IOException {
        super(header, HttpUtils.newMultimodeExecutor());
    }

    InMemoryBodyDataSource(IHeader header, byte[] body) throws IOException {
        this(header, new ByteBuffer[]{ByteBuffer.wrap(body)});
    }

    InMemoryBodyDataSource(IHeader header, ByteBuffer[] body) throws IOException {
        super(header, HttpUtils.newMultimodeExecutor(), body);
        this.setComplete();
    }

    @Override
    public String getId() {
        return String.valueOf(this.getClass().getSimpleName()) + "#" + this.hashCode();
    }

    @Override
    protected boolean isNetworkendpoint() {
        return false;
    }

    @Override
    boolean suspend() throws IOException {
        return false;
    }

    @Override
    boolean resume() throws IOException {
        return false;
    }

    @Override
    void onClose() {
    }

    @Override
    void onDestroy(String reason) {
    }
}

