/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSink;
import org.xlightweb.FileDataSource;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IForwardable;
import org.xlightweb.IHttpMessageHeader;
import org.xlightweb.MultipartByteRangeFilePart;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

final class MultipartByteRangeFileDataSource
extends NonBlockingBodyDataSource
implements IForwardable {
    private final List<MultipartByteRangeFilePart> parts = new ArrayList<MultipartByteRangeFilePart>();
    private final String dashBoundary;
    private final String closeDelimiter;
    private int bodySize = 0;

    MultipartByteRangeFileDataSource(IHttpMessageHeader header, AbstractHttpConnection.IMultimodeExecutor executor, File file, String[] ranges, String boundary) throws IOException {
        super(header, executor);
        this.dashBoundary = "--" + boundary;
        this.closeDelimiter = "\r\n" + this.dashBoundary + "--";
        String contentType = HttpUtils.resolveContentTypeByFileExtension(file);
        int fileLength = (int)file.length();
        int bodySize = 0;
        String[] stringArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            String range = stringArray[n2];
            int[] positions = HttpUtils.computeFromRangePosition(range, fileLength);
            MultipartByteRangeFilePart part = new MultipartByteRangeFilePart(header, new FileDataSource(header, executor, file, range));
            part.setHeader("Content-Range", "bytes " + positions[0] + "-" + positions[1] + "/" + fileLength);
            part.setContentType(contentType);
            this.parts.add(part);
            bodySize += positions[1] - positions[0] + 1;
            ++n2;
        }
    }

    long getLength() {
        return this.bodySize;
    }

    @Override
    public void forwardTo(BodyDataSink bodyDataSink) throws IOException {
        bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
        Iterator<MultipartByteRangeFilePart> it = this.parts.iterator();
        new PartWriter(it, true).forwardTo(bodyDataSink);
    }

    boolean isFileDataSource() {
        return true;
    }

    @Override
    protected boolean isNetworkendpoint() {
        return false;
    }

    @Override
    String getId() {
        return Integer.toString(this.hashCode());
    }

    @Override
    boolean suspend() throws IOException {
        return false;
    }

    @Override
    boolean resume() throws IOException {
        return false;
    }

    @Override
    void onClose() {
    }

    @Override
    void onDestroy(String reason) {
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MultipartByteRangeFilePart part : this.parts) {
            sb.append(String.valueOf(this.dashBoundary) + "\r\n");
            sb.append(part);
        }
        sb.append(String.valueOf(this.closeDelimiter) + "\r\n");
        return sb.toString();
    }

    @Execution(value=0)
    private final class PartWriter
    implements IForwardable,
    IWriteCompletionHandler {
        private final AtomicReference<BodyDataSink> dataSinkRef = new AtomicReference();
        private final Iterator<MultipartByteRangeFilePart> it;
        private final boolean isFirstPart;
        private final AtomicReference<MultipartByteRangeFilePart> partRef = new AtomicReference();

        public PartWriter(Iterator<MultipartByteRangeFilePart> it, boolean isFirstPart) {
            this.it = it;
            this.isFirstPart = isFirstPart;
        }

        @Override
        public void forwardTo(BodyDataSink dataSink) throws IOException {
            if (this.it.hasNext()) {
                MultipartByteRangeFilePart part = this.it.next();
                this.dataSinkRef.set(dataSink);
                this.partRef.set(part);
                if (this.isFirstPart) {
                    this.write(dataSink, String.valueOf(MultipartByteRangeFileDataSource.this.dashBoundary) + "\r\n", this);
                } else {
                    this.write(dataSink, "\r\n" + MultipartByteRangeFileDataSource.this.dashBoundary + "\r\n", this);
                }
            } else {
                this.write(dataSink, String.valueOf(MultipartByteRangeFileDataSource.this.closeDelimiter) + "\r\n", new WriteCompletionHandler(dataSink));
            }
        }

        private void write(BodyDataSink dataSink, String header, IWriteCompletionHandler completionHandler) throws IOException {
            dataSink.write(new ByteBuffer[]{DataConverter.toByteBuffer(header, "utf-8")}, completionHandler);
        }

        @Override
        public void onWritten(int written) throws IOException {
            IBodyCompleteListener completeListener = new IBodyCompleteListener(){

                @Override
                public void onComplete() throws IOException {
                    new PartWriter(PartWriter.this.it, false).forwardTo((BodyDataSink)PartWriter.this.dataSinkRef.get());
                }
            };
            this.partRef.get().forwardTo(this.dataSinkRef.get(), completeListener);
        }

        @Override
        public void onException(IOException ioe) {
            MultipartByteRangeFileDataSource.this.destroy(ioe.toString());
        }
    }

    private static final class WriteCompletionHandler
    implements IWriteCompletionHandler {
        private final BodyDataSink dataSink;

        public WriteCompletionHandler(BodyDataSink dataSink) {
            this.dataSink = dataSink;
        }

        @Override
        public void onWritten(int written) throws IOException {
            this.dataSink.close();
        }

        @Override
        public void onException(IOException ioe) {
            this.dataSink.destroy();
        }
    }
}

