/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xlightweb.BlockingBodyDataSource;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyDataSource;
import org.xlightweb.FileDataSource;
import org.xlightweb.Header;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IHeader;
import org.xlightweb.IPart;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.connection.IWriteCompletionHandler;

final class MultipartByteRangeFilePart
extends Header
implements IPart {
    private final IHeader header;
    private final FileDataSource dataSource;

    MultipartByteRangeFilePart(IHeader header, FileDataSource dataSource) {
        this.header = header;
        this.dataSource = dataSource;
    }

    @Override
    public BlockingBodyDataSource getBlockingBody() throws IOException {
        return new BlockingBodyDataSource(this.dataSource);
    }

    @Override
    public BodyDataSource getBody() throws IOException {
        return new BodyDataSource(this.dataSource);
    }

    @Override
    public NonBlockingBodyDataSource getNonBlockingBody() throws IOException {
        return this.dataSource;
    }

    @Override
    public boolean hasBody() {
        return this.dataSource != null;
    }

    public boolean hasMultipartBody() {
        return this.hasBody();
    }

    @Override
    public IHeader getPartHeader() {
        return this.header;
    }

    public void forwardTo(final BodyDataSink bodyDataSink, final IBodyCompleteListener completeListener) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.writeHeadersTo(sb);
        IWriteCompletionHandler ch = new IWriteCompletionHandler(){

            @Override
            @Execution(value=0)
            public void onWritten(int written) throws IOException {
                MultipartByteRangeFilePart.this.dataSource.forwardTo(bodyDataSink, completeListener);
            }

            @Override
            public void onException(IOException ioe) {
                bodyDataSink.destroy();
                MultipartByteRangeFilePart.this.dataSource.destroy();
            }
        };
        bodyDataSink.write(new ByteBuffer[]{DataConverter.toByteBuffer(String.valueOf(sb.toString()) + "\r\n", "utf-8")}, ch);
    }
}

