/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkBodyDataSource;
import org.xlightweb.HttpMessageHeader;
import org.xlightweb.ProtocolException;
import org.xsocket.DataConverter;

final class MultipartByteRangeMessageBodyDataSource
extends AbstractNetworkBodyDataSource {
    private static final Logger LOG = Logger.getLogger(MultipartByteRangeMessageBodyDataSource.class.getName());
    private String separator;
    private String endSeparator;
    private int separatorIdx = 0;
    private boolean isRead = false;
    private final StringBuilder stringBuilder = new StringBuilder();

    public MultipartByteRangeMessageBodyDataSource(AbstractHttpConnection httpConnection, HttpMessageHeader header) throws IOException {
        super(header, httpConnection);
        String contentType = header.getContentType();
        String[] stringArray = contentType.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if ((token = token.trim()).toLowerCase().startsWith("boundary=")) {
                this.separator = token.substring("boundary=".length(), token.length()).trim();
                this.endSeparator = "--" + this.separator + "--";
            }
            ++n2;
        }
        this.postCreate();
    }

    String getSeparator() {
        return this.separator;
    }

    @Override
    void doParse(ByteBuffer[] rawData) throws IOException {
        ByteBuffer[] byteBufferArray = rawData;
        int n = rawData.length;
        int n2 = 0;
        while (n2 < n) {
            ByteBuffer buffer = byteBufferArray[n2];
            if (buffer != null) {
                int remaining = buffer.remaining();
                int i = 0;
                while (i < remaining) {
                    byte b = buffer.get();
                    if (b == (byte)this.endSeparator.charAt(this.separatorIdx)) {
                        ++this.separatorIdx;
                        if (this.separatorIdx == this.endSeparator.length()) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("body read. set complete true");
                            }
                            this.stringBuilder.append(this.endSeparator);
                            this.stringBuilder.append("\r\n");
                            this.onReadNetworkData(DataConverter.toByteBuffer(this.stringBuilder.toString(), this.getHeader().getCharacterEncoding()));
                            this.isRead = true;
                            this.setComplete();
                            return;
                        }
                    } else if (this.separatorIdx > 0) {
                        this.stringBuilder.append(this.endSeparator.substring(0, this.separatorIdx));
                        this.separatorIdx = 0;
                    } else {
                        this.stringBuilder.append((char)b);
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }

    @Override
    void onClose() throws IOException {
        if (!this.isRead) {
            throw new ProtocolException("connection has been closed (by user?) while receiving body data. (MultipartByteRangeMessage)", null);
        }
    }

    @Override
    void performOnDisconnect() throws ProtocolException {
        if (!this.isRead) {
            throw new ProtocolException("connection has been closed (by peer?) while receiving body data. (MultipartByteRangeMessage)", null);
        }
    }
}

