/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.UUID;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpRequestHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IPart;
import org.xlightweb.MultipartDataSource;

public class MultipartRequest
extends HttpRequest {
    public MultipartRequest(String method, String url) throws MalformedURLException, IOException {
        this(method, url, "multipart/mixed", (String)null);
    }

    public MultipartRequest(String method, String url, String contentType) throws MalformedURLException, IOException {
        this(method, url, contentType, HttpUtils.parseMediaTypeParameter(contentType, "boundary", true, null));
    }

    private MultipartRequest(String method, String url, String contentType, String boundary) throws MalformedURLException, IOException {
        super(new HttpRequestHeader(method, url));
        if (boundary == null) {
            boundary = UUID.randomUUID().toString();
            contentType = String.valueOf(contentType) + "; boundary=" + boundary;
        }
        this.setBody(new MultipartDataSource(this.getRequestHeader(), null, "--" + boundary));
        this.setContentType(contentType);
        this.removeHeader("Content-Length");
        this.setHeader("Transfer-Encoding", "chunked");
    }

    MultipartDataSource getMultipartDataSource() throws IOException {
        return (MultipartDataSource)this.getNonBlockingBody();
    }

    public final void addPart(IPart part) throws IOException {
        this.getMultipartDataSource().addPart(part);
    }
}

