/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BodyDataSource;
import org.xlightweb.IMultivalueMap;
import org.xlightweb.NameValuePair;

public class MultivalueMap
implements IMultivalueMap {
    private static final Logger LOG = Logger.getLogger(MultivalueMap.class.getName());
    private static final Boolean NULL_BOOLEAN = null;
    private static final String NULL = UUID.randomUUID().toString();
    private final Map<String, List<String>> multivalueMap = new HashMap<String, List<String>>();
    private final String encoding;
    private String entity;

    public MultivalueMap(NameValuePair decodedFormParameter) {
        this("utf-8", decodedFormParameter);
    }

    public MultivalueMap(String encoding) {
        this(encoding, new NameValuePair[]{null});
    }

    public MultivalueMap(NameValuePair ... decodedFormParameters) {
        this("utf-8", decodedFormParameters);
    }

    public MultivalueMap(String encoding, NameValuePair ... decodedFormParameters) {
        this.encoding = encoding;
        NameValuePair[] nameValuePairArray = decodedFormParameters;
        int n = decodedFormParameters.length;
        int n2 = 0;
        while (n2 < n) {
            NameValuePair nvp = nameValuePairArray[n2];
            if (nvp != null) {
                if (nvp.getValue() == null) {
                    this.addParameter(nvp.getName(), NULL);
                } else {
                    this.addParameter(nvp.getName(), nvp.getValue());
                }
            }
            ++n2;
        }
    }

    public MultivalueMap(BodyDataSource bodyDataSource) throws IOException {
        this(bodyDataSource.getEncoding(), bodyDataSource.readString());
    }

    public MultivalueMap(String encoding, String ... decodedFormParameters) {
        this.encoding = encoding;
        String[] stringArray = decodedFormParameters;
        int n = decodedFormParameters.length;
        int n2 = 0;
        while (n2 < n) {
            String kvp = stringArray[n2];
            int idx = kvp.indexOf("=");
            if (idx <= 0) {
                throw new RuntimeException("illegal format: '" + kvp + "' (usage: <key>=<value>)");
            }
            String name = kvp.substring(0, idx);
            String value = kvp.substring(idx + 1, kvp.length());
            this.addParameter(name, value);
            ++n2;
        }
    }

    public MultivalueMap(String encoding, String serialized) throws IOException {
        this.encoding = encoding;
        String[] stringArray = serialized.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                String kvp = stringArray[n2];
                int idx = kvp.indexOf("=");
                if (idx > 0) {
                    String name = kvp.substring(0, idx).trim();
                    String value = kvp.substring(idx + 1, kvp.length());
                    if (value.length() == 0) {
                        try {
                            this.addParameter(URLDecoder.decode(name, encoding), NULL);
                        }
                        catch (UnsupportedEncodingException usec) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("error occured by decoding param " + name + "=" + value + " " + usec.toString() + " ignoring it");
                            }
                            break block10;
                        }
                    }
                    try {
                        this.addParameter(URLDecoder.decode(name, encoding), URLDecoder.decode(value, encoding));
                    }
                    catch (UnsupportedEncodingException usec) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("error occured by decoding param " + name + "=" + value + " " + usec.toString() + " ignoring it");
                        }
                        break block10;
                    }
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("invalid format: " + kvp + " ignoring value");
                }
            }
            ++n2;
        }
    }

    @Override
    public final void setParameter(String name, String value) {
        if (value == null) {
            value = NULL;
        }
        this.removeParameter(name);
        this.addParameter(name, value);
    }

    @Override
    public final void removeParameter(String name) {
        this.entity = null;
        this.multivalueMap.remove(name);
    }

    @Override
    public final void addParameter(String name, String value) {
        List<String> values;
        this.entity = null;
        if (value == null) {
            value = NULL;
        }
        if ((values = this.multivalueMap.get(name)) == null) {
            values = new ArrayList<String>();
            this.multivalueMap.put(name, values);
        }
        if (value != null) {
            values.add(value);
        }
    }

    @Override
    public final Set<String> getParameterNameSet() {
        return Collections.unmodifiableSet(this.multivalueMap.keySet());
    }

    @Override
    public final String[] getParameterValues(String name) {
        List<String> values = this.multivalueMap.get(name);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public final String getParameter(String name) {
        List<String> values = this.multivalueMap.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        String value = values.get(0);
        if (value.equals(NULL)) {
            return null;
        }
        return value;
    }

    @Override
    public final Integer getIntParameter(String name) {
        String s = this.getParameter(name);
        if (s != null) {
            return Integer.parseInt(s);
        }
        return null;
    }

    @Override
    public final int getIntParameter(String name, int defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public final Long getLongParameter(String name) {
        String s = this.getParameter(name);
        if (s != null) {
            return Long.parseLong(s);
        }
        return null;
    }

    @Override
    public final long getLongParameter(String name, long defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public final Double getDoubleParameter(String name) {
        String s = this.getParameter(name);
        if (s != null) {
            return Double.parseDouble(s);
        }
        return null;
    }

    @Override
    public final double getDoubleParameter(String name, double defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Double.parseDouble(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public final Float getFloatParameter(String name) {
        String s = this.getParameter(name);
        if (s != null) {
            return Float.valueOf(Float.parseFloat(s));
        }
        return null;
    }

    @Override
    public final float getFloatParameter(String name, float defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Float.parseFloat(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public final Boolean getBooleanParameter(String name) {
        String s = this.getParameter(name);
        if (s != null) {
            return Boolean.parseBoolean(s);
        }
        return NULL_BOOLEAN;
    }

    @Override
    public final boolean getBooleanParameter(String name, boolean defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Boolean.parseBoolean(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public String toString() {
        if (this.entity == null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : this.multivalueMap.entrySet()) {
                for (String value : entry.getValue()) {
                    if (value.equals(NULL)) {
                        try {
                            sb.append(String.valueOf(URLEncoder.encode(entry.getKey(), this.encoding)) + "=&");
                        }
                        catch (UnsupportedEncodingException usec) {
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.fine("error occured by encoding param " + entry.getKey() + "=" + value + " " + usec.toString() + " ignoring it");
                        }
                        continue;
                    }
                    try {
                        sb.append(String.valueOf(URLEncoder.encode(entry.getKey(), this.encoding)) + "=" + URLEncoder.encode(value, this.encoding) + "&");
                    }
                    catch (UnsupportedEncodingException usec) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("error occured by encoding param " + entry.getKey() + "=" + value + " " + usec.toString() + " ignoring it");
                    }
                }
            }
            this.entity = sb.toString();
            if (this.entity.length() > 0) {
                this.entity = this.entity.substring(0, this.entity.length() - 1);
            }
        }
        return this.entity;
    }
}

