/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.xlightweb.BlockingBodyDataSource;
import org.xlightweb.BodyDataSource;
import org.xlightweb.FileDataSource;
import org.xlightweb.Header;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHeader;
import org.xlightweb.IPart;
import org.xlightweb.InMemoryBodyDataSource;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;

public class Part
implements IPart {
    private final IHeader header;
    private final AtomicReference<NonBlockingBodyDataSource> bodyDataSourceRef = new AtomicReference();

    Part(IHeader header) {
        this.header = header;
    }

    public Part(String contentType, String body) throws IOException {
        this((IHeader)new Header(contentType), body);
    }

    public Part(IHeader header, String body) throws IOException {
        this(header, Part.convert(header, body));
    }

    public Part(String contentType, ByteBuffer[] body) throws IOException {
        this((IHeader)new Header(contentType), body);
    }

    public Part(File file) throws IOException {
        this((IHeader)new Header(), file);
    }

    public Part(IHeader header, File file) throws IOException {
        this(header);
        this.setBody(new FileDataSource(header, HttpUtils.newMultimodeExecutor(), file));
        if (header.getContentType() == null) {
            header.setContentType(HttpUtils.resolveContentTypeByFileExtension(file));
        }
    }

    public Part(IHeader header, ByteBuffer[] body) throws IOException {
        this(header);
        this.setBody(header, body);
    }

    public Part(IHeader header, NonBlockingBodyDataSource body) throws IOException {
        this(header);
        this.setBody(body);
    }

    @Override
    public IHeader getPartHeader() {
        return this.header;
    }

    @Override
    public final NonBlockingBodyDataSource getNonBlockingBody() throws IOException {
        NonBlockingBodyDataSource ds = this.bodyDataSourceRef.get();
        if (ds == null) {
            try {
                ds = new InMemoryBodyDataSource(this.header);
                ds.setComplete();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return ds;
    }

    @Override
    public final boolean hasBody() {
        return this.bodyDataSourceRef.get() != null;
    }

    @Override
    public final BlockingBodyDataSource getBlockingBody() throws IOException {
        return new BlockingBodyDataSource(this.getNonBlockingBody());
    }

    @Override
    public BodyDataSource getBody() throws IOException {
        return new BodyDataSource(this.getNonBlockingBody());
    }

    @Override
    public final void addHeader(String headername, String headervalue) {
        this.header.addHeader(headername, headervalue);
    }

    @Override
    public final void addHeaderLine(String line) {
        this.header.addHeaderLine(line);
    }

    @Override
    public final void addHeaderlines(String ... lines) {
        this.header.addHeaderlines(lines);
    }

    @Override
    public final boolean containsHeader(String headername) {
        return this.header.containsHeader(headername);
    }

    @Override
    public final String getCharacterEncoding() {
        return this.header.getCharacterEncoding();
    }

    @Override
    public final String getContentType() {
        return this.header.getContentType();
    }

    @Override
    public final String getDisposition() {
        return this.header.getDisposition();
    }

    @Override
    public final String getDispositionParam(String name) {
        return this.header.getDispositionParam(name);
    }

    @Override
    public final String getDispositionType() {
        return this.header.getDispositionType();
    }

    @Override
    public final String getHeader(String headername) {
        return this.header.getHeader(headername);
    }

    @Override
    public String getHeader(String headername, String dfltValue) {
        return this.header.getHeader(headername, dfltValue);
    }

    @Override
    public final List<String> getHeaderList(String headername) {
        return this.header.getHeaderList(headername);
    }

    @Override
    public final Enumeration getHeaderNames() {
        return this.header.getHeaderNames();
    }

    @Override
    public final Set<String> getHeaderNameSet() {
        return this.header.getHeaderNameSet();
    }

    @Override
    public final Enumeration getHeaders(String headername) {
        return this.header.getHeaders(headername);
    }

    @Override
    public final String getTransferEncoding() {
        return this.header.getTransferEncoding();
    }

    @Override
    public final void removeHeader(String headername) {
        this.header.removeHeader(headername);
    }

    @Override
    public final void setContentType(String type) {
        this.header.setContentType(type);
    }

    @Override
    public final void setHeader(String headername, String headervalue) {
        this.header.setHeader(headername, headervalue);
    }

    @Override
    public final void setTransferEncoding(String transferEncoding) {
        this.header.setTransferEncoding(transferEncoding);
        this.removeHeader("Content-length");
    }

    public String toString() {
        if (this.bodyDataSourceRef.get() == null) {
            return String.valueOf(this.header.toString()) + "\r\n";
        }
        return String.valueOf(this.header.toString()) + "\r\n" + this.bodyDataSourceRef.toString();
    }

    final void setBody(IHeader header, ByteBuffer[] body) throws IOException {
        this.setBody(new InMemoryBodyDataSource(header, body));
    }

    boolean setBody(NonBlockingBodyDataSource body) throws IOException {
        if (body == null) {
            return false;
        }
        this.bodyDataSourceRef.set(body);
        return true;
    }

    static ByteBuffer[] convert(IHeader header, String body) {
        if (header.getContentType() != null && HttpUtils.isTextMimeType(header.getContentType()) && HttpUtils.parseEncoding(header.getContentType()) == null) {
            header.setContentType(String.valueOf(header.getContentType()) + "; charset=utf-8");
        }
        return new ByteBuffer[]{DataConverter.toByteBuffer(body, header.getCharacterEncoding())};
    }
}

