/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpRequestHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.MultivalueMap;
import org.xlightweb.NameValuePair;

public class PutRequest
extends HttpRequest {
    public PutRequest(String url) throws MalformedURLException {
        super(new HttpRequestHeader("PUT", url));
    }

    public PutRequest(String url, String contentType) throws IOException, MalformedURLException {
        super("PUT", url);
        this.setContentType(contentType);
    }

    public PutRequest(String url, File file) throws IOException, MalformedURLException {
        super((IHttpRequestHeader)new HttpRequestHeader("PUT", url, HttpUtils.resolveContentTypeByFileExtension(file)), file);
    }

    public PutRequest(String url, File file, boolean compress) throws IOException, MalformedURLException {
        super((IHttpRequestHeader)new HttpRequestHeader("PUT", url, HttpUtils.resolveContentTypeByFileExtension(file)), HttpUtils.readFile(file), compress);
    }

    public PutRequest(String url, String contentType, String body) throws IOException, MalformedURLException {
        this(url, contentType, body, false);
    }

    public PutRequest(String url, String contentType, String body, boolean compress) throws IOException, MalformedURLException {
        super("PUT", url, HttpUtils.addEncodingIfNotPresent(contentType), body, compress);
    }

    public PutRequest(String url, String contentType, String encoding, String body) throws IOException, MalformedURLException {
        this(url, contentType, encoding, body, false);
    }

    public PutRequest(String url, String contentType, String encoding, String body, boolean compress) throws IOException, MalformedURLException {
        super("PUT", url, String.valueOf(contentType) + ";" + encoding, body, compress);
    }

    public PutRequest(String url, String contentType, byte[] body) throws IOException, MalformedURLException {
        this(url, contentType, body, false);
    }

    public PutRequest(String url, String contentType, byte[] body, boolean compress) throws IOException, MalformedURLException {
        super("PUT", url, contentType, body, compress);
    }

    public PutRequest(String url, String contentType, ByteBuffer[] body) throws IOException, MalformedURLException {
        this(url, contentType, body, false);
    }

    public PutRequest(String url, String contentType, ByteBuffer[] body, boolean compress) throws IOException, MalformedURLException {
        super("PUT", url, contentType, body, compress);
    }

    public PutRequest(String url, NameValuePair ... formParameters) throws IOException, MalformedURLException {
        super("PUT", url, "application/x-www-form-urlencoded; charset=utf-8", new MultivalueMap("utf-8", formParameters).toString());
    }

    public PutRequest(String url, String[] formParameters) throws IOException, MalformedURLException {
        super("PUT", url, "application/x-www-form-urlencoded; charset=utf-8", new MultivalueMap("utf-8", formParameters).toString());
    }
}

