/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BadMessageException;
import org.xlightweb.BodyDataSink;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IForwardable;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpRequestTimeoutHandler;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IHttpSession;
import org.xlightweb.IUnsynchronized;
import org.xlightweb.InMemoryBodyDataSink;
import org.xlightweb.InvokeOn;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.Supports100Continue;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;

@Supports100Continue
public class RequestHandlerChain
implements IHttpRequestHandler,
IHttpRequestTimeoutHandler,
ILifeCycle,
IUnsynchronized {
    private static final Logger LOG = Logger.getLogger(RequestHandlerChain.class.getName());
    private final List<IHttpRequestHandler> handlers = new ArrayList<IHttpRequestHandler>();
    private final List<ILifeCycle> lifeCycleChain = new ArrayList<ILifeCycle>();
    private List<AbstractHttpConnection.RequestHandlerAdapter> handlerChain = new ArrayList<AbstractHttpConnection.RequestHandlerAdapter>();
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);

    public RequestHandlerChain() {
    }

    public RequestHandlerChain(List<IHttpRequestHandler> handlers) {
        for (IHttpRequestHandler hdl : handlers) {
            this.addLast(hdl);
        }
    }

    public void addFirst(IHttpRequestHandler handler) {
        this.handlers.add(0, handler);
        this.computePath();
        if (this.isInitialized.get() && handler instanceof ILifeCycle) {
            ((ILifeCycle)((Object)handler)).onInit();
        }
    }

    public void addLast(IHttpRequestHandler handler) {
        this.handlers.add(handler);
        this.computePath();
        if (this.isInitialized.get() && handler instanceof ILifeCycle) {
            ((ILifeCycle)((Object)handler)).onInit();
        }
    }

    public void remove(IHttpRequestHandler handler) {
        block3: {
            boolean isRemoved = this.handlers.remove(handler);
            this.computePath();
            if (isRemoved && this.isInitialized.get() && handler instanceof ILifeCycle) {
                try {
                    ((ILifeCycle)((Object)handler)).onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("Error occured by calling onDestroy on " + handler + " " + ioe.toString());
                }
            }
        }
    }

    public void clear() {
        this.handlers.clear();
        this.computePath();
    }

    public List<IHttpRequestHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    private void computePath() {
        this.lifeCycleChain.clear();
        ArrayList<AbstractHttpConnection.RequestHandlerAdapter> newHandlerChain = new ArrayList<AbstractHttpConnection.RequestHandlerAdapter>();
        for (IHttpRequestHandler handler : this.handlers) {
            AbstractHttpConnection.RequestHandlerAdapter handlerAdapter = new AbstractHttpConnection.RequestHandlerAdapter(handler);
            newHandlerChain.add(handlerAdapter);
            if (!(handler instanceof ILifeCycle)) continue;
            this.lifeCycleChain.add((ILifeCycle)((Object)handler));
        }
        this.handlerChain = Collections.unmodifiableList(newHandlerChain);
    }

    @Override
    public void onInit() {
        this.isInitialized.set(true);
        for (ILifeCycle lifeCycle : this.lifeCycleChain) {
            lifeCycle.onInit();
        }
    }

    @Override
    public void onDestroy() throws IOException {
        for (ILifeCycle lifeCycle : this.lifeCycleChain) {
            lifeCycle.onDestroy();
        }
    }

    @Override
    @InvokeOn(value=0)
    public void onRequest(IHttpExchange exchange) throws IOException {
        try {
            if (this.handlerChain.isEmpty()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("chain is empty. Forwarding to environment");
                }
                exchange.forward(exchange.getRequest(), (IHttpResponseHandler)new HttpResponseHandlerAdapter(exchange));
            } else {
                ChainExchange chainExchange = new ChainExchange(exchange, this.handlerChain, 0, exchange.getRequest(), null);
                chainExchange.handle();
            }
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by handling request by chain " + this);
            }
            exchange.sendError(ioe);
        }
    }

    @Override
    public boolean onRequestTimeout(IHttpConnection connection) throws IOException {
        if (this.handlerChain.isEmpty()) {
            return true;
        }
        for (AbstractHttpConnection.RequestHandlerAdapter requestAdapter : this.handlerChain) {
            requestAdapter.onRequestTimeout(connection);
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        StringBuilder hc = new StringBuilder();
        for (AbstractHttpConnection.RequestHandlerAdapter handler : this.handlerChain) {
            hc.append(String.valueOf(handler.getDelegate().getClass().getName()) + " -> ");
        }
        if (hc.length() > 0) {
            hc.setLength(hc.length() - 4);
        }
        sb.append(" (handlerChain: " + hc.toString());
        return sb.toString();
    }

    private final class ChainExchange
    extends AbstractHttpConnection.AbstractExchange {
        private final List<AbstractHttpConnection.RequestHandlerAdapter> chain;
        private final int num;
        private final IHttpExchange rootExchange;
        private final IHttpRequest request;
        private final IHttpResponseHandler responseHandler;
        private AbstractHttpConnection.RequestHandlerAdapter handler;

        public ChainExchange(IHttpExchange rootExchange, List<AbstractHttpConnection.RequestHandlerAdapter> chain, int num, IHttpRequest request, IHttpResponseHandler responseHandler) {
            super(rootExchange);
            this.handler = null;
            this.rootExchange = rootExchange;
            this.chain = chain;
            this.num = num;
            this.request = request;
            this.responseHandler = responseHandler;
        }

        @Override
        public IHttpRequest getRequest() {
            return this.request;
        }

        @Override
        public IHttpSession getSession(boolean create) {
            return this.rootExchange.getSession(create);
        }

        @Override
        public String encodeURL(String url) {
            return this.rootExchange.encodeURL(url);
        }

        void handle() throws IOException, BadMessageException {
            try {
                this.handler = this.chain.get(this.num);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.chain.hashCode() + "] handling request by chain element (" + this.num + " of " + this.chain.size() + ") " + this.handler);
                }
                if (this.handler.isInvokeOnMessageReceived() && this.request.hasBody()) {
                    NonBlockingBodyDataSource bodyDataSource = this.request.getNonBlockingBody();
                    if (!bodyDataSource.isCompleteReceived()) {
                        BodyListener bodyListener = new BodyListener();
                        bodyDataSource.addCompleteListener(bodyListener);
                        bodyDataSource.addDestroyListener(bodyListener);
                    } else {
                        this.handler.onRequest(this);
                    }
                } else {
                    this.handler.onRequest(this);
                }
            }
            catch (IndexOutOfBoundsException iobe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.chain.hashCode() + "] end of request chain reached. Forwarding to environment");
                }
                this.rootExchange.forward(this.request, this.responseHandler);
            }
        }

        @Override
        public void send(IHttpResponse response) throws IOException, IllegalStateException {
            HttpUtils.addConnectionAttribute(response.getResponseHeader(), this.rootExchange.getConnection());
            if (response.hasBody() && response.getNonBlockingBody().isForwardable()) {
                BodyDataSink dataSink = this.send(response.getResponseHeader());
                ((IForwardable)((Object)response.getNonBlockingBody())).forwardTo(dataSink);
            } else if (this.responseHandler == null) {
                this.rootExchange.send(response);
            } else {
                this.callResponseHandler(this.responseHandler, response);
            }
        }

        @Override
        public BodyDataSink send(IHttpResponseHeader header, int contentLength) throws IOException, IllegalStateException {
            HttpUtils.addConnectionAttribute(header, this.rootExchange.getConnection());
            if (header.getContentLength() == -1) {
                header.setContentLength(contentLength);
            }
            if (this.responseHandler == null) {
                return this.rootExchange.send(header, contentLength);
            }
            InMemoryBodyDataSink dataSink = new InMemoryBodyDataSink(this.handler.toString(), header);
            HttpResponse response = new HttpResponse(header, dataSink.getDataSource());
            this.send(response);
            return dataSink;
        }

        @Override
        public BodyDataSink send(IHttpResponseHeader header) throws IOException, IllegalStateException {
            HttpUtils.addConnectionAttribute(header, this.rootExchange.getConnection());
            if (this.responseHandler == null) {
                return this.rootExchange.send(header);
            }
            InMemoryBodyDataSink dataSink = new InMemoryBodyDataSink(this.handler.toString(), header);
            HttpResponse response = new HttpResponse(header, dataSink.getDataSource());
            this.send(response);
            return dataSink;
        }

        @Override
        public void sendError(Exception e) throws IllegalStateException {
            if (this.responseHandler == null) {
                this.rootExchange.sendError(e);
            } else {
                IOException ioe = HttpUtils.toIOException(e);
                this.callResponseHandler(this.responseHandler, ioe);
            }
        }

        @Override
        public void forward(IHttpRequest request) throws IOException, ConnectException, IllegalStateException {
            this.forward(request, this.responseHandler);
        }

        @Override
        public void forward(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException, IllegalStateException {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.chain.hashCode() + "] request is forwarded (to next handler of chain) by " + this.handler);
            }
            if (responseHandler == null) {
                responseHandler = new DefaultResponseHandler();
            }
            if (request.hasBody() && request.getNonBlockingBody().isForwardable()) {
                BodyDataSink dataSink = this.forward(request.getRequestHeader(), responseHandler);
                ((IForwardable)((Object)request.getNonBlockingBody())).forwardTo(dataSink);
            } else {
                ChainExchange chainExchange = new ChainExchange(this.rootExchange, this.chain, this.num + 1, request, responseHandler);
                chainExchange.handle();
            }
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException, IllegalStateException {
            if (requestHeader.getContentLength() != -1) {
                return this.forward(requestHeader, requestHeader.getContentLength(), responseHandler);
            }
            if (requestHeader.getTransferEncoding() == null) {
                requestHeader.setHeader("Transfer-Encoding", "chunked");
            }
            InMemoryBodyDataSink dataSink = new InMemoryBodyDataSink(this.handler.toString(), requestHeader);
            HttpRequest request = new HttpRequest(requestHeader, dataSink.getDataSource());
            this.forward(request, responseHandler);
            return dataSink;
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader) throws IOException, ConnectException, IllegalStateException {
            InMemoryBodyDataSink dataSink = new InMemoryBodyDataSink(this.handler.toString(), requestHeader);
            HttpRequest request = new HttpRequest(requestHeader, dataSink.getDataSource());
            this.forward(request, this.responseHandler);
            return dataSink;
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException, IllegalStateException {
            InMemoryBodyDataSink dataSink = new InMemoryBodyDataSink(this.handler.toString(), requestHeader);
            HttpRequest request = new HttpRequest(requestHeader, dataSink.getDataSource());
            this.forward(request, responseHandler);
            return dataSink;
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength) throws IOException, ConnectException, IllegalStateException {
            InMemoryBodyDataSink dataSink = new InMemoryBodyDataSink(this.handler.toString(), requestHeader);
            HttpRequest request = new HttpRequest(requestHeader, dataSink.getDataSource());
            this.forward(request, this.responseHandler);
            return dataSink;
        }

        private final class BodyListener
        implements IBodyCompleteListener,
        IBodyDestroyListener {
            private BodyListener() {
            }

            @Override
            @Execution(value=1)
            public void onComplete() throws IOException {
                ChainExchange.this.handler.onRequest(ChainExchange.this);
            }

            @Override
            public void onDestroyed() throws IOException {
                ChainExchange.this.rootExchange.destroy();
            }
        }

        @Supports100Continue
        private final class DefaultResponseHandler
        implements IHttpResponseHandler {
            private DefaultResponseHandler() {
            }

            @Override
            public void onResponse(IHttpResponse response) throws IOException {
                ChainExchange.this.rootExchange.send(response);
            }

            @Override
            public void onException(IOException ioe) throws IOException {
                ChainExchange.this.rootExchange.sendError(ioe);
            }
        }
    }

    private static final class HttpResponseHandlerAdapter
    implements IHttpResponseHandler,
    IUnsynchronized {
        private IHttpExchange exchange = null;

        public HttpResponseHandlerAdapter(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public void onResponse(IHttpResponse response) throws IOException {
            this.exchange.send(response);
        }

        @Override
        public void onException(IOException ioe) {
            this.exchange.sendError(ioe);
        }
    }
}

