/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkBodyDataSource;
import org.xlightweb.HttpMessageHeader;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.ProtocolException;

final class SimpleMessageBodyDataSource
extends AbstractNetworkBodyDataSource {
    private static final Logger LOG = Logger.getLogger(SimpleMessageBodyDataSource.class.getName());
    private TimerTask watchdog = null;

    public SimpleMessageBodyDataSource(HttpMessageHeader header, AbstractHttpConnection httpConnection) throws IOException {
        super(header, httpConnection);
        this.postCreate();
    }

    @Override
    void doParse(ByteBuffer[] rawData) throws IOException {
        ByteBuffer[] duplicated = new ByteBuffer[rawData.length];
        int i = 0;
        while (i < rawData.length) {
            duplicated[i] = rawData[i].duplicate();
            rawData[i].position(rawData[i].limit());
            ++i;
        }
        this.onReadNetworkData(duplicated);
    }

    @Override
    void onClose() throws IOException {
        if (this.watchdog != null) {
            this.watchdog.cancel();
        }
        throw new ProtocolException("connection has been closed (by user?) while receiving body data", this.getHeader());
    }

    @Override
    void onDestroy(String reason) {
        block2: {
            try {
                this.performOnDisconnect();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by performing on disconnect " + ioe.toString());
            }
        }
        super.onDestroy(reason);
    }

    @Override
    void performOnDisconnect() throws IOException {
        if (this.watchdog != null) {
            this.watchdog.cancel();
        }
        this.setNonPersistent();
        this.setComplete();
    }

    @Override
    void setDataHandlerSilence(IBodyDataHandler bodyDataHandler) {
        super.setDataHandlerSilence(bodyDataHandler);
        this.callBodyDataHandler(true);
    }
}

