/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xlightweb.IWriteCompleteHandler;
import org.xlightweb.WebSocketConnection;
import org.xlightweb.WebSocketMessage;
import org.xlightweb.WebSocketMessageCompleteHandlerAdapter;
import org.xsocket.DataConverter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

public final class TextMessage
extends WebSocketMessage {
    private static final byte START_BYTE_TEXTFRAME = 0;
    private static final byte END_BYTE = -1;

    public TextMessage(String msg) {
        this(DataConverter.toByteBuffer(msg, "utf-8"));
    }

    TextMessage(ByteBuffer msg) {
        super(msg, "utf-8");
    }

    @Override
    public boolean isTextMessage() {
        return true;
    }

    @Override
    int writeTo(WebSocketConnection connection, IWriteCompleteHandler completeHandler) throws IOException {
        int written;
        if (completeHandler == null) {
            connection.getUnderlyingTcpConnection().setFlushmode(IConnection.FlushMode.SYNC);
        } else {
            connection.getUnderlyingTcpConnection().setFlushmode(IConnection.FlushMode.ASYNC);
        }
        byte[] msgData = this.getData().toBytes();
        ByteBuffer frameBuf = null;
        if (msgData.length <= 125) {
            frameBuf = ByteBuffer.allocate(2 + msgData.length);
            frameBuf.put((byte)-127);
            frameBuf.put((byte)msgData.length);
        } else if (msgData.length <= 65535) {
            frameBuf = ByteBuffer.allocate(4 + msgData.length);
            frameBuf.put((byte)-127);
            frameBuf.put((byte)126);
            frameBuf.putShort((short)msgData.length);
        } else {
            frameBuf = ByteBuffer.allocate(10 + msgData.length);
            frameBuf.put((byte)-127);
            frameBuf.put((byte)127);
            frameBuf.putLong(msgData.length);
        }
        frameBuf.put(msgData);
        if (completeHandler == null) {
            written = connection.getUnderlyingTcpConnection().write(frameBuf.array());
        } else {
            written = frameBuf.capacity();
            connection.getUnderlyingTcpConnection().write(frameBuf.array(), (IWriteCompletionHandler)new WebSocketMessageCompleteHandlerAdapter(connection, completeHandler));
        }
        connection.getUnderlyingTcpConnection().flush();
        frameBuf = null;
        return written;
    }

    static TextMessage parse(ByteBuffer buffer) throws IOException {
        int msgLen;
        int savePos = buffer.position();
        int saveLimit = buffer.limit();
        byte frameByte1 = buffer.get();
        boolean isMsgMasked = (frameByte1 & 0x80) != 0;
        byte[] mask = null;
        if (isMsgMasked) {
            mask = new byte[4];
            buffer.get(mask);
        }
        if ((msgLen = frameByte1 & 0x7F) == 126) {
            msgLen = buffer.getShort();
        } else if (msgLen == 127) {
            long msgLen_ = buffer.getLong();
            if (msgLen_ > Integer.MAX_VALUE) {
                throw new IOException("message length too long:" + msgLen_);
            }
            msgLen = (int)msgLen_;
        } else if (msgLen < 0 || msgLen > 127) {
            throw new IOException("invalid message length:" + msgLen);
        }
        if (buffer.remaining() < msgLen) {
            buffer.position(savePos);
            buffer.limit(saveLimit);
            return null;
        }
        ByteBuffer msgBuf = null;
        msgBuf = buffer.slice();
        msgBuf.limit(msgLen);
        if (isMsgMasked) {
            int i = 0;
            int l = msgBuf.limit();
            byte dat = 0;
            while (i < l) {
                dat = msgBuf.get(i);
                msgBuf.put(i, (byte)(dat ^ mask[i % 4]));
                ++i;
            }
        }
        buffer.position(buffer.limit());
        return new TextMessage(msgBuf);
    }

    static boolean isTextMessage(byte startByte) {
        return (startByte & 0xF) == 1;
    }

    static /* bridge */ /* synthetic */ WebSocketMessage parse(ByteBuffer byteBuffer) throws IOException {
        return TextMessage.parse(byteBuffer);
    }
}

