/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.CloseMessage;
import org.xlightweb.GetRequest;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IWebSocketConnection;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.IWriteCompleteHandler;
import org.xlightweb.TextMessage;
import org.xlightweb.UnsupportedProtocolException;
import org.xlightweb.WebSocketHandlerAdapter;
import org.xlightweb.WebSocketMessage;
import org.xlightweb.client.HttpClientConnection;
import org.xlightweb.client.IHttpClientEndpoint;
import org.xlightweb.server.HttpServerConnection;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.NonBlockingConnectionPool;

public final class WebSocketConnection
implements IWebSocketConnection {
    private static final Logger LOG = Logger.getLogger(WebSocketConnection.class.getName());
    private INonBlockingConnection tcpConnection;
    private static final Random RANDOM = new Random();
    public static final int DEFAULT_RECEIVE_TIMEOUT = Integer.MAX_VALUE;
    private int receiveTimeoutSec = Integer.MAX_VALUE;
    private final WebSocketProtocolHandler protocolHandler = new WebSocketProtocolHandler();
    private final AbstractHttpConnection.IMultimodeExecutor executor;
    private final List<WebSocketMessage> inQueue = new ArrayList<WebSocketMessage>();
    private int inQueueVersion = 0;
    private static final boolean CLIENT_USING_SEC_KEY = Boolean.parseBoolean(System.getProperty("org.xlightweb.websocket.client.usingSecKey", "true"));
    private final IHttpRequestHeader upgradeRequestHeader;
    private final IHttpResponseHeader upgradeResponseHeader;
    private final IPostWriteInterceptor interceptor;
    private final Object webSocketHandlerGuard = new Object();
    private WebSocketHandlerAdapter webSocketHandlerAdapter = null;
    private final AtomicReference<IOException> exceptionRef = new AtomicReference<Object>(null);
    private final AtomicBoolean isDisconnected = new AtomicBoolean(false);
    private final AtomicBoolean isCloseMsgSent = new AtomicBoolean(false);
    private AtomicReference<Object> attachmentRef = new AtomicReference<Object>(null);

    public WebSocketConnection(String uriString) throws IOException {
        this(uriString, (String)null);
    }

    public WebSocketConnection(String uriString, String protocol) throws IOException {
        this(uriString, protocol, null);
    }

    public WebSocketConnection(String uriString, IWebSocketHandler webSocketHandler) throws IOException {
        this(uriString, null, webSocketHandler);
    }

    public WebSocketConnection(String uriString, String protocol, IWebSocketHandler webSocketHandler) throws IOException {
        this(URI.create(uriString), protocol, webSocketHandler);
    }

    private WebSocketConnection(URI uri, String protocol, IWebSocketHandler webSocketHandler) throws IOException {
        this((IHttpClientEndpoint)WebSocketConnection.connect(uri), uri, protocol, webSocketHandler);
    }

    private static HttpClientConnection connect(URI uri) throws IOException {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().toLowerCase(Locale.US).equals("wss") ? 443 : 80;
        }
        return new HttpClientConnection(uri.getHost(), port);
    }

    public WebSocketConnection(IHttpClientEndpoint httpClientEndpoint, URI uri, String protocol, IWebSocketHandler webSocketHandler) throws IOException {
        this(WebSocketConnection.performHandshake(httpClientEndpoint, uri, protocol), webSocketHandler);
    }

    private WebSocketConnection(HandeshakeResult handeshakeResult, IWebSocketHandler webSocketHandler) throws IOException {
        this(handeshakeResult.con, webSocketHandler, handeshakeResult.upgradeRequestHeader, handeshakeResult.upgradeResponseHeader);
    }

    private WebSocketConnection(HttpClientConnection httpConnection, IWebSocketHandler webSocketHandler, IHttpRequestHeader upgradeRequestHeader, IHttpResponseHeader upgradeResponseHeader) throws IOException {
        this(WebSocketConnection.convertToTcpConnection(httpConnection), null, webSocketHandler, null, upgradeRequestHeader, upgradeResponseHeader);
    }

    private static HandeshakeResult performHandshake(IHttpClientEndpoint httpClientEndpoint, URI uri, String protocol) throws IOException {
        GetRequest request;
        byte[] challengeMd5 = null;
        if (CLIENT_USING_SEC_KEY) {
            ByteBuffer buf = ByteBuffer.allocate(16);
            int i = 0;
            while (i < buf.limit()) {
                buf.put((byte)(33 + RANDOM.nextInt(80)));
                ++i;
            }
            buf.flip();
            long key1 = buf.getInt();
            long key2 = buf.getInt();
            long challenge = buf.getLong();
            challengeMd5 = WebSocketConnection.computeMD5((int)key1, (int)key2, challenge);
            int numSpaces1 = 10 + RANDOM.nextInt(Integer.MAX_VALUE) % 5;
            int numSpaces2 = 10 + RANDOM.nextInt(Integer.MAX_VALUE) % 5;
            String secKey1 = new String(WebSocketConnection.generateSecKey(35, key1 * (long)numSpaces1, numSpaces1));
            String secKey2 = new String(WebSocketConnection.generateSecKey(34, key2 * (long)numSpaces2, numSpaces2));
            request = new GetRequest(uri.toString(), DataConverter.toByteBuffer(challenge).array());
            request.removeHeader("Content-Length");
            request.setHeader("Sec-WebSocket-Key1", secKey1);
            request.setHeader("Sec-WebSocket-Key2", secKey2);
        } else {
            request = new GetRequest(uri.toString());
        }
        if (protocol != null) {
            if (CLIENT_USING_SEC_KEY) {
                request.setHeader("Sec-WebSocket-Protocol", protocol);
            } else {
                request.setHeader("WebSocket-Protocol", protocol);
            }
        }
        request.setHeader("Upgrade", "WebSocket");
        request.setHeader("Connection", "Upgrade");
        URL originURL = request.getRequestUrl();
        String origin = String.valueOf(originURL.getProtocol()) + "//" + originURL.getHost();
        if (originURL.getPort() != -1) {
            origin = String.valueOf(origin) + ":" + originURL.getPort();
        }
        request.setHeader("Origin", origin);
        IHttpResponse response = httpClientEndpoint.call(request);
        if (response.getStatus() != 101) {
            if (response.getStatus() == 501) {
                if (response.hasBody()) {
                    throw new UnsupportedProtocolException(response.getBody().toString());
                }
                throw new UnsupportedProtocolException();
            }
            throw new IOException(String.valueOf(response.getStatus()) + " " + response.getReason());
        }
        if (challengeMd5 != null) {
            boolean match = true;
            byte[] challengeMd5Response = response.getBody().readBytesByLength(16);
            int i = 0;
            while (i < challengeMd5.length) {
                if (challengeMd5[i] != challengeMd5Response[i]) {
                    match = false;
                }
                ++i;
            }
            if (!match) {
                throw new IOException("server returns wrong md5");
            }
        }
        HttpClientConnection httpCon = (HttpClientConnection)HttpUtils.getConnectionFromAttribute(response.getResponseHeader());
        return new HandeshakeResult(httpCon, request.getRequestHeader(), response.getResponseHeader());
    }

    private static byte[] generateSecKey(int length, long key, int numSpaces) {
        byte[] data;
        byte[] num;
        int numIdx;
        do {
            num = Long.toString(key).getBytes();
            numIdx = 0;
            data = new byte[length];
            int i = 0;
            while (i < data.length) {
                boolean isPrintNum;
                boolean bl = isPrintNum = RANDOM.nextInt(length / num.length) % 2 == 1;
                if (isPrintNum && numIdx < num.length) {
                    data[i] = num[numIdx];
                    ++numIdx;
                } else {
                    data[i] = (byte)(33 + RANDOM.nextInt(15));
                }
                ++i;
            }
            int spacesIdx = 0;
            while (spacesIdx < numSpaces) {
                int idx = 1 + RANDOM.nextInt(length - 3);
                if (data[idx] == 32 || data[idx] >= 48 && data[idx] <= 57) continue;
                data[idx] = 32;
                ++spacesIdx;
            }
        } while (numIdx != num.length);
        return data;
    }

    private static byte[] computeMD5(int key1, int key2, long num) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putInt(key1);
        buf.putInt(key2);
        buf.putLong(num);
        buf.flip();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(buf.array());
            return md5.digest();
        }
        catch (NoSuchAlgorithmException nse) {
            throw new IOException(nse.toString());
        }
    }

    public WebSocketConnection(HttpServerConnection httpConnection, IWebSocketHandler webSocketHandler, IHttpExchange exchange) throws IOException {
        this(httpConnection, webSocketHandler, new UpgradeResponseSender(exchange));
    }

    private WebSocketConnection(HttpServerConnection httpConnection, IWebSocketHandler webSocketHandler, UpgradeResponseSender upgradeHandler) throws IOException {
        this(httpConnection, webSocketHandler, upgradeHandler.getRequestHeader(), upgradeHandler.getResponseHeader(), upgradeHandler);
    }

    private static INonBlockingConnection convertToTcpConnection(AbstractHttpConnection httpConnection) throws IOException {
        INonBlockingConnection tcpCon = httpConnection.getUnderlyingTcpConnection();
        tcpCon.setHandler(null);
        return tcpCon;
    }

    private WebSocketConnection(HttpServerConnection httpConnection, IWebSocketHandler webSocketHandler, IHttpRequestHeader upgradeRequestHeader, IHttpResponseHeader upgradeResponseHeader, UpgradeResponseSender upgradeResponseSender) throws IOException {
        this(WebSocketConnection.convertToTcpConnection(httpConnection), upgradeResponseSender, webSocketHandler, upgradeResponseSender, upgradeRequestHeader, upgradeResponseHeader);
    }

    private static int computeNumSpaces(String key) {
        int numSpaces = 0;
        byte[] byArray = key.getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b == 32) {
                ++numSpaces;
            }
            ++n2;
        }
        return numSpaces;
    }

    private static long extractNumber(byte[] key) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = key;
        int n = key.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b >= 48 && b <= 57) {
                sb.append((char)b);
            }
            ++n2;
        }
        return Long.parseLong(sb.toString());
    }

    private WebSocketConnection(INonBlockingConnection tcpConnection, IPostWriteInterceptor connectInterceptor, IWebSocketHandler webSocketHandler, WebSocketHandlerAdapter.IPostConnectInterceptor postConnectInterceptor, IHttpRequestHeader upgradeRequestHeader, IHttpResponseHeader upgradeResponseHeader) throws IOException {
        this.interceptor = connectInterceptor;
        this.tcpConnection = tcpConnection;
        this.upgradeRequestHeader = upgradeRequestHeader;
        this.upgradeResponseHeader = upgradeResponseHeader;
        this.executor = HttpUtils.newMultimodeExecutor(tcpConnection.getWorkerpool());
        this.setMessageHandler(webSocketHandler, postConnectInterceptor);
        this.protocolHandler.onConnect(tcpConnection);
        tcpConnection.setHandler(this.protocolHandler);
    }

    @Override
    public String getProtocol() {
        return this.getUpgradeResponseHeader().getHeader("WebSocket-Protocol");
    }

    @Override
    public String getWebSocketLocation() {
        return this.getUpgradeResponseHeader().getHeader("WebSocket-Location");
    }

    @Override
    public String getWebSocketOrigin() {
        return this.getUpgradeResponseHeader().getHeader("WebSocket-Origin");
    }

    @Override
    public IHttpRequestHeader getUpgradeRequestHeader() {
        return this.upgradeRequestHeader;
    }

    @Override
    public IHttpResponseHeader getUpgradeResponseHeader() {
        return this.upgradeResponseHeader;
    }

    @Override
    public void destroy() {
        block2: {
            try {
                NonBlockingConnectionPool.destroy(this.tcpConnection);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("[" + this.getId() + "] error occured by destroying htttp connection " + this.getId() + " " + ioe.toString());
            }
        }
    }

    public INonBlockingConnection getUnderlyingTcpConnection() {
        return this.tcpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int availableMessages() {
        List<WebSocketMessage> list = this.inQueue;
        synchronized (list) {
            return this.inQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInQueueVersion() {
        List<WebSocketMessage> list = this.inQueue;
        synchronized (list) {
            return this.inQueueVersion;
        }
    }

    public String toString() {
        return this.tcpConnection.toString();
    }

    @Override
    public TextMessage readTextMessage() throws IOException, SocketTimeoutException {
        WebSocketMessage msg = this.readMessage();
        if (msg.isTextMessage()) {
            return (TextMessage)msg;
        }
        throw new IOException("got a " + msg.getClass().getSimpleName() + " message");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketMessage readMessage() throws BufferUnderflowException, SocketTimeoutException, ClosedChannelException, IOException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            List<WebSocketMessage> list = this.inQueue;
            synchronized (list) {
                IOException ioe = this.exceptionRef.getAndSet(null);
                if (ioe != null) {
                    throw ioe;
                }
                if (this.isDisconnected.get()) {
                    throw new ClosedChannelException();
                }
                if (this.inQueue.isEmpty()) {
                    try {
                        this.inQueue.wait(remainingTime);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    ++this.inQueueVersion;
                    return this.inQueue.remove(0);
                }
            }
        } while ((remainingTime = HttpUtils.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    @Override
    public int writeMessage(TextMessage msg) throws IOException {
        return this.writeMessage((WebSocketMessage)msg);
    }

    @Override
    public int writeMessage(WebSocketMessage msg) throws IOException {
        if (this.isCloseMsgSent.get()) {
            throw new ClosedChannelException();
        }
        return this.writeMessageIgnoreClose(msg);
    }

    @Override
    public void writeMessage(TextMessage msg, IWriteCompleteHandler completeHandler) throws IOException {
        this.writeMessage((WebSocketMessage)msg, completeHandler);
    }

    private int writeMessageIgnoreClose(WebSocketMessage msg) throws IOException {
        if (this.interceptor != null) {
            this.interceptor.onPreWrite();
        }
        return msg.writeTo(this, null);
    }

    @Override
    public void writeMessage(WebSocketMessage msg, IWriteCompleteHandler writtenHandler) throws IOException {
        if (this.isCloseMsgSent.get()) {
            throw new ClosedChannelException();
        }
        if (this.interceptor != null) {
            this.interceptor.onPreWrite();
        }
        msg.writeTo(this, writtenHandler);
    }

    @Override
    public void closeQuitly() {
        block5: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by closing connection " + this.getId() + " " + ioe.toString());
                }
                try {
                    NonBlockingConnectionPool.destroy(this.tcpConnection);
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("[" + this.getId() + "] error occured by closing connection " + this.getId() + " " + e.toString());
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isCloseMsgSent.getAndSet(true)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] sending close message");
            }
            this.writeMessageIgnoreClose(new CloseMessage());
        }
    }

    void processNonthreaded(Runnable task) {
        this.executor.processNonthreaded(task);
    }

    void processMultithreaded(Runnable task) {
        this.executor.processMultithreaded(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMessageHandler(IWebSocketHandler webSocketHandler, WebSocketHandlerAdapter.IPostConnectInterceptor postConnectInterceptor) throws IOException {
        Object object = this.webSocketHandlerGuard;
        synchronized (object) {
            if (this.webSocketHandlerAdapter != null) {
                this.webSocketHandlerAdapter.onDisconnect(this);
            }
            this.webSocketHandlerAdapter = new WebSocketHandlerAdapter(webSocketHandler, postConnectInterceptor);
            this.webSocketHandlerAdapter.onConnect(this);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.isCloseMsgSent.get() && this.tcpConnection.isOpen();
    }

    @Override
    public boolean isServerSide() {
        return this.tcpConnection.isServerSide();
    }

    public INonBlockingConnection getTcpConnection() {
        return this.tcpConnection;
    }

    @Override
    public void setAttachment(Object obj) {
        this.attachmentRef.set(obj);
    }

    @Override
    public Object getAttachment() {
        return this.attachmentRef.get();
    }

    @Override
    public long getConnectionTimeoutMillis() {
        return this.tcpConnection.getConnectionTimeoutMillis();
    }

    @Override
    public void setConnectionTimeoutMillis(long timeoutMillis) {
        this.tcpConnection.setConnectionTimeoutMillis(timeoutMillis);
    }

    @Override
    public long getRemainingMillisToConnectionTimeout() {
        return this.tcpConnection.getRemainingMillisToConnectionTimeout();
    }

    @Override
    public long getIdleTimeoutMillis() {
        return this.tcpConnection.getIdleTimeoutMillis();
    }

    @Override
    public void setIdleTimeoutMillis(long timeoutInMillis) {
        this.tcpConnection.setIdleTimeoutMillis(timeoutInMillis);
    }

    @Override
    public long getRemainingMillisToIdleTimeout() {
        return this.tcpConnection.getRemainingMillisToIdleTimeout();
    }

    @Override
    public String getId() {
        return this.tcpConnection.getId();
    }

    @Override
    public int getLocalPort() {
        return this.tcpConnection.getLocalPort();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.tcpConnection.getLocalAddress();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.tcpConnection.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.tcpConnection.getRemotePort();
    }

    @Override
    public Object getOption(String name) throws IOException {
        return this.tcpConnection.getOption(name);
    }

    @Override
    public Map<String, Class> getOptions() {
        return this.tcpConnection.getOptions();
    }

    @Override
    public void setOption(String name, Object value) throws IOException {
        this.tcpConnection.setOption(name, value);
    }

    private static final class HandeshakeResult {
        private HttpClientConnection con;
        private IHttpRequestHeader upgradeRequestHeader;
        private IHttpResponseHeader upgradeResponseHeader;

        public HandeshakeResult(HttpClientConnection con, IHttpRequestHeader upgradeRequestHeader, IHttpResponseHeader upgradeResponseHeader) {
            this.con = con;
            this.upgradeRequestHeader = upgradeRequestHeader;
            this.upgradeResponseHeader = upgradeResponseHeader;
        }
    }

    private static interface IPostWriteInterceptor {
        public void onPreWrite() throws IOException;
    }

    private static final class UpgradeResponseSender
    implements WebSocketHandlerAdapter.IPostConnectInterceptor,
    IPostWriteInterceptor {
        private final IHttpExchange exchange;
        private final AtomicBoolean isUpgradeSent = new AtomicBoolean(false);
        private final byte[] md5;
        private final IHttpResponseHeader responseHeader;

        public UpgradeResponseSender(IHttpExchange exchange) throws IOException {
            this.exchange = exchange;
            IHttpRequest request = exchange.getRequest();
            String webSocketLocation = request.isSecure() ? "wss://" + request.getHost() + request.getRequestURI() : "ws://" + request.getHost() + request.getRequestURI();
            if (request.getHeader("Sec-WebSocket-Key1") != null) {
                String protocol = request.getHeader("Sec-WebSocket-Protocol");
                String webSocketOrigin = request.getHeader("Origin");
                String secKey1 = request.getHeader("Sec-WebSocket-Key1");
                long obfuscatedKey1 = WebSocketConnection.extractNumber(secKey1.getBytes());
                int numSpacesKey1 = WebSocketConnection.computeNumSpaces(secKey1);
                int key1 = (int)(obfuscatedKey1 / (long)numSpacesKey1);
                String secKey2 = request.getHeader("Sec-WebSocket-Key2");
                long obfuscatedKey2 = WebSocketConnection.extractNumber(secKey2.getBytes());
                int numSpacesKey2 = WebSocketConnection.computeNumSpaces(secKey2);
                int key2 = (int)(obfuscatedKey2 / (long)numSpacesKey2);
                long challenge = request.getBody().readLong();
                this.md5 = WebSocketConnection.computeMD5(key1, key2, challenge);
                this.responseHeader = new HttpResponseHeader(101);
                this.responseHeader.setReason("Web Socket Protocol Handshake");
                this.responseHeader.setHeader("Upgrade", "WebSocket");
                this.responseHeader.setHeader("Connection", "Upgrade");
                this.responseHeader.setHeader("Sec-WebSocket-Origin", webSocketOrigin);
                this.responseHeader.setHeader("Sec-WebSocket-Location", webSocketLocation);
                if (protocol != null) {
                    this.responseHeader.setHeader("Sec-WebSocket-Protocol", protocol);
                }
            } else {
                this.md5 = null;
                String protocol = request.getHeader("WebSocket-Protocol");
                String webSocketOrigin = request.getHeader("Origin");
                this.responseHeader = new HttpResponseHeader(101);
                this.responseHeader.setReason("Web Socket Protocol Handshake");
                this.responseHeader.setHeader("Upgrade", "WebSocket");
                this.responseHeader.setHeader("Connection", "Upgrade");
                this.responseHeader.setHeader("WebSocket-Origin", webSocketOrigin);
                this.responseHeader.setHeader("WebSocket-Location", webSocketLocation);
                if (protocol != null) {
                    this.responseHeader.setHeader("WebSocket-Protocol", protocol);
                }
            }
        }

        @Override
        public void onConnectException(IOException ioe) {
            if (ioe instanceof UnsupportedProtocolException) {
                this.exchange.sendError(501, ioe.getMessage());
            } else {
                this.exchange.sendError(501);
            }
        }

        @Override
        public void onPostConnect() throws IOException {
            this.sentUpgradeIfNecessary();
        }

        @Override
        public void onPreWrite() throws IOException {
            this.sentUpgradeIfNecessary();
        }

        private void sentUpgradeIfNecessary() throws IOException {
            if (!this.isUpgradeSent.getAndSet(true)) {
                HttpResponse response;
                if (this.md5 == null) {
                    response = new HttpResponse(this.responseHeader);
                } else {
                    response = new HttpResponse(this.responseHeader, DataConverter.toByteBuffer(this.md5).array());
                    response.removeHeader("Content-Length");
                }
                this.exchange.send(response);
            }
        }

        IHttpRequestHeader getRequestHeader() {
            return this.exchange.getRequest().getRequestHeader();
        }

        IHttpResponseHeader getResponseHeader() {
            return this.responseHeader;
        }
    }

    @Execution(value=0)
    private final class WebSocketProtocolHandler
    implements IConnectHandler,
    IDataHandler,
    IDisconnectHandler {
        private ByteBuffer rawBuffer = null;

        private WebSocketProtocolHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            Object object = WebSocketConnection.this.webSocketHandlerGuard;
            synchronized (object) {
                if (WebSocketConnection.this.webSocketHandlerAdapter != null) {
                    WebSocketConnection.this.webSocketHandlerAdapter.onConnect(WebSocketConnection.this);
                }
            }
            return true;
        }

        @Override
        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, ClosedChannelException, MaxReadSizeExceededException {
            if (connection.isOpen()) {
                int available = connection.available();
                ByteBuffer[] data = null;
                if (available > 0) {
                    data = connection.readByteBufferByLength(available);
                }
                this.onData(data);
            }
            return true;
        }

        void onData(ByteBuffer[] data) throws IOException {
            if (data == null) {
                if (this.rawBuffer == null) {
                    this.rawBuffer = ByteBuffer.allocate(0);
                }
            } else {
                this.rawBuffer = this.rawBuffer == null ? HttpUtils.merge(data) : HttpUtils.merge(this.rawBuffer, data);
            }
            this.parse(this.rawBuffer);
            if (!this.rawBuffer.hasRemaining()) {
                this.rawBuffer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void parse(ByteBuffer buffer) throws IOException {
            while (buffer.hasRemaining()) {
                WebSocketMessage msg = WebSocketMessage.parse(buffer);
                if (msg == null) {
                    return;
                }
                if (msg.isTextMessage()) {
                    Object object = WebSocketConnection.this.inQueue;
                    synchronized (object) {
                        WebSocketConnection webSocketConnection = WebSocketConnection.this;
                        webSocketConnection.inQueueVersion = webSocketConnection.inQueueVersion + 1;
                        WebSocketConnection.this.inQueue.add(msg);
                        WebSocketConnection.this.inQueue.notifyAll();
                    }
                    object = WebSocketConnection.this.webSocketHandlerGuard;
                    synchronized (object) {
                        if (WebSocketConnection.this.webSocketHandlerAdapter != null) {
                            WebSocketConnection.this.webSocketHandlerAdapter.onMessage(WebSocketConnection.this);
                        }
                        continue;
                    }
                }
                if (msg.isCloseMessage()) {
                    if (WebSocketConnection.this.isCloseMsgSent.get()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + WebSocketConnection.this.getId() + "] echo close msg reveived. Destroying connection");
                        }
                        WebSocketConnection.this.writeMessageIgnoreClose(msg);
                        WebSocketConnection.this.destroy();
                        continue;
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + WebSocketConnection.this.getId() + "] close msg reveived. echoing it and destroying connection");
                    }
                    WebSocketConnection.this.isCloseMsgSent.set(true);
                    WebSocketConnection.this.writeMessageIgnoreClose(msg);
                    WebSocketConnection.this.destroy();
                    continue;
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("[" + WebSocketConnection.this.getId() + "] binary message received. The ws draft does not longer allow binary messages. Ignoring it");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            Object object = WebSocketConnection.this.inQueue;
            synchronized (object) {
                WebSocketConnection.this.isDisconnected.set(true);
                if (this.rawBuffer != null && this.rawBuffer.hasRemaining()) {
                    WebSocketConnection.this.exceptionRef.set(new IOException("connection terminated while receiving data"));
                }
                WebSocketConnection.this.inQueue.notifyAll();
            }
            object = WebSocketConnection.this.webSocketHandlerGuard;
            synchronized (object) {
                if (WebSocketConnection.this.webSocketHandlerAdapter != null) {
                    WebSocketConnection.this.webSocketHandlerAdapter.onDisconnect(WebSocketConnection.this);
                }
            }
            return true;
        }
    }
}

