/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import org.xlightweb.HttpUtils;
import org.xlightweb.IUnsynchronized;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.WebSocketConnection;

final class WebSocketHandlerInfo {
    private final boolean isUnsynchronized;
    private final boolean isOnConnectMultithreaded;
    private final boolean isOnMessageMultithreaded;
    private final boolean isOnDisconnectMultithreaded;

    WebSocketHandlerInfo(Class clazz) {
        if (clazz != null && IWebSocketHandler.class.isAssignableFrom(clazz)) {
            boolean isMultiThreaded = HttpUtils.isHandlerMultithreaded(clazz, true);
            this.isUnsynchronized = IUnsynchronized.class.isAssignableFrom(clazz);
            this.isOnConnectMultithreaded = HttpUtils.isMethodMultithreaded(clazz, "onConnect", isMultiThreaded, WebSocketConnection.class);
            this.isOnDisconnectMultithreaded = HttpUtils.isMethodMultithreaded(clazz, "onDisconnect", isMultiThreaded, WebSocketConnection.class);
            this.isOnMessageMultithreaded = HttpUtils.isMethodMultithreaded(clazz, "onMessage", isMultiThreaded, WebSocketConnection.class);
        } else {
            this.isUnsynchronized = true;
            this.isOnConnectMultithreaded = false;
            this.isOnDisconnectMultithreaded = false;
            this.isOnMessageMultithreaded = false;
        }
    }

    public boolean isOnConnectMultithreaded() {
        return this.isOnConnectMultithreaded;
    }

    public boolean isOnMessageMultithreaded() {
        return this.isOnMessageMultithreaded;
    }

    public boolean isOnDisconnectMultithreaded() {
        return this.isOnDisconnectMultithreaded;
    }

    public boolean isUnsynchronized() {
        return this.isUnsynchronized;
    }
}

