/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.client.Cookie;
import org.xlightweb.client.InMemoryCookieStore;

final class CookieManager
implements Closeable {
    private static final Logger LOG = Logger.getLogger(CookieManager.class.getName());
    private final InMemoryCookieStore cookieStore = new InMemoryCookieStore();

    CookieManager() {
    }

    @Override
    public void close() throws IOException {
        this.cookieStore.close();
    }

    public Map<String, List<String>> get(URI uri) throws IOException {
        HashMap result = new HashMap();
        String path = uri.getPath();
        if (path == null || path.length() == 0) {
            path = "/";
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (Cookie cookie : this.cookieStore.get(uri)) {
            if (!this.matches(path, cookie.getPath()) || !"https".equalsIgnoreCase(uri.getScheme()) && cookie.getSecure()) continue;
            String ports = cookie.getPortlist();
            if (ports != null && ports.length() > 0) {
                int port = uri.getPort();
                if (port == -1) {
                    int n = port = "https".equals(uri.getScheme()) ? 443 : 80;
                }
                if (!this.isInList(ports, port)) continue;
                cookies.add(cookie);
                continue;
            }
            cookies.add(cookie);
        }
        Collections.sort(cookies, new CookiePathComparator());
        ArrayList<String> cookieHeader = new ArrayList<String>();
        for (Cookie cookie : cookies) {
            if (cookies.indexOf(cookie) == 0 && cookie.getVersion() > 0) {
                cookieHeader.add("$Version=\"1\"");
            }
            cookieHeader.add(cookie.toString());
        }
        result.put("Cookie", cookieHeader);
        return Collections.unmodifiableMap(result);
    }

    private boolean matches(String path, String pathToMatchWith) {
        if (path == null || pathToMatchWith == null) {
            return false;
        }
        return path.startsWith(pathToMatchWith);
    }

    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().equalsIgnoreCase("Set-Cookie2") && !entry.getKey().equalsIgnoreCase("Set-Cookie")) continue;
            for (String headerValue : entry.getValue()) {
                try {
                    for (Cookie cookie : Cookie.parse(headerValue)) {
                        String ports;
                        if (cookie.getPath() == null) {
                            String path = uri.getPath();
                            if (!path.endsWith("/")) {
                                int i = path.lastIndexOf("/");
                                path = i > 0 ? path.substring(0, i + 1) : "/";
                            }
                            cookie.setPath(path);
                        }
                        if ((ports = cookie.getPortlist()) != null) {
                            int port = uri.getPort();
                            if (port == -1) {
                                int n = port = "https".equals(uri.getScheme()) ? 443 : 80;
                            }
                            if (ports.length() == 0) {
                                cookie.setPortlist("" + port);
                                this.cookieStore.add(uri, cookie);
                                continue;
                            }
                            if (!this.isInList(ports, port)) continue;
                            this.cookieStore.add(uri, cookie);
                            continue;
                        }
                        this.cookieStore.add(uri, cookie);
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("error occured by parsing cooke " + iae.toString());
                }
            }
        }
    }

    private boolean isInList(String ports, int port) {
        String[] stringArray = ports.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                String p = stringArray[n2];
                try {
                    if (Integer.parseInt(p.trim()) == port) {
                        return true;
                    }
                }
                catch (NumberFormatException nfe) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("error occured by parsing list " + nfe.toString());
                }
            }
            ++n2;
        }
        return false;
    }

    private static class CookiePathComparator
    implements Comparator<Cookie>,
    Serializable {
        private static final long serialVersionUID = -9015607124598271806L;

        private CookiePathComparator() {
        }

        @Override
        public int compare(Cookie c1, Cookie c2) {
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            if (!c1.getName().equals(c2.getName())) {
                return 0;
            }
            if (c1.getPath().startsWith(c2.getPath())) {
                return -1;
            }
            if (c2.getPath().startsWith(c1.getPath())) {
                return 1;
            }
            return 0;
        }
    }
}

