/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.Closeable;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BodyDataSink;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.client.HttpClientConnection;

final class DuplicatingBodyForwarder
implements IBodyDataHandler {
    private static final Logger LOG = Logger.getLogger(DuplicatingBodyForwarder.class.getName());
    private static final ByteBuffer NULL_BYTE_BUFFER = ByteBuffer.allocate(0);
    private final NonBlockingBodyDataSource bodyDataSource;
    private final ISink primarySink;
    private final AtomicBoolean isPrimarySinkClosed = new AtomicBoolean(false);
    private final ISink secondarySink;
    private final AtomicBoolean isSecondarySinkClosed = new AtomicBoolean(false);

    public DuplicatingBodyForwarder(NonBlockingBodyDataSource bodyDataSource, ISink primarySink, ISink secondarySink) {
        this.bodyDataSource = bodyDataSource;
        this.primarySink = primarySink;
        this.secondarySink = secondarySink;
        IBodyDestroyListener destroyListenerPrimary = new IBodyDestroyListener(){

            @Override
            public void onDestroyed() {
                DuplicatingBodyForwarder.this.isPrimarySinkClosed.set(true);
                DuplicatingBodyForwarder.this.handlePeerDestroy();
            }
        };
        primarySink.setDestroyListener(destroyListenerPrimary);
        IBodyDestroyListener destroyListenerSecondary = new IBodyDestroyListener(){

            @Override
            public void onDestroyed() {
                DuplicatingBodyForwarder.this.isSecondarySinkClosed.set(true);
                DuplicatingBodyForwarder.this.handlePeerDestroy();
            }
        };
        secondarySink.setDestroyListener(destroyListenerSecondary);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onData(NonBlockingBodyDataSource bodyDataSource) throws BufferUnderflowException {
        try {
            int available = 0;
            do {
                ByteBuffer[] buffers;
                try {
                    available = HttpClientConnection.availableSilence(bodyDataSource);
                }
                catch (IOException e) {
                    this.destroySinks();
                    return true;
                }
                if (available == -1) {
                    this.closeSinks();
                    return true;
                }
                if (available == 0) {
                    if (this.isPrimarySinkClosed.get()) {
                        if (this.isSecondarySinkClosed.get()) throw new ClosedChannelException();
                        this.write(this.secondarySink, this.isSecondarySinkClosed, NULL_BYTE_BUFFER);
                        continue;
                    }
                    if (!this.isSecondarySinkClosed.get()) {
                        this.write(this.secondarySink, this.isSecondarySinkClosed, NULL_BYTE_BUFFER);
                    }
                    this.write(this.primarySink, this.isPrimarySinkClosed, NULL_BYTE_BUFFER);
                    continue;
                }
                if (available <= 0) continue;
                ByteBuffer[] byteBufferArray = buffers = HttpClientConnection.readByteBufferByLengthSilence(bodyDataSource, available);
                int n = buffers.length;
                int n2 = 0;
                while (n2 < n) {
                    ByteBuffer buffer = byteBufferArray[n2];
                    if (this.isPrimarySinkClosed.get()) {
                        if (this.isSecondarySinkClosed.get()) throw new ClosedChannelException();
                        this.write(this.secondarySink, this.isSecondarySinkClosed, buffer);
                    } else {
                        if (!this.isSecondarySinkClosed.get()) {
                            this.write(this.secondarySink, this.isSecondarySinkClosed, buffer.duplicate());
                        }
                        this.write(this.primarySink, this.isPrimarySinkClosed, buffer);
                    }
                    ++n2;
                }
            } while (available > 0);
            return true;
        }
        catch (IOException e) {
            this.destroySinks();
        }
        return true;
    }

    private void write(ISink sink, AtomicBoolean isClosed, ByteBuffer buffer) {
        try {
            sink.onData(buffer);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + sink.getId() + "] error occured by writing data to " + sink + " " + ioe.toString());
            }
            isClosed.set(true);
            this.handlePeerDestroy();
        }
    }

    private void handlePeerDestroy() {
        if (this.isPrimarySinkClosed.get() && this.isSecondarySinkClosed.get()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("both data sink are closed. Destroying data source");
            }
            this.bodyDataSource.destroy();
        }
    }

    private void destroySinks() {
        if (!this.isPrimarySinkClosed.getAndSet(true)) {
            this.primarySink.destroy();
        }
        if (!this.isSecondarySinkClosed.getAndSet(true)) {
            this.secondarySink.destroy();
        }
    }

    private void closeSinks() throws IOException {
        if (!this.isPrimarySinkClosed.getAndSet(true)) {
            this.primarySink.close();
        }
        if (!this.isSecondarySinkClosed.getAndSet(true)) {
            this.secondarySink.close();
        }
    }

    static final class BodyDataSinkAdapter
    implements ISink {
        private final BodyDataSink dataSink;

        public BodyDataSinkAdapter(BodyDataSink dataSink) throws IOException {
            this.dataSink = dataSink;
        }

        @Override
        public void onData(ByteBuffer data) throws IOException {
            this.dataSink.write(data);
        }

        @Override
        public void close() throws IOException {
            this.dataSink.close();
        }

        @Override
        public void destroy() {
            this.dataSink.destroy();
        }

        @Override
        public void setDestroyListener(IBodyDestroyListener destroyListener) {
            this.dataSink.addDestroyListener(destroyListener);
        }

        @Override
        public String getId() {
            return "wrapped" + this.dataSink.getId();
        }
    }

    public static interface ISink
    extends Closeable {
        public void onData(ByteBuffer var1) throws IOException;

        public void setDestroyListener(IBodyDestroyListener var1);

        public void destroy();

        public String getId();
    }

    static class InMemorySink
    implements ISink {
        private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        private final int maxBufferSize;
        private int bufferSize = 0;
        private IBodyDestroyListener destroyListener = null;
        private boolean isDestroyed = false;
        private boolean isClosed = false;
        private ISink forwardSink = null;

        public InMemorySink() {
            this(Integer.MAX_VALUE);
        }

        public InMemorySink(int maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
        }

        @Override
        public synchronized void onData(ByteBuffer data) throws IOException {
            if (this.forwardSink == null) {
                this.bufferSize += data.remaining();
                this.buffers.add(data);
                if (this.bufferSize > this.maxBufferSize) {
                    this.onMaxBufferSizeExceeded();
                }
            } else {
                this.forwardSink.onData(data);
            }
        }

        void onMaxBufferSizeExceeded() {
            this.destroy();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.forwardSink == null) {
                this.isClosed = true;
            } else {
                this.forwardSink.close();
            }
        }

        public synchronized boolean isDestroyed() {
            return this.isDestroyed;
        }

        @Override
        public synchronized void destroy() {
            if (this.forwardSink == null) {
                this.isDestroyed = true;
                this.buffers.clear();
                this.callDestroyListener();
            } else {
                this.forwardSink.destroy();
            }
        }

        private void callDestroyListener() {
            block3: {
                IBodyDestroyListener ls = this.destroyListener;
                if (ls != null) {
                    try {
                        ls.onDestroyed();
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("Error occured by calling destroy listener");
                    }
                }
            }
        }

        @Override
        public String getId() {
            return "<unset>";
        }

        public synchronized int getSize() {
            int size = 0;
            for (ByteBuffer buffer : this.buffers) {
                size += buffer.remaining();
            }
            return size;
        }

        @Override
        public synchronized void setDestroyListener(IBodyDestroyListener destroyListener) {
            if (this.forwardSink == null) {
                this.destroyListener = destroyListener;
            } else {
                this.forwardSink.setDestroyListener(destroyListener);
            }
        }

        public synchronized boolean forwardTo(ISink sink) throws IOException {
            if (this.isDestroyed) {
                return false;
            }
            this.forwardSink = sink;
            if (this.destroyListener != null) {
                sink.setDestroyListener(this.destroyListener);
            }
            for (ByteBuffer buffer : this.buffers) {
                this.onData(buffer);
            }
            if (this.isClosed) {
                this.close();
            }
            return true;
        }
    }
}

