/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BodyDataSink;
import org.xlightweb.FutureResponseHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.Supports100Continue;
import org.xlightweb.client.HttpClientConnection;

@Supports100Continue
class FutureContinueResponseHandler
extends FutureResponseHandler {
    private static final Logger LOG = Logger.getLogger(FutureContinueResponseHandler.class.getName());
    private final IHttpRequestHeader requestHeader;
    private final NonBlockingBodyDataSource dataSource;
    private final String id;
    private BodyDataSink dataSink;
    private boolean isContinueReceived = false;

    public FutureContinueResponseHandler(IHttpRequestHeader requestHeader, NonBlockingBodyDataSource dataSource, String id) {
        this.requestHeader = requestHeader;
        this.dataSource = dataSource;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(IHttpResponse response) throws IOException {
        if (response.getStatus() == 100) {
            if (this.isContinueReceived) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] got a second 100-continue response. Ignoring it");
                }
            } else {
                FutureContinueResponseHandler futureContinueResponseHandler = this;
                synchronized (futureContinueResponseHandler) {
                    this.isContinueReceived = true;
                    this.onContinueResponse();
                }
            }
        } else {
            this.onNon100Response(response);
        }
    }

    void onNon100Response(IHttpResponse response) throws IOException {
        if (this.isContinueReceived) {
            response.setAttribute("org.xlightweb.HttpClientConnection.100-continueReceived", true);
        }
        super.onResponse(response);
    }

    public void onContinueResponse() throws IOException {
        if (this.isContinueReceived && this.dataSink != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.id + "] got 100-continue response. Sending request body data");
            }
            this.requestHeader.setAttribute("org.xlightweb.HttpClientConnection.100-continue.bodytransfered", true);
            HttpClientConnection.forward(this.dataSource, this.dataSink);
            this.dataSink = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBodyDataSink(BodyDataSink dataSink) throws IOException {
        FutureContinueResponseHandler futureContinueResponseHandler = this;
        synchronized (futureContinueResponseHandler) {
            this.dataSink = dataSink;
            this.onContinueResponse();
        }
    }
}

