/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xlightweb.BodyDataSink;
import org.xlightweb.CacheHandler;
import org.xlightweb.EventDataSource;
import org.xlightweb.FutureResponseHandler;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpUtils;
import org.xlightweb.IEventDataSource;
import org.xlightweb.IEventHandler;
import org.xlightweb.IFutureResponse;
import org.xlightweb.IHttpConnectHandler;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IWebSocketConnection;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.InvokeOn;
import org.xlightweb.RequestHandlerChain;
import org.xlightweb.WebSocketConnection;
import org.xlightweb.client.CookieHandler;
import org.xlightweb.client.FutureContinueResponseHandler;
import org.xlightweb.client.HttpClientConnection;
import org.xlightweb.client.IHttpClientEndpoint;
import org.xlightweb.client.ProxyHandler;
import org.xlightweb.client.RedirectHandler;
import org.xlightweb.client.RetryHandler;
import org.xlightweb.client.SessionManager;
import org.xlightweb.client.TransactionMonitor;
import org.xsocket.ILifeCycle;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.NonBlockingConnectionPool;

public class HttpClient
implements IHttpClientEndpoint,
IConnectionPool,
Closeable {
    private static final Logger LOG = Logger.getLogger(HttpClient.class.getName());
    public static final int DEFAULT_CREATION_MAX_WAIT_TIMEOUT = 60000;
    public static final int DEFAULT_POOLED_LIFE_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_POOLED_IDLE_TIMEOUT_MILLIS = 3000;
    public static final boolean DEFAULT_TREAT_302_REDIRECT_AS_303 = false;
    public static final boolean DEFAULT_AUTOCONFIRM_REDIRECT = false;
    public static final Long DEFAULT_RESPONSE_TIMEOUT_SEC = Long.MAX_VALUE;
    private final AtomicBoolean isTreat302RedirectAs303 = new AtomicBoolean(false);
    private final AtomicInteger connectTimeoutMillis = new AtomicInteger(60000);
    private String defaultEncoding = IHttpMessage.DEFAULT_ENCODING;
    private static final int DEFAULT_PERSISTENT_CONNECTION_TIMEOUT = 10000;
    private final AtomicLong responseTimeoutMillis = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong bodyDataReceiveTimeoutMillis = new AtomicLong(Long.MAX_VALUE);
    private static final boolean DEDFAULT_AUTO_UNCOMPRESS = Boolean.parseBoolean(System.getProperty("org.xlightweb.client.response.isAutouncompressActivated", "true"));
    private final AtomicBoolean isAutoUncompress = new AtomicBoolean(DEDFAULT_AUTO_UNCOMPRESS);
    private final AtomicBoolean isAutoCloseAfterResponse = new AtomicBoolean(true);
    private final NonBlockingConnectionPool pool;
    private final AtomicBoolean isCallReturnOnMessage = new AtomicBoolean(false);
    public static final int DEFAULT_MAX_REDIRECTS = Integer.parseInt(System.getProperty("org.xlightweb.client.maxRedirects", "5"));
    public static final boolean DEFAULT_FOLLOWS_REDIRECT = Boolean.parseBoolean(System.getProperty("org.xlightweb.client.autoredirect", "false"));
    public static final FollowsRedirectMode DEFAULT_FOLLOWS_REDIRECTMODE = FollowsRedirectMode.valueOf(System.getProperty("org.xlightweb.client.autoredirect", FollowsRedirectMode.OFF.toString()));
    private final AtomicReference<FollowsRedirectMode> followsRedirectModeRef = new AtomicReference<FollowsRedirectMode>(DEFAULT_FOLLOWS_REDIRECTMODE);
    private final AtomicInteger maxRedirects = new AtomicInteger(DEFAULT_MAX_REDIRECTS);
    private final RedirectHandler redirectHandler;
    public static final int DEFAULT_MAX_RETRIES = Integer.parseInt(System.getProperty("org.xlightweb.client.maxRetries", "4"));
    private final AtomicInteger maxRetries = new AtomicInteger(DEFAULT_MAX_RETRIES);
    private final RetryHandler retryHandler;
    public static final boolean DEFAULT_AUTOHANDLING_COOKIES = true;
    private final AtomicBoolean isAutohandlingCookies = new AtomicBoolean(true);
    private final CookieHandler cookiesHandler;
    public static final boolean DEFAULT_PROXY_ACTIVATED = false;
    private final AtomicBoolean isProxyActivated = new AtomicBoolean(false);
    private final ProxyHandler proxyHandler;
    public static final int DEFAULT_CACHE_SIZE = 0;
    private final CacheHandler cacheHandler;
    private boolean isShowCache = false;
    private final RequestHandlerChain chain = new RequestHandlerChain();
    private SessionManager sessionManager = null;
    private long lastTimeRequestSentMillis = System.currentTimeMillis();
    private TransactionMonitor transactionMonitor = null;
    private final TransactionMonitor.TransactionLog transactionLog = new TransactionMonitor.TransactionLog(0);

    public HttpClient() {
        this((SSLContext)null, new IHttpRequestHandler[0]);
    }

    public HttpClient(IHttpRequestHandler ... interceptors) {
        this((SSLContext)null, interceptors);
    }

    public HttpClient(SSLContext sslCtx) {
        this(sslCtx, new IHttpRequestHandler[0]);
    }

    public HttpClient(SSLContext sslCtx, IHttpRequestHandler ... interceptors) {
        this.pool = new NonBlockingConnectionPool(sslCtx);
        this.pool.setPooledMaxIdleTimeMillis(10000);
        this.setPooledMaxIdleTimeMillis(3000);
        this.setPooledMaxLifeTimeMillis(30000);
        this.sessionManager = new SessionManager();
        this.retryHandler = new RetryHandler(this);
        this.cacheHandler = new CacheHandler(0);
        this.redirectHandler = new RedirectHandler(this);
        this.cookiesHandler = new CookieHandler();
        this.proxyHandler = new ProxyHandler(this);
        IHttpRequestHandler[] iHttpRequestHandlerArray = interceptors;
        int n = interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            IHttpRequestHandler interceptor = iHttpRequestHandlerArray[n2];
            this.addInterceptor(interceptor);
            ++n2;
        }
        this.resetChain();
        this.chain.onInit();
    }

    NonBlockingConnectionPool getUnderlyingConnectionPool() {
        return this.pool;
    }

    public void addInterceptor(IHttpRequestHandler interceptor) {
        if (interceptor instanceof ILifeCycle) {
            ((ILifeCycle)((Object)interceptor)).onInit();
        }
        if (!HttpUtils.isConnectHandlerWarningIsSuppressed() && interceptor instanceof IHttpConnectHandler) {
            LOG.warning("only IHttpRequestHandler is supported. The onConnect(...) method will not be called. (suppress this warning by setting system property org.xlightweb.httpConnectHandler.suppresswarning=true)");
        }
        this.chain.addLast(interceptor);
        this.resetChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetChain() {
        HttpClient httpClient = this;
        synchronized (httpClient) {
            this.chain.remove(this.retryHandler);
            this.chain.remove(this.cacheHandler);
            this.chain.remove(this.cookiesHandler);
            this.chain.remove(this.redirectHandler);
            this.chain.remove(this.proxyHandler);
            if (this.getMaxRetries() > 0) {
                this.chain.addFirst(this.retryHandler);
            }
            if (this.cacheHandler.getMaxCacheSizeKB() > 0) {
                for (IHttpRequestHandler hdl : this.chain.getHandlers()) {
                    if (!(hdl instanceof CacheHandler)) continue;
                    LOG.warning("a cache handler is already activated. Adding another one (setting HttpClient's cacheMaxSizeKB larger than zero adds a cache handler automatically)");
                }
                this.chain.addFirst(this.cacheHandler);
            }
            if (this.followsRedirectModeRef.get() != FollowsRedirectMode.OFF) {
                this.chain.addFirst(this.redirectHandler);
            }
            if (this.isAutohandlingCookies.get()) {
                this.chain.addFirst(this.cookiesHandler);
            }
            if (this.isProxyActivated.get()) {
                this.chain.addLast(this.proxyHandler);
            }
        }
    }

    public void setFollowsRedirect(boolean isFollowsRedirect) {
        if (isFollowsRedirect) {
            this.setFollowsRedirectMode(FollowsRedirectMode.ALL);
        } else {
            this.setFollowsRedirectMode(FollowsRedirectMode.OFF);
        }
    }

    public boolean getFollowsRedirect() {
        return this.getFollowsRedirectMode() == FollowsRedirectMode.ALL;
    }

    public void setFollowsRedirectMode(String mode) {
        this.setFollowsRedirectMode(FollowsRedirectMode.valueOf(mode));
    }

    public void setFollowsRedirectMode(FollowsRedirectMode mode) {
        if (this.followsRedirectModeRef.get() == mode) {
            return;
        }
        this.followsRedirectModeRef.set(mode);
        this.resetChain();
    }

    public FollowsRedirectMode getFollowsRedirectMode() {
        return this.followsRedirectModeRef.get();
    }

    public void setAutoHandleCookies(boolean isAutohandlingCookies) {
        if (this.isAutohandlingCookies.get() == isAutohandlingCookies) {
            return;
        }
        this.isAutohandlingCookies.set(isAutohandlingCookies);
        this.resetChain();
    }

    public void setCacheMaxSizeKB(int maxSizeKB) {
        this.cacheHandler.setMaxCacheSizeKB(maxSizeKB);
        this.resetChain();
    }

    public int getCacheMaxSizeKB() {
        return this.cacheHandler.getMaxCacheSizeKB();
    }

    public float getCacheSizeKB() {
        return (float)this.cacheHandler.getCurrentCacheSizeBytes() / 1000.0f;
    }

    public void setCacheShared(boolean isSharedCache) {
        this.cacheHandler.setSharedCache(isSharedCache);
    }

    public boolean isCacheShared() {
        return this.cacheHandler.isSharedCache();
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHandler.setProxyHost(proxyHost);
        if (proxyHost != null && proxyHost.length() > 1) {
            this.isProxyActivated.set(true);
        }
        this.resetChain();
    }

    public void setProxyPort(int proxyPort) {
        this.proxyHandler.setProxyPort(proxyPort);
    }

    public void setProxyUser(String proxyUser) {
        this.proxyHandler.setProxyUser(proxyUser);
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyHandler.setProxyPassword(proxyPassword);
    }

    public boolean isAutohandleCookies() {
        return this.isAutohandlingCookies.get();
    }

    public final void setAutoUncompress(boolean isAutoUncompress) {
        this.isAutoUncompress.set(isAutoUncompress);
    }

    public final boolean isAutoUncompress() {
        return this.isAutoUncompress.get();
    }

    SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects.set(maxRedirects);
    }

    public int getMaxRedirects() {
        return this.maxRedirects.get();
    }

    public int getMaxRetries() {
        return this.maxRetries.get();
    }

    public void setMaxRetries(int maxRetries) {
        if (maxRetries > 0) {
            this.maxRetries.set(maxRetries);
        } else {
            this.maxRetries.set(0);
        }
        this.resetChain();
    }

    public void setTreat302RedirectAs303(boolean isTreat303RedirectAs302) {
        this.isTreat302RedirectAs303.set(isTreat303RedirectAs302);
    }

    public boolean isTreat302RedirectAs303() {
        return this.isTreat302RedirectAs303.get();
    }

    int getTransactionLogMaxSize() {
        return this.transactionLog.getMaxSize();
    }

    Integer getTransactionsPending() {
        if (this.transactionMonitor != null) {
            return this.transactionMonitor.getPendingTransactions();
        }
        return null;
    }

    void setTransactionLogMaxSize(int maxSize) {
        this.transactionLog.setMaxSize(maxSize);
        this.transactionMonitor = maxSize == 0 ? null : new TransactionMonitor(this.transactionLog);
    }

    public void setWorkerpool(Executor workerpool) {
        this.pool.setWorkerpool(workerpool);
    }

    Executor getWorkerpool() {
        return this.pool.getWorkerpool();
    }

    public void setResponseBodyDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setCallReturnOnMessage(boolean isCallReturnOnMessage) {
        this.isCallReturnOnMessage.set(isCallReturnOnMessage);
    }

    public boolean getCallReturnOnMessage() {
        return this.isCallReturnOnMessage.get();
    }

    @Override
    public void setResponseTimeoutMillis(long responseTimeoutMillis) {
        this.responseTimeoutMillis.set(responseTimeoutMillis);
    }

    @Override
    public long getResponseTimeoutMillis() {
        return this.responseTimeoutMillis.get();
    }

    public final void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        this.bodyDataReceiveTimeoutMillis.set(bodyDataReceiveTimeoutMillis);
    }

    public final long getBodyDataReceiveTimeoutMillis() {
        return this.bodyDataReceiveTimeoutMillis.get();
    }

    @Override
    public void close() throws IOException {
        this.pool.close();
        this.chain.onDestroy();
        if (this.sessionManager != null) {
            this.sessionManager.close();
            this.sessionManager = null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.pool.isOpen();
    }

    @Override
    public String getId() {
        return Integer.toString(this.hashCode());
    }

    @Override
    public void addListener(ILifeCycle listener) {
        this.pool.addListener(listener);
    }

    @Override
    public boolean removeListener(ILifeCycle listener) {
        return this.pool.removeListener(listener);
    }

    @Override
    public void setPooledMaxIdleTimeMillis(int idleTimeoutMillis) {
        this.pool.setPooledMaxIdleTimeMillis(idleTimeoutMillis);
    }

    @Override
    public int getPooledMaxIdleTimeMillis() {
        return this.pool.getPooledMaxIdleTimeMillis();
    }

    @Override
    public void setPooledMaxLifeTimeMillis(int lifeTimeoutMillis) {
        this.pool.setPooledMaxLifeTimeMillis(lifeTimeoutMillis);
    }

    @Override
    public int getPooledMaxLifeTimeMillis() {
        return this.pool.getPooledMaxLifeTimeMillis();
    }

    @Override
    public void setMaxIdle(int maxIdle) {
        this.pool.setMaxIdle(maxIdle);
    }

    @Override
    public int getMaxIdle() {
        return this.pool.getMaxIdle();
    }

    @Override
    public void setMaxActive(int maxActive) {
        this.pool.setMaxActive(maxActive);
    }

    @Override
    public int getMaxActivePerServer() {
        return this.pool.getMaxActivePerServer();
    }

    @Override
    public void setMaxActivePerServer(int maxActivePerServer) {
        this.pool.setMaxActivePerServer(maxActivePerServer);
    }

    @Override
    public int getMaxActive() {
        return this.pool.getMaxActive();
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis.set(connectTimeoutMillis);
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis.get();
    }

    @Override
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    @Override
    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    int getNumPendingGet() {
        return this.pool.getNumPendingGet();
    }

    @Override
    public int getNumCreated() {
        return this.pool.getNumCreated();
    }

    @Override
    public int getNumDestroyed() {
        return this.pool.getNumDestroyed();
    }

    int getNumCreationError() {
        return this.pool.getNumCreationError();
    }

    @Override
    public int getNumTimeoutPooledMaxIdleTime() {
        return this.pool.getNumTimeoutPooledMaxIdleTime();
    }

    @Override
    public int getNumTimeoutPooledMaxLifeTime() {
        return this.pool.getNumTimeoutPooledMaxLifeTime();
    }

    public Integer getAcquireTimeoutMillis() {
        return this.pool.getAcquireTimeoutMillis();
    }

    public void setAcquireTimeoutMillis(Integer aquireTimeoutMillis) {
        this.pool.setAcquireTimeoutMillis(aquireTimeoutMillis);
    }

    public int getNumCacheHit() {
        return this.cacheHandler.getCountCacheHit();
    }

    public int getNumCacheMiss() {
        return this.cacheHandler.getCountCacheMiss();
    }

    @Override
    public List<String> getActiveConnectionInfos() {
        return this.pool.getActiveConnectionInfos();
    }

    @Override
    public List<String> getIdleConnectionInfos() {
        return this.pool.getIdleConnectionInfos();
    }

    boolean isCacheInfoDisplay() {
        return this.isShowCache;
    }

    void setCacheInfoDisplay(boolean isShowCache) {
        this.isShowCache = isShowCache;
    }

    List<String> getCacheInfo() {
        if (this.isShowCache) {
            return this.cacheHandler.getCacheInfo();
        }
        return null;
    }

    double getCacheHitRatio() {
        return this.cacheHandler.getCurrentHitRatio();
    }

    List<String> getTransactionInfos() {
        ArrayList<String> result = new ArrayList<String>();
        for (TransactionMonitor.Transaction transaction : this.transactionLog.getTransactions()) {
            result.add(transaction.toString());
        }
        return result;
    }

    @Override
    public IHttpResponse call(IHttpRequest request) throws IOException, SocketTimeoutException {
        if (this.isCallReturnOnMessage.get()) {
            try {
                request.setAttribute("org.xlightweb.client.RetryHandler.retry", false);
                FutureMessageResponseHandler responseHandler = new FutureMessageResponseHandler(request);
                this.send(request, (IHttpResponseHandler)responseHandler);
                return responseHandler.getResponse();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        try {
            IFutureResponse futureResponse = this.send(request);
            return futureResponse.getResponse();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public IFutureResponse send(IHttpRequest request) throws IOException, ConnectException {
        if (request.hasBody() && HttpUtils.isContainsExpect100ContinueHeader(request)) {
            if (HttpClientConnection.isNetworkendpoint(request.getNonBlockingBody())) {
                request.setAttribute("org.xlightweb.HttpClientConnection.isAutocontinueDeactivated", true);
            }
            if (request.getAttribute("org.xlightweb.HttpClientConnection.isAutocontinueDeactivated") == null || !((Boolean)request.getAttribute("org.xlightweb.HttpClientConnection.isAutocontinueDeactivated")).booleanValue()) {
                FutureContinueResponseHandler responseHandler = new FutureContinueResponseHandler(request.getRequestHeader(), request.getNonBlockingBody(), this.getId());
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("sending header (body will send after receiving the 100 continue response)");
                }
                BodyDataSink dataSink = this.send(request.getRequestHeader(), (IHttpResponseHandler)responseHandler);
                dataSink.setFlushmode(IConnection.FlushMode.ASYNC);
                responseHandler.setBodyDataSink(dataSink);
                dataSink.flush();
                return responseHandler;
            }
        }
        FutureResponseHandler responseHandler = new FutureResponseHandler();
        this.send(request, (IHttpResponseHandler)responseHandler);
        return responseHandler;
    }

    @Override
    public void send(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        this.lastTimeRequestSentMillis = System.currentTimeMillis();
        if (!HttpClientConnection.isSupports100Contine(responseHandler) && HttpUtils.isContainExpect100ContinueHeader(request.getRequestHeader())) {
            request.getNonBlockingBody().getReadBufferVersion();
            LOG.warning("Request contains 'Excect: 100-coninue' header and response handler is not annotated with Supports100Continue. Removing Expect header");
            request.removeHeader("Expect");
        }
        if (this.transactionMonitor != null) {
            this.transactionMonitor.register(request.getRequestHeader());
        }
        HttpClientConnection.ClientExchange clientExchange = new HttpClientConnection.ClientExchange(this.defaultEncoding, this.pool, this.sessionManager, responseHandler, request, this.connectTimeoutMillis.get(), this.responseTimeoutMillis.get(), this.bodyDataReceiveTimeoutMillis.get(), this.isAutoCloseAfterResponse.get(), this.isAutoUncompress.get(), this.transactionMonitor);
        this.chain.onRequest(clientExchange);
    }

    @Override
    public BodyDataSink send(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        requestHeader.setContentLength(contentLength);
        return this.sendInternal(requestHeader, responseHandler);
    }

    @Override
    public BodyDataSink send(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        if (requestHeader.getContentLength() != -1) {
            return this.send(requestHeader, requestHeader.getContentLength(), responseHandler);
        }
        if (requestHeader.getTransferEncoding() == null) {
            requestHeader.setHeader("Transfer-Encoding", "chunked");
        }
        return this.sendInternal(requestHeader, responseHandler);
    }

    private BodyDataSink sendInternal(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        this.lastTimeRequestSentMillis = System.currentTimeMillis();
        BodyDataSink dataSink = HttpClientConnection.newInMemoryBodyDataSink(String.valueOf(this.getClass().getSimpleName()) + "#" + this.hashCode(), requestHeader);
        HttpRequest request = new HttpRequest(requestHeader, HttpClientConnection.getDataSourceOfInMemoryBodyDataSink(dataSink));
        this.send(request, responseHandler);
        return dataSink;
    }

    long getLastTimeRequestSentMillis() {
        return this.lastTimeRequestSentMillis;
    }

    public IEventDataSource openEventDataSource(String uriString, String ... headerlines) throws IOException {
        return this.openEventDataSource(uriString, true, headerlines);
    }

    public IEventDataSource openEventDataSource(String uriString, boolean isIgnoreCommentMessage) throws IOException {
        return this.openEventDataSource(uriString, isIgnoreCommentMessage, new String[0]);
    }

    public IEventDataSource openEventDataSource(String uriString, boolean isIgnoreCommentMessage, String ... headerlines) throws IOException {
        return this.openEventDataSource(uriString, isIgnoreCommentMessage, (IEventHandler)null, headerlines);
    }

    public IEventDataSource openEventDataSource(String uriString, IEventHandler webEventHandler, String ... headerlines) throws IOException {
        return new EventDataSource(this, uriString, true, webEventHandler, headerlines);
    }

    public IEventDataSource openEventDataSource(String uriString, boolean isIgnoreCommentMessage, IEventHandler webEventHandler, String ... headerlines) throws IOException {
        return new EventDataSource(this, uriString, isIgnoreCommentMessage, webEventHandler, headerlines);
    }

    public IWebSocketConnection openWebSocketConnection(String uriString) throws IOException {
        return this.openWebSocketConnection(uriString, (String)null);
    }

    public IWebSocketConnection openWebSocketConnection(String uriString, String protocol) throws IOException {
        return this.openWebSocketConnection(uriString, protocol, null);
    }

    public IWebSocketConnection openWebSocketConnection(String uriString, IWebSocketHandler webSocketHandler) throws IOException {
        return this.openWebSocketConnection(uriString, null, webSocketHandler);
    }

    public IWebSocketConnection openWebSocketConnection(String uriString, String protocol, IWebSocketHandler webSocketHandler) throws IOException {
        URI uri = URI.create(uriString);
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().toLowerCase().equals("wss") ? 443 : 80;
        }
        return new WebSocketConnection(this, uri, protocol, webSocketHandler);
    }

    public int getMaxWaiting() {
        return 0;
    }

    public boolean isPooled() {
        return false;
    }

    public void setPooled(boolean isPooled) {
        if (!isPooled) {
            LOG.warning("isPooled is deprecated and will be ignored");
        }
    }

    public void setMaxWaiting(int maxWaiting) {
        LOG.warning("maxWaiting is deprecated and will be ignored");
    }

    public long getCreationMaxWaitMillis() {
        return 0L;
    }

    public void setCreationMaxWaitMillis(long maxWaitMillis) {
        LOG.warning("creationMaxWaitMillis is deprecated and will be ignored");
    }

    public void setProxySecuredHost(String proxyHost) {
        this.proxyHandler.setSecuredProxyHost(proxyHost);
        if (proxyHost != null && proxyHost.length() > 1) {
            this.isProxyActivated.set(true);
        }
        this.resetChain();
    }

    public void setProxySecuredPort(int proxyPort) {
        this.proxyHandler.setSecuredProxyPort(proxyPort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\r\nnumCreatedConnections " + this.getNumCreated());
        sb.append("\r\nnumCreationError " + this.getNumCreationError());
        sb.append("\r\nnumDestroyedConnections " + this.getNumDestroyed());
        List<String> active = this.getActiveConnectionInfos();
        if (active.isEmpty()) {
            sb.append("\r\nnumActiveConnections 0");
        } else {
            sb.append("\r\n" + active.size() + " active connections:");
            for (String connectionInfo : this.getActiveConnectionInfos()) {
                sb.append("\r\n " + connectionInfo);
            }
        }
        List<String> idle = this.getActiveConnectionInfos();
        if (idle.isEmpty()) {
            sb.append("\r\nnumIdleConnections 0");
        } else {
            sb.append("\r\n" + idle.size() + " idle connections:");
            for (String connectionInfo : this.getIdleConnectionInfos()) {
                sb.append("\r\n " + connectionInfo);
            }
        }
        sb.append("\r\ntransaction log:");
        for (String transactionInfo : this.getTransactionInfos()) {
            sb.append("\r\n " + transactionInfo);
        }
        return sb.toString();
    }

    public static enum FollowsRedirectMode {
        OFF,
        RFC,
        ALL;

    }

    @InvokeOn(value=1)
    private final class FutureMessageResponseHandler
    extends FutureResponseHandler {
        private final IHttpRequest request;
        private final int currentRetryNum;

        public FutureMessageResponseHandler(IHttpRequest request) {
            this.request = request;
            Integer numReq = (Integer)request.getAttribute("org.xlightweb.client.FutureMessageResponseHandler.currentRetryNum");
            if (numReq == null) {
                numReq = 0;
            }
            this.currentRetryNum = numReq + 1;
            request.setAttribute("org.xlightweb.client.FutureMessageResponseHandler.currentRetryNum", this.currentRetryNum);
        }

        @Override
        public void onException(IOException ioe) throws IOException {
            if (this.isRetryableMethod() && RetryHandler.isRetryable(ioe)) {
                if (this.currentRetryNum < HttpClient.this.getMaxRetries()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("try to retrying request (retry num " + this.currentRetryNum + "). I/O exception  caught when processing request " + ioe.toString());
                    }
                    this.retry();
                    return;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("max retries " + HttpClient.this.getMaxRetries() + ". I/O exception  caught when processing request " + ioe.toString());
                }
            }
            super.onException(ioe);
        }

        @Override
        public void onException(SocketTimeoutException stoe) {
            if (this.isRetryableMethod()) {
                if (this.currentRetryNum < HttpClient.this.getMaxRetries()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("try to retrying request (retry num " + this.currentRetryNum + "). I/O exception  caught when processing request " + stoe.toString());
                    }
                    this.retry();
                    return;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("max retries " + HttpClient.this.getMaxRetries() + ". I/O exception  caught when processing request " + stoe.toString());
                }
            }
            super.onException(stoe);
        }

        private void retry() {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            IHttpResponse response = HttpClient.this.call(FutureMessageResponseHandler.this.request);
                            FutureMessageResponseHandler.this.onResponse(response);
                        }
                        catch (IOException ioe) {
                            try {
                                FutureMessageResponseHandler.super.onException(ioe);
                            }
                            catch (IOException e) {
                                if (!LOG.isLoggable(Level.FINE)) break block4;
                                LOG.fine("error occured by calling onException " + e.toString());
                            }
                        }
                    }
                }
            };
            HttpClient.this.getWorkerpool().execute(task);
        }

        private boolean isRetryableMethod() {
            return this.request.getMethod().equalsIgnoreCase("GET");
        }
    }
}

